/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import team.lodestar.lodestone.command.arguments.WorldEventTypeArgument;
import team.lodestar.lodestone.component.LodestoneComponents;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;
import team.lodestar.lodestone.systems.worldevent.WorldEventType;

public class ListActiveWorldEventsCommand {
    private static final int whitespaceWidth = 20;
    private static final int ITEMS_PER_PAGE = 10;
    private static final int currentPage = 0;

    public static LiteralArgumentBuilder<class_2168> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(cs -> cs.method_9259(2))).then(class_2170.method_9247((String)"all").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3218 level = source.method_9225();
            ActiveWorldEventReport report = new ActiveWorldEventReport(level);
            report.buildInteractiveMessage(component -> source.method_9226(() -> component, true), 0);
            return 1;
        }))).then(class_2170.method_9247((String)"type").then(class_2170.method_9244((String)"worldEventType", (ArgumentType)WorldEventTypeArgument.worldEventType()).executes(ctx -> {
            WorldEventType worldEventType = WorldEventTypeArgument.getEventType(ctx, "worldEventType");
            class_2168 source = (class_2168)ctx.getSource();
            class_3218 level = source.method_9225();
            ActiveWorldEventReport report = new ActiveWorldEventReport(level, worldEventType);
            report.buildInteractiveMessage(component -> source.method_9226(() -> component, true), 0);
            return 1;
        })))).then(class_2170.method_9247((String)"page").then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            int page = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page");
            class_2168 source = (class_2168)ctx.getSource();
            class_3218 level = source.method_9225();
            ActiveWorldEventReport report = new ActiveWorldEventReport(level);
            report.buildInteractiveMessage(component -> source.method_9226(() -> component, true), page);
            return 1;
        })));
    }

    protected static class ActiveWorldEventReport {
        private int instanceCount;
        private int frozenCount;
        private List<WorldEventInstance> activeWorldEvents;

        protected ActiveWorldEventReport(class_3218 level) {
            LodestoneComponents.LODESTONE_WORLD_COMPONENT.maybeGet((Object)level).ifPresent(c -> {
                this.instanceCount = c.activeWorldEvents.size();
                this.frozenCount = (int)c.activeWorldEvents.stream().filter(WorldEventInstance::isFrozen).count();
                this.activeWorldEvents = c.activeWorldEvents;
            });
        }

        protected ActiveWorldEventReport(class_3218 level, WorldEventType worldEventType) {
            LodestoneComponents.LODESTONE_WORLD_COMPONENT.maybeGet((Object)level).ifPresent(c -> {
                this.instanceCount = (int)c.activeWorldEvents.stream().filter(worldEventInstance -> worldEventInstance.type.equals(worldEventType)).count();
                this.frozenCount = (int)c.activeWorldEvents.stream().filter(worldEventInstance -> worldEventInstance.type.equals(worldEventType) && worldEventInstance.isFrozen()).count();
                this.activeWorldEvents = c.activeWorldEvents;
            });
        }

        private void buildInteractiveMessage(Consumer<class_2561> consumer, int page) {
            this.buildHeader(consumer);
            this.buildInteractiveIndexPage(consumer, page);
            this.buildInteractiveFooter(consumer, page);
        }

        private void buildInteractiveIndexPage(Consumer<class_2561> consumer, int page) {
            int startIndex = page * 10;
            int endIndex = Math.min(startIndex + 10, this.activeWorldEvents.size());
            for (int i = startIndex; i < endIndex; ++i) {
                WorldEventInstance event = this.activeWorldEvents.get(i);
                class_5250 eventComponent = class_2561.method_43470((String)String.format("%02d. | %s | ", i + 1, event.type.id.toString())).method_27696(class_2583.field_24360.method_10977(i % 2 == 1 ? class_124.field_1080 : class_124.field_1068).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)event.toString()))));
                class_5250 detailsButton = class_2561.method_43470((String)"[>]").method_27696(class_2583.field_24360.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11750, "/lodestone worldevent get " + event.uuid.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to see details"))));
                class_5250 freezeButton = class_2561.method_43470((String)"[F]").method_27696(class_2583.field_24360.method_10977(class_124.field_1075).method_10958(new class_2558(class_2558.class_2559.field_11750, "/lodestone worldevent freeze single " + event.uuid.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to freeze"))));
                class_5250 unfreezeButton = class_2561.method_43470((String)"[U]").method_27696(class_2583.field_24360.method_10977(class_124.field_1062).method_10958(new class_2558(class_2558.class_2559.field_11750, "/lodestone worldevent unfreeze single " + event.uuid.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to unfreeze"))));
                class_5250 removeButton = class_2561.method_43470((String)"[X]").method_27696(class_2583.field_24360.method_10977(class_124.field_1061).method_10958(new class_2558(class_2558.class_2559.field_11750, "/lodestone worldevent remove single " + event.uuid.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to remove"))));
                class_5250 space = class_2561.method_43470((String)"  ");
                consumer.accept((class_2561)eventComponent.method_10852((class_2561)space).method_10852((class_2561)detailsButton).method_10852((class_2561)space).method_10852((class_2561)(event.isFrozen() ? unfreezeButton : freezeButton)).method_10852((class_2561)space).method_10852((class_2561)removeButton));
            }
        }

        protected void buildInstanceDetailsPage(Consumer<class_2561> consumer, WorldEventInstance worldEventInstance) {
            class_5250 worldEventDetailsHeader = class_2561.method_43470((String)"World Event Details:").method_27696(class_2583.field_24360.method_10977(class_124.field_1065).method_10982(Boolean.valueOf(true)));
            class_5250 worldEventUUID = class_2561.method_43470((String)"UUID: ").method_27696(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)worldEventInstance.uuid.toString()).method_27696(class_2583.field_24360.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_21462, worldEventInstance.uuid.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to copy")))));
            class_5250 worldEventType = class_2561.method_43470((String)"Type: ").method_27696(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)worldEventInstance.type.id.toString()).method_27696(class_2583.field_24360.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11750, "/lodestone worldevent list type " + worldEventInstance.type.id.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to filter by type")))));
            class_5250 frozenStatus = class_2561.method_43470((String)"Frozen: ").method_27696(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)(worldEventInstance.isFrozen() ? "Yes" : "No")).method_27696(class_2583.field_24360.method_10977(worldEventInstance.isFrozen() ? class_124.field_1062 : class_124.field_1060)));
            class_5250 worldEventData = class_2561.method_43470((String)"Data:").method_27696(class_2583.field_24360.method_10977(class_124.field_1065));
            this.buildWhitespace(consumer);
            consumer.accept((class_2561)ActiveWorldEventReport.getDashedLine().method_27696(class_2583.field_24360.method_10977(class_124.field_1065)));
            consumer.accept((class_2561)worldEventDetailsHeader);
            consumer.accept((class_2561)worldEventUUID);
            consumer.accept((class_2561)worldEventType);
            consumer.accept((class_2561)frozenStatus);
            consumer.accept((class_2561)ActiveWorldEventReport.getDashedSpaceLine().method_27696(class_2583.field_24360.method_10977(class_124.field_1054)));
            consumer.accept((class_2561)worldEventData);
            this.buildDetailsBody(consumer, worldEventInstance.serializeNBT(new class_2487()));
            consumer.accept((class_2561)ActiveWorldEventReport.getDashedLine().method_27696(class_2583.field_24360.method_10977(class_124.field_1065)));
            this.buildInteractiveFooter(consumer, worldEventInstance);
        }

        private void buildDetailsBody(Consumer<class_2561> consumer, class_2487 tag) {
            tag.field_11515.forEach((key, value) -> {
                if (key.equals("uuid") || key.equals("type") || key.equals("discarded") || key.equals("frozen")) {
                    return;
                }
                class_5250 keyComponent = class_2561.method_43470((String)(key + ": ")).method_27696(class_2583.field_24360.method_10977(class_124.field_1060));
                class_5250 valueComponent = class_2561.method_43470((String)value.toString()).method_27696(class_2583.field_24360.method_10977(class_124.field_1068));
                consumer.accept((class_2561)keyComponent.method_10852((class_2561)valueComponent));
            });
        }

        private void buildInteractiveFooter(Consumer<class_2561> consumer, WorldEventInstance instance) {
            class_5250 backButton = class_2561.method_43470((String)"[Back]").method_27696(class_2583.field_24360.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11750, "/lodestone worldevent list page 0")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Back to World Event List"))));
            class_5250 freezeButton = class_2561.method_43470((String)"[Freeze]").method_27696(class_2583.field_24360.method_10977(class_124.field_1058).method_10958(new class_2558(class_2558.class_2559.field_11750, "/lodestone worldevent freeze single " + instance.uuid.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Freeze this World Event"))));
            class_5250 unfreezeButton = class_2561.method_43470((String)"[Unfreeze]").method_27696(class_2583.field_24360.method_10977(class_124.field_1062).method_10958(new class_2558(class_2558.class_2559.field_11750, "/lodestone worldevent unfreeze single " + instance.uuid.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Unfreeze this World Event"))));
            class_5250 removeButton = class_2561.method_43470((String)"[Remove]").method_27696(class_2583.field_24360.method_10977(class_124.field_1061).method_10958(new class_2558(class_2558.class_2559.field_11750, "/lodestone worldevent remove single " + instance.uuid.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Remove this World Event"))));
            class_5250 reloadButton = class_2561.method_43470((String)"[Reload]").method_27696(class_2583.field_24360.method_10977(class_124.field_1054).method_10958(new class_2558(class_2558.class_2559.field_11750, "/lodestone worldevent get " + instance.uuid.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Reload this World Event"))));
            consumer.accept((class_2561)backButton.method_27693("  ").method_10852((class_2561)(instance.isFrozen() ? unfreezeButton : freezeButton)).method_27693("  ").method_10852((class_2561)removeButton).method_27693("  ").method_10852((class_2561)reloadButton));
        }

        private void buildHeader(Consumer<class_2561> consumer) {
            this.buildWhitespace(consumer);
            consumer.accept((class_2561)class_2561.method_43469((String)"There are %s active World Events", (Object[])new Object[]{this.instanceCount}).method_27696(class_2583.field_24360.method_10977(class_124.field_1065)));
            consumer.accept((class_2561)class_2561.method_43469((String)"%s events are frozen", (Object[])new Object[]{this.frozenCount}).method_27696(class_2583.field_24360.method_10977(class_124.field_1075)));
            consumer.accept((class_2561)ActiveWorldEventReport.getDashedLine().method_27696(class_2583.field_24360.method_10977(class_124.field_1065)));
        }

        private void buildInteractiveFooter(Consumer<class_2561> consumer, int page) {
            consumer.accept((class_2561)ActiveWorldEventReport.getDashedLine().method_27696(class_2583.field_24360.method_10977(class_124.field_1065)));
            class_5250 previousPage = class_2561.method_43470((String)"[<]").method_27696(class_2583.field_24360.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11750, "/lodestone worldevent list page " + (page - 1))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Previous Page"))));
            class_5250 nextPage = class_2561.method_43470((String)"[>]").method_27696(class_2583.field_24360.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11750, "/lodestone worldevent list page " + (page + 1))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Next Page"))));
            class_5250 removeAll = class_2561.method_43470((String)"[Remove All]").method_27696(class_2583.field_24360.method_10977(class_124.field_1061).method_10958(new class_2558(class_2558.class_2559.field_11750, "/lodestone worldevent remove all")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Remove all active World Events"))));
            class_5250 freezeAll = class_2561.method_43470((String)"[Freeze All]").method_27696(class_2583.field_24360.method_10977(class_124.field_1058).method_10958(new class_2558(class_2558.class_2559.field_11750, "/lodestone worldevent freeze all")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Freeze all active World Events"))));
            class_5250 unfreezeAll = class_2561.method_43470((String)"[Unfreeze All]").method_27696(class_2583.field_24360.method_10977(class_124.field_1062).method_10958(new class_2558(class_2558.class_2559.field_11750, "/lodestone worldevent unfreeze all")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Unfreeze all active World Events"))));
            class_5250 reload = class_2561.method_43470((String)"[Reload]").method_27696(class_2583.field_24360.method_10977(class_124.field_1054).method_10958(new class_2558(class_2558.class_2559.field_11750, "/lodestone worldevent list page " + page)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Reload active World Events"))));
            class_5250 pageNumber = class_2561.method_43470((String)String.valueOf(page)).method_27696(class_2583.field_24360.method_10977(class_124.field_1065));
            class_5250 navigation = previousPage.method_27693("  ").method_10852((class_2561)pageNumber).method_27693("  ").method_10852((class_2561)nextPage);
            class_5250 freezeUnfreeze = this.frozenCount == this.instanceCount ? unfreezeAll : freezeAll;
            consumer.accept((class_2561)navigation.method_27693("  ").method_10852((class_2561)freezeUnfreeze).method_27693("  ").method_10852((class_2561)removeAll).method_27693("  ").method_10852((class_2561)reload));
        }

        private void buildWhitespace(Consumer<class_2561> consumer) {
            for (int i = 0; i < 20; ++i) {
                consumer.accept((class_2561)class_2561.method_43470((String)" "));
            }
        }

        private static class_5250 getDashedLine() {
            return class_2561.method_43470((String)"-".repeat(40));
        }

        private static class_5250 getDashedSpaceLine() {
            return class_2561.method_43470((String)"- ".repeat(25));
        }
    }
}

