/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone;

import io.github.fabricators_of_create.porting_lib.entity.events.PlayerEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.PlayerTickEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.living.LivingHurtEvent;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.lodestar.lodestone.compability.TrinketsCompat;
import team.lodestar.lodestone.component.LodestonePlayerComponent;
import team.lodestar.lodestone.events.LodestoneInteractionEvent;
import team.lodestar.lodestone.handlers.ItemEventHandler;
import team.lodestar.lodestone.handlers.LodestoneAttributeEventHandler;
import team.lodestar.lodestone.handlers.PlacementAssistantHandler;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.helpers.ShadersHelper;
import team.lodestar.lodestone.registry.common.LodestoneArgumentTypeRegistry;
import team.lodestar.lodestone.registry.common.LodestoneAttributeRegistry;
import team.lodestar.lodestone.registry.common.LodestoneBlockEntityRegistry;
import team.lodestar.lodestone.registry.common.LodestoneCommandRegistry;
import team.lodestar.lodestone.registry.common.LodestonePacketRegistry;
import team.lodestar.lodestone.registry.common.LodestonePaintingRegistry;
import team.lodestar.lodestone.registry.common.LodestonePlacementFillerRegistry;
import team.lodestar.lodestone.registry.common.LodestoneRecipeSerializerRegistry;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.item.LodestoneItemProperties;

public class LodestoneLib
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final boolean debugMode = true;
    public static final String LODESTONE = "lodestone";
    public static final class_5819 RANDOM = class_5819.method_43047();

    public static class_2960 lodestonePath(String path) {
        return new class_2960(LODESTONE, path);
    }

    public void onInitialize() {
        LodestoneArgumentTypeRegistry.registerArgumentTypes();
        LodestoneCommandRegistry.registerCommands();
        LodestonePlacementFillerRegistry.registerTypes();
        LodestonePacketRegistry.registerPackets();
        LodestonePaintingRegistry.register();
        LodestoneBlockEntityRegistry.BLOCK_ENTITY_TYPES.register();
        LodestoneParticleRegistry.PARTICLES.register();
        LodestoneAttributeRegistry.ATTRIBUTES.register();
        LodestoneRecipeSerializerRegistry.RECIPE_SERIALIZERS.register();
        PlayerEvents.ON_JOIN_WORLD.register(WorldEventHandler::playerJoin);
        PlayerEvents.ON_JOIN_WORLD.register(LodestonePlayerComponent::playerJoin);
        PlacementAssistantHandler.registerPlacementAssistants();
        LodestoneInteractionEvent.RIGHT_CLICK_BLOCK.register(PlacementAssistantHandler::placeBlock);
        PlayerTickEvents.END.register(LodestonePlayerComponent::playerTick);
        ServerLivingEntityEvents.ALLOW_DEATH.register(ItemEventHandler::respondToDeath);
        LivingHurtEvent.HURT.register(ItemEventHandler::respondToHurt);
        LivingHurtEvent.HURT.register(LodestoneAttributeEventHandler::processAttributes);
        TrinketsCompat.init();
        ShadersHelper.init();
        ItemGroupEvents.MODIFY_ENTRIES_ALL.register(LodestoneItemProperties::populateItemGroups);
        if (!FabricDataGenHelper.ENABLED) {
            // empty if block
        }
    }

    public static void debug() {
        LodestoneLib.debug("");
    }

    public static void debug(String message) {
        String className = new Exception().getStackTrace()[1].getClassName();
        try {
            Class<?> clazz = Class.forName(className);
            LOGGER.info("Debugging: {}. {}", (Object)clazz.getSimpleName(), (Object)message);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Class not found for name: {}", (Object)className, (Object)e);
        }
    }
}

