/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.head;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModItems;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;

public class DrinkingHatItem
extends WearableArtifactItem {
    private final ModGameRules.DoubleValue drinkingDurationMultiplier;
    private final ModGameRules.DoubleValue eatingDurationMultiplier;
    private final boolean hasSpecialTooltip;

    public DrinkingHatItem(ModGameRules.DoubleValue drinkingDurationMultiplier, ModGameRules.DoubleValue eatingDurationMultiplier, boolean hasSpecialTooltip) {
        this.drinkingDurationMultiplier = drinkingDurationMultiplier;
        this.eatingDurationMultiplier = eatingDurationMultiplier;
        this.hasSpecialTooltip = hasSpecialTooltip;
    }

    @Override
    public boolean hasNonCosmeticEffects() {
        return !this.drinkingDurationMultiplier.fuzzyEquals(1.0) || !this.eatingDurationMultiplier.fuzzyEquals(1.0);
    }

    @Override
    protected void addTooltip(class_1799 stack, List<class_5250> tooltip) {
        if (this.hasSpecialTooltip) {
            tooltip.add(this.tooltipLine("special", new Object[0]).method_27692(class_124.field_1056));
            this.addEffectsTooltip(stack, tooltip);
        } else {
            super.addTooltip(stack, tooltip);
        }
    }

    @Override
    protected void addEffectsTooltip(class_1799 stack, List<class_5250> tooltip) {
        if (!this.drinkingDurationMultiplier.fuzzyEquals(1.0)) {
            tooltip.add(this.tooltipLine("drinking", new Object[0]));
        }
        if (!this.eatingDurationMultiplier.fuzzyEquals(1.0)) {
            tooltip.add(this.tooltipLine("eating", new Object[0]));
        }
    }

    @Override
    protected String getTooltipItemName() {
        return "drinking_hat";
    }

    public double getDurationMultiplier(class_1839 action) {
        if (action == class_1839.field_8946) {
            return this.drinkingDurationMultiplier.get();
        }
        return this.eatingDurationMultiplier.get();
    }

    @Override
    public class_3414 getEquipSound() {
        return class_3417.field_14779;
    }

    public static int getDrinkingHatUseDuration(class_1309 entity, class_1839 action, int duration) {
        return Math.min(DrinkingHatItem.getDrinkingHatUseDuration(entity, action, duration, ModItems.PLASTIC_DRINKING_HAT.get()), DrinkingHatItem.getDrinkingHatUseDuration(entity, action, duration, ModItems.NOVELTY_DRINKING_HAT.get()));
    }

    private static int getDrinkingHatUseDuration(class_1309 entity, class_1839 action, int duration, DrinkingHatItem drinkingHat) {
        if (!drinkingHat.isEquippedBy(entity) || action != class_1839.field_8950 && action != class_1839.field_8946 || drinkingHat.getDurationMultiplier(action) == 1.0) {
            return duration;
        }
        return Math.max(1, (int)((double)duration * drinkingHat.getDurationMultiplier(action)));
    }
}

