/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.config;

import com.minecraftserverzone.weaponmaster.WeaponMasterMod;
import com.minecraftserverzone.weaponmaster.setup.config.ModConfigProvider;
import com.minecraftserverzone.weaponmaster.setup.config.SimpleConfig;
import com.mojang.datafixers.util.Pair;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfigs {
    public static SimpleConfig CONFIG;
    private static ModConfigProvider configs;
    public static boolean[] TOGGLE_SLOT_MODEL;
    public static boolean CAN_HIDE_ITEMS;
    public static boolean CAN_CHANGE_POS_AND_ROT;
    public static boolean CAN_CHANGE_SCALE;
    public static boolean CAN_CHANGE_ATTACHMENT;
    public static boolean CAN_CHANGE_MOVERS;
    public static boolean CAN_CHANGE_UNIQUE_ITEM_SETTINGS;
    public static boolean CAN_CHANGE_BLACKLIST;
    public static boolean CAN_CHANGE_WHITELIST;
    public static int hideTick;
    public static int[] positions;
    public static int[] rotations;
    public static String slot_attachment;
    public static String slotMover;
    public static String blacklist;
    public static String whitelist;
    public static String uniqueItemDisplay;
    public static int[] scale;
    public static String configname;

    public static void changeConfig() throws IOException {
        try {
            Path path = FabricLoader.getInstance().getConfigDir();
            String filename = "weaponmaster_ydm_config.properties";
            FileWriter fw = new FileWriter(String.valueOf(path) + "/" + filename, false);
            PrintWriter pw = new PrintWriter((Writer)fw, Boolean.parseBoolean("UTF-8"));
            pw.println(configname + ".hidetick=" + hideTick + " #int | default: 200");
            pw.println(configname + ".uniqueitems=" + uniqueItemDisplay + " #String | default: empty");
            pw.println(configname + ".blacklist=" + blacklist + " #String | default: empty");
            pw.println(configname + ".whitelist=" + whitelist + " #String | default: empty,totem_of_undying");
            pw.println(configname + ".slot.1=" + TOGGLE_SLOT_MODEL[0] + " #boolean | default: true");
            pw.println(configname + ".slot.2=" + TOGGLE_SLOT_MODEL[1] + " #boolean | default: true");
            pw.println(configname + ".slot.3=" + TOGGLE_SLOT_MODEL[2] + " #boolean | default: true");
            pw.println(configname + ".slot.4=" + TOGGLE_SLOT_MODEL[3] + " #boolean | default: true");
            pw.println(configname + ".slot.5=" + TOGGLE_SLOT_MODEL[4] + " #boolean | default: true");
            pw.println(configname + ".slot.6=" + TOGGLE_SLOT_MODEL[5] + " #boolean | default: true");
            pw.println(configname + ".slot.7=" + TOGGLE_SLOT_MODEL[6] + " #boolean | default: true");
            pw.println(configname + ".slot.8=" + TOGGLE_SLOT_MODEL[7] + " #boolean | default: true");
            pw.println(configname + ".slot.9=" + TOGGLE_SLOT_MODEL[8] + " #boolean | default: true");
            pw.println(configname + ".slot.shield=" + TOGGLE_SLOT_MODEL[9] + " #boolean | default: true");
            pw.println(configname + ".slot.banner=" + TOGGLE_SLOT_MODEL[10] + " #boolean | default: true");
            pw.println(configname + ".slot.mainhand=" + TOGGLE_SLOT_MODEL[11] + " #boolean | default: true");
            pw.println(configname + ".slot.offhand=" + TOGGLE_SLOT_MODEL[12] + " #boolean | default: true");
            pw.println(configname + ".slot.quiver=" + TOGGLE_SLOT_MODEL[13] + " #boolean | default: true");
            for (int i = 0; i < WeaponMasterMod.maxDisplaySlotNum; ++i) {
                pw.println(configname + ".posx" + i * 3 + "=" + positions[i * 3] + " #int | default: 0");
                pw.println(configname + ".posy" + (i * 3 + 1) + "=" + positions[i * 3 + 1] + " #int | default: 0");
                pw.println(configname + ".posz" + (i * 3 + 2) + "=" + positions[i * 3 + 2] + " #int | default: 0");
                pw.println(configname + ".rotx" + i * 3 + "=" + rotations[i * 3] + " #int | default: 0");
                pw.println(configname + ".roty" + (i * 3 + 1) + "=" + rotations[i * 3 + 1] + " #int | default: 0");
                pw.println(configname + ".rotz" + (i * 3 + 2) + "=" + rotations[i * 3 + 2] + " #int | default: 0");
                pw.println(configname + ".scale" + i + "=" + scale[i] + " #int | default: 0");
            }
            pw.println(configname + ".attachment=" + slot_attachment + " #String | default: 1-body,2-body,3-rleg,4-lleg,5-rleg,6-lleg,7-body,8-body,9-rleg,shield-body,banner-head");
            pw.println(configname + ".slotmover=" + slotMover + " #String | default: empty");
            pw.println(configname + ".slot.can_hide_items=" + CAN_HIDE_ITEMS + " #boolean | default: true");
            pw.println(configname + ".slot.can_change_pos_and_rot=" + CAN_CHANGE_POS_AND_ROT + " #boolean | default: true");
            pw.println(configname + ".slot.can_change_attachment=" + CAN_CHANGE_ATTACHMENT + " #boolean | default: true");
            pw.println(configname + ".slot.can_change_movers=" + CAN_CHANGE_MOVERS + " #boolean | default: true");
            pw.println(configname + ".slot.can_change_uniqueitemsettings=" + CAN_CHANGE_UNIQUE_ITEM_SETTINGS + " #boolean | default: true");
            pw.println(configname + ".slot.can_change_scale=" + CAN_CHANGE_SCALE + " #boolean | default: true");
            pw.println(configname + ".slot.can_change_blacklist=" + CAN_CHANGE_BLACKLIST + " #boolean | default: true");
            pw.println(configname + ".slot.can_change_whitelist=" + CAN_CHANGE_WHITELIST + " #boolean | default: true");
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void registerConfigs() {
        configs = new ModConfigProvider();
        ModConfigs.createConfigs();
        String filename = "weaponmaster_ydm_config";
        CONFIG = SimpleConfig.of(filename).provider(configs).request();
        ModConfigs.assignConfigs();
    }

    private static void createConfigs() {
        configs.addKeyValuePair(new Pair((Object)(configname + ".hidetick"), (Object)200), "int");
        configs.addKeyValuePair(new Pair((Object)(configname + ".uniqueitems"), (Object)"name,0,0,0,0,0,0,0,1"), "String");
        configs.addKeyValuePair(new Pair((Object)(configname + ".blacklist"), (Object)"empty"), "String");
        configs.addKeyValuePair(new Pair((Object)(configname + ".whitelist"), (Object)"empty,totem_of_undying"), "String");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.1"), (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.2"), (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.3"), (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.4"), (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.5"), (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.6"), (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.7"), (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.8"), (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.9"), (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.shield"), (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.banner"), (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.mainhand"), (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.offhand"), (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.quiver"), (Object)true), "boolean");
        ModConfigs.initPositionsRotationsKeyValuePair(0, 0, 0, -2, 0, 0, 0);
        ModConfigs.initPositionsRotationsKeyValuePair(1, 35, 35, 0, 0, 0, 90);
        ModConfigs.initPositionsRotationsKeyValuePair(2, 1, -20, 12, 0, -90, 0);
        ModConfigs.initPositionsRotationsKeyValuePair(3, 32, -20, 12, 0, -90, 0);
        ModConfigs.initPositionsRotationsKeyValuePair(4, 1, -24, 0, 0, -90, -30);
        ModConfigs.initPositionsRotationsKeyValuePair(5, 31, -24, 0, 0, -90, -30);
        ModConfigs.initPositionsRotationsKeyValuePair(6, -13, 34, -1, 0, 0, -35);
        ModConfigs.initPositionsRotationsKeyValuePair(7, 25, 20, 12, 0, 0, 45);
        ModConfigs.initPositionsRotationsKeyValuePair(8, 1, -14, 20, 0, -90, 20);
        ModConfigs.initPositionsRotationsKeyValuePair(9, 0, 0, 0, 0, 0, 0);
        ModConfigs.initPositionsRotationsKeyValuePair(10, 0, 0, 0, 0, 0, 0);
        ModConfigs.initPositionsRotationsKeyValuePair(11, -2, 22, -14, 110, 90, 0);
        ModConfigs.initPositionsRotationsKeyValuePair(12, 0, 0, 15, 0, 0, 0);
        configs.addKeyValuePair(new Pair((Object)(configname + ".attachment"), (Object)WeaponMasterMod.defaultSlotAttachment), "String");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slotmover"), (Object)WeaponMasterMod.defaultSlotMover), "String");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.can_hide_items"), (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.can_change_pos_and_rot"), (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.can_change_attachment"), (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.can_change_movers"), (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.can_change_uniqueitemsettings"), (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.can_change_scale"), (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.can_change_blacklist"), (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)(configname + ".slot.can_change_whitelist"), (Object)true), "boolean");
    }

    private static void assignConfigs() {
        hideTick = CONFIG.getOrDefault(configname + ".hidetick", 200);
        uniqueItemDisplay = CONFIG.getOrDefault(configname + ".uniqueitems", "name,0,0,0,0,0,0,0,1");
        blacklist = CONFIG.getOrDefault(configname + ".blacklist", "empty");
        whitelist = CONFIG.getOrDefault(configname + ".whitelist", "empty,totem_of_undying");
        ModConfigs.TOGGLE_SLOT_MODEL[0] = CONFIG.getOrDefault(configname + ".slot.1", true);
        ModConfigs.TOGGLE_SLOT_MODEL[1] = CONFIG.getOrDefault(configname + ".slot.2", true);
        ModConfigs.TOGGLE_SLOT_MODEL[2] = CONFIG.getOrDefault(configname + ".slot.3", true);
        ModConfigs.TOGGLE_SLOT_MODEL[3] = CONFIG.getOrDefault(configname + ".slot.4", true);
        ModConfigs.TOGGLE_SLOT_MODEL[4] = CONFIG.getOrDefault(configname + ".slot.5", true);
        ModConfigs.TOGGLE_SLOT_MODEL[5] = CONFIG.getOrDefault(configname + ".slot.6", true);
        ModConfigs.TOGGLE_SLOT_MODEL[6] = CONFIG.getOrDefault(configname + ".slot.7", true);
        ModConfigs.TOGGLE_SLOT_MODEL[7] = CONFIG.getOrDefault(configname + ".slot.8", true);
        ModConfigs.TOGGLE_SLOT_MODEL[8] = CONFIG.getOrDefault(configname + ".slot.9", true);
        ModConfigs.TOGGLE_SLOT_MODEL[9] = CONFIG.getOrDefault(configname + ".slot.shield", true);
        ModConfigs.TOGGLE_SLOT_MODEL[10] = CONFIG.getOrDefault(configname + ".slot.banner", true);
        ModConfigs.TOGGLE_SLOT_MODEL[11] = CONFIG.getOrDefault(configname + ".slot.mainhand", true);
        ModConfigs.TOGGLE_SLOT_MODEL[12] = CONFIG.getOrDefault(configname + ".slot.offhand", true);
        ModConfigs.TOGGLE_SLOT_MODEL[13] = CONFIG.getOrDefault(configname + ".slot.quiver", true);
        ModConfigs.initPositionsRotationsGetOrDefault(0, 0, 0, -2, 0, 0, 0);
        ModConfigs.initPositionsRotationsGetOrDefault(1, 35, 35, 0, 0, 0, 90);
        ModConfigs.initPositionsRotationsGetOrDefault(2, 1, -20, 12, 0, -90, 0);
        ModConfigs.initPositionsRotationsGetOrDefault(3, 32, -20, 12, 0, -90, 0);
        ModConfigs.initPositionsRotationsGetOrDefault(4, 1, -24, 0, 0, -90, -30);
        ModConfigs.initPositionsRotationsGetOrDefault(5, 31, -24, 0, 0, -90, -30);
        ModConfigs.initPositionsRotationsGetOrDefault(6, -13, 34, -1, 0, 0, -35);
        ModConfigs.initPositionsRotationsGetOrDefault(7, 25, 20, 12, 0, 0, 45);
        ModConfigs.initPositionsRotationsGetOrDefault(8, 1, -14, 20, 0, -90, 20);
        ModConfigs.initPositionsRotationsGetOrDefault(9, 0, 0, 0, 0, 0, 0);
        ModConfigs.initPositionsRotationsGetOrDefault(10, 0, 0, 0, 0, 0, 0);
        ModConfigs.initPositionsRotationsGetOrDefault(11, -2, 22, -14, 110, 90, 0);
        ModConfigs.initPositionsRotationsGetOrDefault(12, 0, 0, 15, 0, 0, 0);
        slot_attachment = CONFIG.getOrDefault(configname + ".attachment", WeaponMasterMod.defaultSlotAttachment);
        slotMover = CONFIG.getOrDefault(configname + ".slotmover", WeaponMasterMod.defaultSlotMover);
        CAN_HIDE_ITEMS = CONFIG.getOrDefault(configname + ".slot.can_hide_items", true);
        CAN_CHANGE_POS_AND_ROT = CONFIG.getOrDefault(configname + ".slot.can_change_pos_and_rot", true);
        CAN_CHANGE_ATTACHMENT = CONFIG.getOrDefault(configname + ".slot.can_change_attachment", true);
        CAN_CHANGE_MOVERS = CONFIG.getOrDefault(configname + ".slot.can_change_movers", true);
        CAN_CHANGE_UNIQUE_ITEM_SETTINGS = CONFIG.getOrDefault(configname + ".slot.can_change_uniqueitemsettings", true);
        CAN_CHANGE_SCALE = CONFIG.getOrDefault(configname + ".slot.can_change_scale", true);
        CAN_CHANGE_BLACKLIST = CONFIG.getOrDefault(configname + ".slot.can_change_blacklist", true);
        CAN_CHANGE_WHITELIST = CONFIG.getOrDefault(configname + ".slot.can_change_whitelist", true);
    }

    public static void initPositionsRotationsGetOrDefault(int slot, int posx, int posy, int posz, int rotx, int roty, int rotz) {
        ModConfigs.positions[slot * 3] = CONFIG.getOrDefault(configname + ".posx" + slot * 3, posx);
        ModConfigs.positions[slot * 3 + 1] = CONFIG.getOrDefault(configname + ".posy" + (slot * 3 + 1), posy);
        ModConfigs.positions[slot * 3 + 2] = CONFIG.getOrDefault(configname + ".posz" + (slot * 3 + 2), posz);
        ModConfigs.rotations[slot * 3] = CONFIG.getOrDefault(configname + ".rotx" + slot * 3, rotx);
        ModConfigs.rotations[slot * 3 + 1] = CONFIG.getOrDefault(configname + ".roty" + (slot * 3 + 1), roty);
        ModConfigs.rotations[slot * 3 + 2] = CONFIG.getOrDefault(configname + ".rotz" + (slot * 3 + 2), rotz);
        ModConfigs.scale[slot] = CONFIG.getOrDefault(configname + ".scale" + slot, 0);
    }

    public static void initPositionsRotationsKeyValuePair(int slot, int posx, int posy, int posz, int rotx, int roty, int rotz) {
        configs.addKeyValuePair(new Pair((Object)(configname + ".posx" + slot * 3), (Object)posx), "int");
        configs.addKeyValuePair(new Pair((Object)(configname + ".posy" + (slot * 3 + 1)), (Object)posy), "int");
        configs.addKeyValuePair(new Pair((Object)(configname + ".posz" + (slot * 3 + 2)), (Object)posz), "int");
        configs.addKeyValuePair(new Pair((Object)(configname + ".rotx" + slot * 3), (Object)rotx), "int");
        configs.addKeyValuePair(new Pair((Object)(configname + ".roty" + (slot * 3 + 1)), (Object)roty), "int");
        configs.addKeyValuePair(new Pair((Object)(configname + ".rotz" + (slot * 3 + 2)), (Object)rotz), "int");
        configs.addKeyValuePair(new Pair((Object)(configname + ".scale" + slot), (Object)0), "int");
    }

    static {
        TOGGLE_SLOT_MODEL = new boolean[WeaponMasterMod.maxDisplaySlotNum + 1];
        positions = new int[WeaponMasterMod.maxDisplaySlotNum * 3];
        rotations = new int[WeaponMasterMod.maxDisplaySlotNum * 3];
        slot_attachment = WeaponMasterMod.defaultSlotMover;
        slotMover = WeaponMasterMod.defaultSlotMover;
        blacklist = "empty";
        whitelist = "empty,totem_of_undying";
        uniqueItemDisplay = "name,0,0,0,0,0,0,0,1";
        scale = new int[WeaponMasterMod.maxDisplaySlotNum];
        configname = "weaponmaster_ydm_config";
    }
}

