/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.client.gui.handler;

import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3913;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import net.minecraft.class_3956;
import net.satisfy.vinery.client.gui.handler.slot.ExtendedSlot;
import net.satisfy.vinery.client.gui.handler.slot.FermentationBarrelOutputSlot;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.registry.RecipeTypesRegistry;
import net.satisfy.vinery.core.registry.ScreenhandlerTypeRegistry;
import net.satisfy.vinery.core.util.JuiceUtil;
import org.jetbrains.annotations.NotNull;

public class FermentationBarrelGuiHandler
extends class_1703 {
    private final class_1263 inventory;
    private final class_1937 level;
    public final class_3913 data;
    private static final int WINE_BOTTLE_SLOT = 4;
    private static final int OUTPUT_SLOT_GENERAL = 5;

    public FermentationBarrelGuiHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, (class_1263)new class_1277(6), (class_3913)new class_3919(4));
    }

    public FermentationBarrelGuiHandler(int syncId, class_1661 playerInventory, class_1263 inventory, class_3913 data) {
        super((class_3917)ScreenhandlerTypeRegistry.FERMENTATION_BARREL_GUI_HANDLER.get(), syncId);
        this.inventory = inventory;
        this.level = playerInventory.field_7546.method_37908();
        this.data = data;
        this.method_17360(data);
        this.addBlockEntitySlots(playerInventory);
        this.addPlayerInventory(playerInventory);
    }

    private void addBlockEntitySlots(class_1661 playerInventory) {
        this.method_7621(new ExtendedSlot(this.inventory, 0, 39, 17, stack -> JuiceUtil.isJuice(stack) && this.canAddJuice((class_1799)stack)));
        this.method_7621(new ExtendedSlot(this.inventory, 1, 67, 58, this::isIngredient));
        this.method_7621(new ExtendedSlot(this.inventory, 2, 85, 58, this::isIngredient));
        this.method_7621(new ExtendedSlot(this.inventory, 3, 103, 58, this::isIngredient));
        this.method_7621(new ExtendedSlot(this.inventory, 4, 123, 58, stack -> stack.method_31574((class_1792)ObjectRegistry.WINE_BOTTLE.get())));
        this.method_7621(new FermentationBarrelOutputSlot(playerInventory.field_7546, this.inventory, 5, 103, 17));
    }

    private boolean canAddJuice(class_1799 stack) {
        String newJuiceType = JuiceUtil.getJuiceType(stack);
        String currentJuiceType = this.getJuiceType();
        return currentJuiceType.isEmpty() || currentJuiceType.equals(newJuiceType);
    }

    private void addPlayerInventory(class_1661 playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.method_7621(new class_1735((class_1263)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.method_7621(new class_1735((class_1263)playerInventory, col, 8 + col * 18, 142));
        }
    }

    private boolean isIngredient(class_1799 stack) {
        return this.level.method_8433().method_30027((class_3956)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_TYPE.get()).stream().anyMatch(recipe -> recipe.method_8117().stream().anyMatch(ingredient -> ingredient.method_8093(stack)));
    }

    @NotNull
    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 stackInSlot = slot.method_7677();
            itemStack = stackInSlot.method_7972();
            int containerSlots = 6;
            if (index < containerSlots) {
                if (!this.method_7616(stackInSlot, containerSlots, this.field_7761.size(), true)) {
                    return class_1799.field_8037;
                }
            } else {
                if (JuiceUtil.isJuice(stackInSlot) ? !this.method_7616(stackInSlot, 0, 1, false) : (stackInSlot.method_31574((class_1792)ObjectRegistry.WINE_BOTTLE.get()) ? !this.method_7616(stackInSlot, 4, 5, false) : (this.isIngredient(stackInSlot) ? !this.method_7616(stackInSlot, 1, 4, false) : (index < this.field_7761.size() - 9 ? !this.method_7616(stackInSlot, this.field_7761.size() - 9, this.field_7761.size(), false) : !this.method_7616(stackInSlot, containerSlots, this.field_7761.size() - 9, false))))) {
                    return class_1799.field_8037;
                }
                if (stackInSlot.method_7960()) {
                    slot.method_7673(class_1799.field_8037);
                } else {
                    slot.method_7668();
                }
                if (stackInSlot.method_7947() == itemStack.method_7947()) {
                    return class_1799.field_8037;
                }
                slot.method_7667(player, stackInSlot);
            }
        }
        return itemStack;
    }

    public boolean method_7597(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    public String getJuiceType() {
        int juiceTypeValue = this.data.method_17390(3);
        return this.getJuiceTypeFromValue(juiceTypeValue);
    }

    private String getJuiceTypeFromValue(int value) {
        return switch (value) {
            case 0 -> "white_general";
            case 1 -> "red_general";
            case 2 -> "white_savanna";
            case 3 -> "red_savanna";
            case 4 -> "white_taiga";
            case 5 -> "red_taiga";
            case 6 -> "white_jungle";
            case 7 -> "red_jungle";
            case 8 -> "apple";
            case 9 -> "red_crimson";
            case 10 -> "white_warped";
            default -> "";
        };
    }

    public int getFluidLevel() {
        return this.data.method_17390(2);
    }

    public int getScaledProgress(int maxProgress) {
        int progress = this.data.method_17390(0);
        int totalProgress = this.data.method_17390(1);
        if (progress == 0 || totalProgress == 0) {
            return 0;
        }
        return (int)((double)progress / (double)totalProgress * (double)maxProgress);
    }
}

