/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture.types.random;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.SpriteCreationContext;
import com.supermartijn642.fusion.api.texture.SpritePreparationContext;
import com.supermartijn642.fusion.api.texture.TextureErrorException;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import com.supermartijn642.fusion.api.texture.data.RandomTextureData;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.MutableQuad;
import com.supermartijn642.fusion.texture.types.random.RandomTextureSprite;
import java.util.function.Supplier;
import net.minecraft.class_1058;
import net.minecraft.class_1079;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class RandomTextureType
implements TextureType<RandomTextureData> {
    @Override
    public RandomTextureData deserialize(JsonObject json) throws JsonParseException {
        BaseTextureData base = (BaseTextureData)DefaultTextureTypes.BASE.deserialize(json);
        RandomTextureData.Builder builder = RandomTextureData.builder();
        builder.renderType(base.getRenderType());
        builder.emissive(base.isEmissive());
        builder.tinting(base.getTinting());
        int rows = 1;
        if (json.has("rows")) {
            if (!json.get("rows").isJsonPrimitive() || !json.getAsJsonPrimitive("rows").isNumber()) {
                throw new JsonParseException("Property 'rows' must be a number!");
            }
            rows = json.get("rows").getAsInt();
            if (rows < 1 || rows > 10) {
                throw new JsonParseException("Property 'rows' must be a number between 1 and 10!");
            }
            builder.rows(rows);
        }
        int columns = 1;
        if (json.has("columns")) {
            if (!json.get("columns").isJsonPrimitive() || !json.getAsJsonPrimitive("columns").isNumber()) {
                throw new JsonParseException("Property 'columns' must be a number!");
            }
            columns = json.get("columns").getAsInt();
            if (columns < 1 || columns > 10) {
                throw new JsonParseException("Property 'columns' must be a number between 1 and 10!");
            }
            builder.columns(columns);
        }
        if (json.has("count")) {
            if (!json.get("count").isJsonPrimitive() || !json.getAsJsonPrimitive("count").isNumber()) {
                throw new JsonParseException("Property 'count' must be a number!");
            }
            int count = json.get("count").getAsInt();
            if (count < 1 || count > 100) {
                throw new JsonParseException("Property 'count' must be a number between 1 and 100!");
            }
            if (count > rows * columns) {
                throw new IllegalArgumentException("Count cannot be greater than rows * columns!");
            }
            builder.count(count);
        }
        if (json.has("seed")) {
            if (!json.get("seed").isJsonPrimitive() || !json.getAsJsonPrimitive("seed").isNumber()) {
                throw new JsonParseException("Property 'seed' must be a number!");
            }
            builder.seed(json.get("seed").getAsLong());
        }
        return (RandomTextureData)builder.build();
    }

    @Override
    public JsonObject serialize(RandomTextureData data) {
        JsonObject json = DefaultTextureTypes.BASE.serialize(data);
        if (data.getRows() != 1) {
            json.addProperty("rows", (Number)data.getRows());
        }
        if (data.getColumns() != 1) {
            json.addProperty("columns", (Number)data.getColumns());
        }
        if (data.getCount() != data.getRows() * data.getColumns()) {
            json.addProperty("count", (Number)data.getCount());
        }
        if (data.getSeed() != null) {
            json.addProperty("seed", (Number)data.getSeed());
        }
        return json;
    }

    @Override
    public Pair<Integer, Integer> getFrameSize(SpritePreparationContext context, RandomTextureData data) {
        if (context.getAnimationMetadata() != null) {
            Pair<Integer, Integer> frameSize;
            class_1079 animation = context.getAnimationMetadata();
            if (animation.field_5338 != -1 && animation.field_5336 != -1) {
                frameSize = Pair.of(animation.field_5338, animation.field_5336);
            } else if (animation.field_5338 != -1) {
                frameSize = Pair.of(animation.field_5338, context.getTextureHeight());
            } else if (animation.field_5336 != -1) {
                frameSize = Pair.of(context.getTextureWidth(), animation.field_5336);
            } else {
                int height = Math.min(context.getTextureWidth() * data.getRows() / data.getColumns(), context.getTextureHeight());
                frameSize = Pair.of(context.getTextureWidth(), height);
            }
            if (!class_3532.method_48117((int)context.getTextureWidth(), (int)frameSize.left()) || !class_3532.method_48117((int)context.getTextureHeight(), (int)frameSize.right())) {
                throw new TextureErrorException("Image size " + context.getTextureWidth() + "x" + context.getTextureHeight() + " is not a multiple of frame size " + String.valueOf(frameSize.left()) + "x" + String.valueOf(frameSize.right()) + "!");
            }
            return frameSize;
        }
        int width = context.getTextureWidth();
        int height = context.getTextureHeight();
        if (width * data.getRows() / data.getColumns() != height) {
            throw new TextureErrorException("Image aspect ratio does not match row/column aspect ratio!");
        }
        return Pair.of(width, height);
    }

    @Override
    public class_1058 createSprite(SpriteCreationContext context, RandomTextureData data) {
        class_1058 sprite = context.createOriginalSprite();
        sprite.field_5269 = sprite.field_5270 + (sprite.field_5269 - sprite.field_5270) / (float)data.getColumns();
        sprite.field_5267 = sprite.field_5268 + (sprite.field_5267 - sprite.field_5268) / (float)data.getRows();
        return new RandomTextureSprite(sprite, data);
    }

    public static void processQuad(MutableQuad quad, class_2338 pos, class_2350 side, Supplier<class_5819> randomSupplier, RandomTextureSprite sprite) {
        if (side == null) {
            return;
        }
        RandomTextureData data = sprite.data();
        class_5819 random = randomSupplier.get();
        if (data.getSeed() != null) {
            random.method_43052(data.getSeed() ^ (pos.method_10063() + 1L) * (long)side.ordinal());
        } else {
            random.method_43052((pos.method_10063() + 1L) * (long)side.ordinal());
        }
        random.method_43055();
        int x = random.method_43048(data.getColumns());
        int y = random.method_43048(data.getRows());
        if (x > 0 || y > 0) {
            float width = sprite.method_4577() - sprite.method_4594();
            float height = sprite.method_4575() - sprite.method_4593();
            for (int i = 0; i < 4; ++i) {
                quad.uv(i, quad.u(i) + (float)x * width, quad.v(i) + (float)y * height);
            }
        }
    }
}

