/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture.types.continuous;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.SpriteCreationContext;
import com.supermartijn642.fusion.api.texture.SpritePreparationContext;
import com.supermartijn642.fusion.api.texture.TextureErrorException;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import com.supermartijn642.fusion.api.texture.data.ContinuousTextureData;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.MutableQuad;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureSprite;
import net.minecraft.class_1058;
import net.minecraft.class_1079;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3532;

public class ContinuousTextureType
implements TextureType<ContinuousTextureData> {
    @Override
    public ContinuousTextureData deserialize(JsonObject json) throws JsonParseException {
        BaseTextureData base = (BaseTextureData)DefaultTextureTypes.BASE.deserialize(json);
        ContinuousTextureData.Builder builder = ContinuousTextureData.builder();
        builder.renderType(base.getRenderType());
        builder.emissive(base.isEmissive());
        builder.tinting(base.getTinting());
        if (json.has("rows")) {
            if (!json.get("rows").isJsonPrimitive() || !json.getAsJsonPrimitive("rows").isNumber()) {
                throw new JsonParseException("Property 'rows' must be a number!");
            }
            int rows = json.get("rows").getAsInt();
            if (rows <= 0 || rows > 10) {
                throw new JsonParseException("Property 'rows' must be greater than zero and less than 10!");
            }
            builder.rows(rows);
        }
        if (json.has("columns")) {
            if (!json.get("columns").isJsonPrimitive() || !json.getAsJsonPrimitive("columns").isNumber()) {
                throw new JsonParseException("Property 'columns' must be a number!");
            }
            int columns = json.get("columns").getAsInt();
            if (columns <= 0 || columns > 10) {
                throw new JsonParseException("Property 'columns' must be greater than zero and less than 10!");
            }
            builder.columns(columns);
        }
        return (ContinuousTextureData)builder.build();
    }

    @Override
    public JsonObject serialize(ContinuousTextureData data) {
        JsonObject json = DefaultTextureTypes.BASE.serialize(data);
        if (data.getRows() != 1) {
            json.addProperty("rows", (Number)data.getRows());
        }
        if (data.getColumns() != 1) {
            json.addProperty("columns", (Number)data.getColumns());
        }
        return json;
    }

    @Override
    public Pair<Integer, Integer> getFrameSize(SpritePreparationContext context, ContinuousTextureData data) {
        if (context.getAnimationMetadata() != null) {
            Pair<Integer, Integer> frameSize;
            class_1079 animation = context.getAnimationMetadata();
            if (animation.field_5338 != -1 && animation.field_5336 != -1) {
                frameSize = Pair.of(animation.field_5338, animation.field_5336);
            } else if (animation.field_5338 != -1) {
                frameSize = Pair.of(animation.field_5338, context.getTextureHeight());
            } else if (animation.field_5336 != -1) {
                frameSize = Pair.of(context.getTextureWidth(), animation.field_5336);
            } else {
                int height = Math.min(context.getTextureWidth() * data.getRows() / data.getColumns(), context.getTextureHeight());
                frameSize = Pair.of(context.getTextureWidth(), height);
            }
            if (!class_3532.method_48117((int)context.getTextureWidth(), (int)frameSize.left()) || !class_3532.method_48117((int)context.getTextureHeight(), (int)frameSize.right())) {
                throw new TextureErrorException("Image size " + context.getTextureWidth() + "x" + context.getTextureHeight() + " is not a multiple of frame size " + String.valueOf(frameSize.left()) + "x" + String.valueOf(frameSize.right()) + "!");
            }
            return frameSize;
        }
        int width = context.getTextureWidth();
        int height = context.getTextureHeight();
        if (width * data.getRows() / data.getColumns() != height) {
            throw new TextureErrorException("Image aspect ratio does not match row/column aspect ratio!");
        }
        return Pair.of(width, height);
    }

    @Override
    public class_1058 createSprite(SpriteCreationContext context, ContinuousTextureData data) {
        class_1058 sprite = context.createOriginalSprite();
        sprite.field_5269 = sprite.field_5270 + (sprite.field_5269 - sprite.field_5270) / (float)data.getColumns();
        sprite.field_5267 = sprite.field_5268 + (sprite.field_5267 - sprite.field_5268) / (float)data.getRows();
        return new ContinuousTextureSprite(sprite, data);
    }

    public static void processQuad(MutableQuad quad, class_2338 pos, class_2350 side, ContinuousTextureSprite sprite) {
        int y;
        int x;
        if (side == null) {
            return;
        }
        ContinuousTextureData data = sprite.data();
        class_2350.class_2351 axis = side.method_10166();
        int n = x = axis == class_2350.class_2351.field_11048 ? pos.method_10260() : pos.method_10263();
        int n2 = axis == class_2350.class_2351.field_11048 ? pos.method_10264() : (y = axis == class_2350.class_2351.field_11052 ? pos.method_10260() : pos.method_10264());
        if (side == class_2350.field_11043 || side == class_2350.field_11034) {
            x = -x - 1;
        }
        x = x < 0 ? (x % data.getColumns() + data.getColumns()) % data.getColumns() : x % data.getColumns();
        int n3 = y = y < 0 ? (y % data.getRows() + data.getRows()) % data.getRows() : y % data.getRows();
        if (x > 0 || y > 0) {
            float width = sprite.method_4577() - sprite.method_4594();
            float height = sprite.method_4575() - sprite.method_4593();
            for (int i = 0; i < 4; ++i) {
                quad.uv(i, quad.u(i) + (float)x * width, quad.v(i) + (float)y * height);
            }
        }
    }
}

