/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.google.common.collect.ImmutableMap;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.data.ConnectingModelData;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.util.Either;
import com.supermartijn642.fusion.model.types.base.BaseModelDataImpl;
import com.supermartijn642.fusion.model.types.base.BaseModelElement;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelElement;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelQuad;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1058;
import net.minecraft.class_1088;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_777;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_793;
import org.joml.Matrix4f;

public class ConnectingModelDataImpl
extends BaseModelDataImpl
implements ConnectingModelData {
    private final Map<String, ConnectionPredicate> predicates;
    private final Map<String, String> connectionReferences;

    public ConnectingModelDataImpl(class_793 model, List<class_2960> parents, List<ConnectingModelElement> elements, Map<String, ConnectionPredicate> predicates, Map<String, String> references) {
        super(model, parents, elements);
        this.predicates = ImmutableMap.copyOf(predicates);
        this.connectionReferences = ImmutableMap.copyOf(references);
    }

    public List<ConnectingModelElement> getElements() {
        return super.getElements();
    }

    @Override
    public ConnectionPredicate getConnectionPredicate(String texture) {
        return this.predicates.get(texture);
    }

    @Override
    public ConnectionPredicate getDefaultConnectionPredicate() {
        return this.getConnectionPredicate("default");
    }

    @Override
    public Map<String, ConnectionPredicate> getAllConnectionPredicates() {
        return this.predicates;
    }

    public Map<String, String> getConnectionReferences() {
        return this.connectionReferences;
    }

    @Override
    public List<BaseModelQuad> bakeQuads(ModelBakingContext context) {
        ArrayList<BaseModelQuad> quads = new ArrayList<BaseModelQuad>();
        this.bakeQuads(context, ModelInstance.of(DefaultModelTypes.CONNECTING, this), new LinkedList(), quads::add);
        return quads;
    }

    private void bakeQuads(ModelBakingContext context, ModelInstance<?> model, Deque<ModelInstance<?>> modelStack, Consumer<BaseModelQuad> output) {
        modelStack.addLast(model);
        List<class_785> elements = null;
        if (model.getModelType() == DefaultModelTypes.BASE || model.getModelType() == DefaultModelTypes.CONNECTING) {
            elements = ((BaseModelDataImpl)model.getModelData()).getElements();
        } else {
            class_793 vanillaModel = model.getAsVanillaModel();
            if (vanillaModel != null) {
                elements = vanillaModel == class_1088.field_5400 ? this.generateItemModel(context, modelStack) : vanillaModel.field_4245;
            }
        }
        if (elements != null && !elements.isEmpty()) {
            for (class_785 element : elements) {
                for (class_2350 direction : element.field_4230.keySet()) {
                    class_783 face = (class_783)element.field_4230.get(direction);
                    class_1058 sprite = context.getTexture(this.resolveMaterial(context, modelStack, face.field_4224));
                    class_777 quad = FACE_BAKERY.method_3468(element.field_4228, element.field_4231, face, sprite, direction, context.getTransformation(), element.field_4232, element.field_4229, context.getModelIdentifier());
                    class_2350 cullDirection = face.field_4225 != null ? class_2350.method_23225((Matrix4f)context.getTransformation().method_3509().method_22936(), (class_2350)face.field_4225) : null;
                    Integer lightEmission = element instanceof BaseModelElement ? ((BaseModelElement)element).light_emission : null;
                    String connectionsKey = element instanceof ConnectingModelElement && ((ConnectingModelElement)element).faceConnectionKeys.containsKey(direction) ? ((ConnectingModelElement)element).faceConnectionKeys.get(direction) : face.field_4224;
                    ConnectionPredicate predicate = this.resolveConnectionKey(context, modelStack, connectionsKey);
                    output.accept(new ConnectingModelQuad(quad, cullDirection, lightEmission, predicate));
                }
            }
            modelStack.pop();
            return;
        }
        for (class_2960 location : model.getParentModels()) {
            ModelInstance<?> dependency = context.getModel(location);
            if (dependency == null) continue;
            this.bakeQuads(context, dependency, modelStack, output);
        }
        modelStack.removeLast();
    }

    private ConnectionPredicate resolveConnectionKey(ModelBakingContext context, Deque<ModelInstance<?>> modelStack, String key) {
        if (key.charAt(0) == '#') {
            key = key.substring(1);
        }
        ArrayList<String> encounteredKeys = new ArrayList<String>();
        encounteredKeys.add(key);
        String currentKey = key;
        while (true) {
            String newKey = null;
            for (ModelInstance<?> model : modelStack) {
                if (model.getModelType() != DefaultModelTypes.CONNECTING) continue;
                ConnectionPredicate predicate = ((ConnectingModelDataImpl)model.getModelData()).predicates.get(currentKey);
                if (predicate != null) {
                    return predicate;
                }
                String reference = ((ConnectingModelDataImpl)model.getModelData()).connectionReferences.get(currentKey);
                if (reference == null) continue;
                newKey = reference;
                break;
            }
            if (newKey == null) {
                for (ModelInstance<?> model : modelStack) {
                    com.mojang.datafixers.util.Either materialEither;
                    class_793 vanillaModel = model.getAsVanillaModel();
                    if (vanillaModel == null || (materialEither = (com.mojang.datafixers.util.Either)vanillaModel.field_4251.get(currentKey)) == null) continue;
                    newKey = (String)materialEither.map(m -> m.method_24147().toString(), Function.identity());
                    break;
                }
            }
            if (newKey == null) {
                Either<ConnectionPredicate, String> entry = ConnectingModelDataImpl.findConnectionsEntry(context, modelStack.getLast(), currentKey);
                if (entry != null && entry.isLeft()) {
                    return entry.left();
                }
                if (entry != null && entry.isRight()) {
                    newKey = entry.right();
                }
            }
            if (newKey == null && !currentKey.equals("default")) {
                newKey = "default";
            }
            if (newKey == null) {
                return null;
            }
            currentKey = newKey;
            if (currentKey.charAt(0) == '#') {
                currentKey = currentKey.substring(1);
            }
            if (encounteredKeys.contains(currentKey)) {
                FusionClient.LOGGER.warn("Unable to resolve connections due to circular references {}->'{}' in '{}'!", new Object[]{encounteredKeys.stream().map(o -> "'" + o + "'").collect(Collectors.joining("->")), currentKey, context.getModelIdentifier()});
                return null;
            }
            encounteredKeys.add(currentKey);
        }
    }

    private static Either<ConnectionPredicate, String> findConnectionsEntry(ModelBakingContext context, ModelInstance<?> model, String key) {
        if (model.getModelType() == DefaultModelTypes.CONNECTING) {
            ConnectionPredicate predicate = ((ConnectingModelDataImpl)model.getModelData()).predicates.get(key);
            if (predicate != null) {
                return Either.left(predicate);
            }
            String reference = ((ConnectingModelDataImpl)model.getModelData()).connectionReferences.get(key);
            if (reference != null) {
                return Either.right(reference);
            }
        }
        for (class_2960 location : model.getParentModels()) {
            Either<ConnectionPredicate, String> entry;
            ModelInstance<?> parent = context.getModel(location);
            if (parent == null || (entry = ConnectingModelDataImpl.findConnectionsEntry(context, parent, key)) == null) continue;
            return entry;
        }
        return null;
    }
}

