/*
 * Decompiled with CFR 0.152.
 */
package com.bibireden.data_attributes.api.util;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class Maths {
    public static <K, V> Map<K, V> enumLookupMap(V[] values, Function<V, K> keyMapping) {
        return Arrays.stream(values).collect(Collectors.toMap(keyMapping, e -> e));
    }

    public static float parse(String stringIn) {
        float value;
        try {
            value = Float.parseFloat(stringIn);
        }
        catch (NullPointerException | NumberFormatException e) {
            value = 0.0f;
        }
        return value;
    }

    public static double stairs(double x, double stretch, double steepness, double xOffset, double yOffset) {
        return steepness * stretch * (x - xOffset) - steepness * Math.sin(stretch * (x - xOffset)) + yOffset;
    }

    public static boolean isWithinLimits(double value, double min, double max) {
        return !(value < min) && !(value >= max);
    }

    public static byte[] doubleToByteArray(double value, int arraySize) {
        byte[] array = new byte[arraySize];
        ByteBuffer.wrap(array).putDouble(value);
        return array;
    }

    public static double byteArrayToDouble(byte[] array) {
        return ByteBuffer.wrap(array).getDouble();
    }
}

