/*
 * Decompiled with CFR 0.152.
 */
package com.bibireden.data_attributes;

import blue.endless.jankson.Jankson;
import com.bibireden.data_attributes.DataAttributesClient;
import com.bibireden.data_attributes.config.AttributeConfigManager;
import com.bibireden.data_attributes.config.entry.DefaultAttributesReloadListener;
import com.bibireden.data_attributes.config.models.DataAttributesConfig;
import com.bibireden.data_attributes.config.models.EntityTypesConfig;
import com.bibireden.data_attributes.config.models.FunctionsConfig;
import com.bibireden.data_attributes.config.models.OverridesConfig;
import com.bibireden.data_attributes.ext.LivingEntityKt;
import com.bibireden.data_attributes.networking.ConfigPacketBufs;
import com.bibireden.data_attributes.networking.NetworkingChannels;
import com.bibireden.data_attributes.serde.JanksonBuilders;
import io.netty.buffer.ByteBuf;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.format.bytebuf.ByteBufSerializer;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3248;
import net.minecraft.class_3264;
import net.minecraft.class_6860;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lcom/bibireden/data_attributes/DataAttributes;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "onInitialize", "Companion", "data-attributes"})
public final class DataAttributes
implements ModInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String MOD_ID = "data_attributes";
    @JvmField
    @NotNull
    public static final Logger LOGGER;
    @JvmField
    @NotNull
    public static final DataAttributesConfig CONFIG;
    @JvmField
    @NotNull
    public static final OverridesConfig OVERRIDES_CONFIG;
    @JvmField
    @NotNull
    public static final FunctionsConfig FUNCTIONS_CONFIG;
    @JvmField
    @NotNull
    public static final EntityTypesConfig ENTITY_TYPES_CONFIG;
    @NotNull
    private static final AttributeConfigManager MANAGER;
    @NotNull
    private static final DefaultAttributesReloadListener RELOAD_LISTENER;

    public void onInitialize() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)RELOAD_LISTENER);
        ServerLoginNetworking.registerGlobalReceiver((class_2960)NetworkingChannels.HANDSHAKE, DataAttributes::onInitialize$lambda$0);
        ServerLifecycleEvents.SERVER_STARTED.register(Companion::reload);
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register(DataAttributes::onInitialize$lambda$1);
        ServerLoginConnectionEvents.QUERY_START.register(DataAttributes::onInitialize$lambda$3);
        ServerEntityWorldChangeEvents.AFTER_ENTITY_CHANGE_WORLD.register(DataAttributes::onInitialize$lambda$4);
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register(DataAttributes::onInitialize$lambda$5);
    }

    private static final void onInitialize$lambda$0(MinecraftServer minecraftServer, class_3248 class_32482, boolean bl, class_2540 class_25402, ServerLoginNetworking.LoginSynchronizer loginSynchronizer, PacketSender packetSender) {
    }

    private static final void onInitialize$lambda$1(MinecraftServer server, class_6860 class_68602, boolean bl) {
        Intrinsics.checkNotNull((Object)server);
        Companion.reload(server);
    }

    private static final Serializer onInitialize$lambda$3$lambda$2() {
        return (Serializer)ByteBufSerializer.of((ByteBuf)((ByteBuf)PacketByteBufs.create()));
    }

    private static final void onInitialize$lambda$3(class_3248 class_32482, MinecraftServer minecraftServer, PacketSender sender, ServerLoginNetworking.LoginSynchronizer loginSynchronizer) {
        sender.sendPacket(NetworkingChannels.HANDSHAKE, (class_2540)AttributeConfigManager.Packet.ENDEC.encodeFully(DataAttributes::onInitialize$lambda$3$lambda$2, (Object)MANAGER.toPacket()));
    }

    private static final void onInitialize$lambda$4(class_1297 class_12972, class_1297 current, class_3218 class_32182, class_3218 class_32183) {
        if (current instanceof class_1309) {
            LivingEntityKt.refreshAttributes((class_1309)current);
        }
    }

    private static final void onInitialize$lambda$5(class_3222 player, class_3218 class_32182, class_3218 class_32183) {
        Intrinsics.checkNotNull((Object)player);
        LivingEntityKt.refreshAttributes((class_1309)player);
    }

    @JvmStatic
    public static final void reloadConfigs() {
        Companion.reloadConfigs();
    }

    @JvmStatic
    public static final void saveConfigs() {
        Companion.saveConfigs();
    }

    @JvmStatic
    public static final void reload(@NotNull MinecraftServer server) {
        Companion.reload(server);
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        CONFIG = DataAttributesConfig.Companion.createAndLoad$default(DataAttributesConfig.Companion, null, 1, null);
        OVERRIDES_CONFIG = OverridesConfig.Companion.createAndLoad$default(OverridesConfig.Companion, null, 1, null);
        FUNCTIONS_CONFIG = FunctionsConfig.Companion.createAndLoad((Function1<? super Jankson.Builder, Unit>)((Function1)new Function1<Jankson.Builder, Unit>((Object)JanksonBuilders.INSTANCE){

            public final void invoke(Jankson.Builder p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((JanksonBuilders)this.receiver).applyFunctions(p0);
            }
        }));
        ENTITY_TYPES_CONFIG = EntityTypesConfig.Companion.createAndLoad((Function1<? super Jankson.Builder, Unit>)((Function1)new Function1<Jankson.Builder, Unit>((Object)JanksonBuilders.INSTANCE){

            public final void invoke(Jankson.Builder p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((JanksonBuilders)this.receiver).applyEntityTypes(p0);
            }
        }));
        MANAGER = new AttributeConfigManager(null, null, 3, null);
        RELOAD_LISTENER = new DefaultAttributesReloadListener();
        ConfigPacketBufs.INSTANCE.registerPacketSerializers();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0003J\u000f\u0010\u0010\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0003J\u0017\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u001a8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001d8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0014\u0010!\u001a\u00020 8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010$\u001a\u00020#8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0017\u0010&\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\u0017\u0010+\u001a\u00020*8\u0006\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lcom/bibireden/data_attributes/DataAttributes$Companion;", "", "<init>", "()V", "", "str", "Lnet/minecraft/class_2960;", "id", "(Ljava/lang/String;)Lnet/minecraft/class_2960;", "Lnet/minecraft/class_1937;", "world", "Lcom/bibireden/data_attributes/config/AttributeConfigManager;", "getManagerFromWorld", "(Lnet/minecraft/class_1937;)Lcom/bibireden/data_attributes/config/AttributeConfigManager;", "", "reloadConfigs", "saveConfigs", "Lnet/minecraft/server/MinecraftServer;", "server", "reload", "(Lnet/minecraft/server/MinecraftServer;)V", "MOD_ID", "Ljava/lang/String;", "Lorg/apache/logging/log4j/Logger;", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "Lcom/bibireden/data_attributes/config/models/DataAttributesConfig;", "CONFIG", "Lcom/bibireden/data_attributes/config/models/DataAttributesConfig;", "Lcom/bibireden/data_attributes/config/models/OverridesConfig;", "OVERRIDES_CONFIG", "Lcom/bibireden/data_attributes/config/models/OverridesConfig;", "Lcom/bibireden/data_attributes/config/models/FunctionsConfig;", "FUNCTIONS_CONFIG", "Lcom/bibireden/data_attributes/config/models/FunctionsConfig;", "Lcom/bibireden/data_attributes/config/models/EntityTypesConfig;", "ENTITY_TYPES_CONFIG", "Lcom/bibireden/data_attributes/config/models/EntityTypesConfig;", "MANAGER", "Lcom/bibireden/data_attributes/config/AttributeConfigManager;", "getMANAGER", "()Lcom/bibireden/data_attributes/config/AttributeConfigManager;", "Lcom/bibireden/data_attributes/config/entry/DefaultAttributesReloadListener;", "RELOAD_LISTENER", "Lcom/bibireden/data_attributes/config/entry/DefaultAttributesReloadListener;", "getRELOAD_LISTENER", "()Lcom/bibireden/data_attributes/config/entry/DefaultAttributesReloadListener;", "data-attributes"})
    @SourceDebugExtension(value={"SMAP\nDataAttributes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataAttributes.kt\ncom/bibireden/data_attributes/DataAttributes$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1863#2,2:104\n*S KotlinDebug\n*F\n+ 1 DataAttributes.kt\ncom/bibireden/data_attributes/DataAttributes$Companion\n*L\n78#1:104,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeConfigManager getMANAGER() {
            return MANAGER;
        }

        @NotNull
        public final DefaultAttributesReloadListener getRELOAD_LISTENER() {
            return RELOAD_LISTENER;
        }

        @NotNull
        public final class_2960 id(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            class_2960 class_29602 = class_2960.method_43902((String)DataAttributes.MOD_ID, (String)str);
            Intrinsics.checkNotNull((Object)class_29602);
            return class_29602;
        }

        @NotNull
        public final AttributeConfigManager getManagerFromWorld(@NotNull class_1937 world) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            return world.field_9236 ? DataAttributesClient.MANAGER : this.getMANAGER();
        }

        @JvmStatic
        public final void reloadConfigs() {
            OVERRIDES_CONFIG.load();
            FUNCTIONS_CONFIG.load();
            ENTITY_TYPES_CONFIG.load();
            CONFIG.load();
        }

        @JvmStatic
        public final void saveConfigs() {
            OVERRIDES_CONFIG.save();
            FUNCTIONS_CONFIG.save();
            ENTITY_TYPES_CONFIG.save();
            CONFIG.save();
        }

        @JvmStatic
        public final void reload(@NotNull MinecraftServer server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            this.reloadConfigs();
            this.getMANAGER().update();
            this.getMANAGER().nextUpdateFlag();
            class_2540 buf = (class_2540)AttributeConfigManager.Packet.ENDEC.encodeFully(Companion::reload$lambda$0, (Object)this.getMANAGER().toPacket());
            Collection collection = PlayerLookup.all((MinecraftServer)server);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"all(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3222 player = (class_3222)element$iv;
                boolean bl = false;
                ServerPlayNetworking.send((class_3222)player, (class_2960)NetworkingChannels.RELOAD, (class_2540)buf);
            }
        }

        private static final Serializer reload$lambda$0() {
            return (Serializer)ByteBufSerializer.of((ByteBuf)((ByteBuf)PacketByteBufs.create()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

