/*
 * Decompiled with CFR 0.152.
 */
package io.github.thatpreston.mermod;

import dev.architectury.platform.Platform;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import io.github.thatpreston.mermod.Mermod;
import io.github.thatpreston.mermod.client.render.TailStyle;
import io.github.thatpreston.mermod.client.render.model.TailLayerDefinitions;
import io.github.thatpreston.mermod.compat.MermodClothConfigScreen;
import io.github.thatpreston.mermod.compat.MermodFiguraAPI;
import io.github.thatpreston.mermod.registry.RegistryHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5601;

public class MermodClient {
    public static final List<class_5601> TAIL_MODEL_LAYERS = new ArrayList<class_5601>();
    public static final class_5601 DEFAULT_TAIL_LAYER = MermodClient.createTailModelLayer("default_tail");
    public static final class_5601 H2O_TAIL_LAYER = MermodClient.createTailModelLayer("h2o_tail");
    public static final class_5601 SIREN_TAIL_LAYER = MermodClient.createTailModelLayer("siren_tail");

    public static void init() {
        MermodClient.registerConfigScreen();
        class_1935[] class_1935Array = new class_1935[1];
        class_1935Array[0] = () -> RegistryHandler.SEA_NECKLACE.get();
        ColorHandlerRegistry.registerItemColors((stack, index) -> index > 0 ? Mermod.getItemColor(stack) : -1, (class_1935[])class_1935Array);
        class_1935[] class_1935Array2 = new class_1935[2];
        class_1935Array2[0] = () -> RegistryHandler.MERMAID_BRA_MODIFIER.get();
        class_1935Array2[1] = () -> RegistryHandler.TAIL_GRADIENT_MODIFIER.get();
        ColorHandlerRegistry.registerItemColors((stack, index) -> Mermod.getItemColor(stack), (class_1935[])class_1935Array2);
        EntityModelLayerRegistry.register((class_5601)DEFAULT_TAIL_LAYER, () -> TailLayerDefinitions.getDefault(false));
        EntityModelLayerRegistry.register((class_5601)H2O_TAIL_LAYER, () -> TailLayerDefinitions.getDefault(true));
        EntityModelLayerRegistry.register((class_5601)SIREN_TAIL_LAYER, TailLayerDefinitions::getSiren);
    }

    private static class_5601 createTailModelLayer(String name) {
        class_5601 location = new class_5601(new class_2960("mermod", name), "main");
        TAIL_MODEL_LAYERS.add(location);
        return location;
    }

    private static void registerConfigScreen() {
        if (!Platform.isFabric() && Platform.isModLoaded((String)"cloth_config")) {
            Platform.getMod((String)"mermod").registerConfigurationScreen(MermodClothConfigScreen::build);
        }
    }

    public static boolean shouldTryRenderingTail(class_1657 player) {
        if (!player.method_5767()) {
            return !Mermod.figuraLoaded || MermodFiguraAPI.isTailVisible(player.method_5667());
        }
        return false;
    }

    public static TailStyle getRenderedTailStyle(class_1657 player) {
        TailStyle style;
        if (MermodClient.shouldTryRenderingTail(player) && (style = Mermod.getTailStyle(player)) != null && (player.method_5799() || style.permanent())) {
            return style;
        }
        return null;
    }

    public static boolean shouldRenderTail(class_1657 player) {
        if (player.method_5799()) {
            return MermodClient.shouldTryRenderingTail(player) && Mermod.hasTailStyle(player);
        }
        return MermodClient.getRenderedTailStyle(player) != null;
    }
}

