/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.experience.source.builtin;

import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.calculation.Calculation;
import net.puffish.skillsmod.api.calculation.operation.OperationFactory;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.calculation.prototype.Prototype;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSource;
import net.puffish.skillsmod.api.experience.source.ExperienceSourceConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSourceDisposeContext;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.calculation.LegacyBuiltinPrototypes;
import net.puffish.skillsmod.calculation.LegacyCalculation;
import net.puffish.skillsmod.calculation.operation.LegacyOperationRegistry;
import net.puffish.skillsmod.calculation.operation.builtin.AttributeOperation;
import net.puffish.skillsmod.calculation.operation.builtin.DamageTypeCondition;
import net.puffish.skillsmod.calculation.operation.builtin.EffectOperation;
import net.puffish.skillsmod.calculation.operation.builtin.EntityTypeCondition;
import net.puffish.skillsmod.calculation.operation.builtin.legacy.LegacyDamageTypeTagCondition;
import net.puffish.skillsmod.calculation.operation.builtin.legacy.LegacyEntityTypeTagCondition;

public class TakeDamageExperienceSource
implements ExperienceSource {
    private static final class_2960 ID = SkillsMod.createIdentifier("take_damage");
    private static final Prototype<Data> PROTOTYPE = Prototype.create(ID);
    private final Calculation<Data> calculation;

    private TakeDamageExperienceSource(Calculation<Data> calculation) {
        this.calculation = calculation;
    }

    public static void register() {
        SkillsAPI.registerExperienceSource(ID, TakeDamageExperienceSource::parse);
    }

    private static Result<TakeDamageExperienceSource, Problem> parse(ExperienceSourceConfigContext context) {
        return context.getData().andThen(rootElement -> LegacyCalculation.parse(rootElement, PROTOTYPE, (ConfigContext)context).mapSuccess(TakeDamageExperienceSource::new));
    }

    public int getValue(class_3222 player, class_1799 weapon, float damage, class_1282 damageSource) {
        return (int)Math.round(this.calculation.evaluate(new Data(player, weapon, damage, damageSource)));
    }

    @Override
    public void dispose(ExperienceSourceDisposeContext context) {
    }

    static {
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_player"), BuiltinPrototypes.PLAYER, OperationFactory.create(Data::player));
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_weapon_item_stack"), BuiltinPrototypes.ITEM_STACK, OperationFactory.create(Data::weapon));
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_damage_source"), BuiltinPrototypes.DAMAGE_SOURCE, OperationFactory.create(Data::damageSource));
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_taken_damage"), BuiltinPrototypes.NUMBER, OperationFactory.create(data -> data.damage()));
        LegacyOperationRegistry<Data> legacy = new LegacyOperationRegistry<Data>(PROTOTYPE);
        legacy.registerBooleanFunction("damage_type", DamageTypeCondition::parse, data -> data.damageSource().method_48792());
        legacy.registerBooleanFunction("damage_type_tag", LegacyDamageTypeTagCondition::parse, data -> data.damageSource().method_48792());
        legacy.registerOptionalBooleanFunction("attacker", EntityTypeCondition::parse, data -> Optional.ofNullable(data.damageSource().method_5529()).map(class_1297::method_5864));
        legacy.registerOptionalBooleanFunction("attacker_tag", LegacyEntityTypeTagCondition::parse, data -> Optional.ofNullable(data.damageSource().method_5529()).map(class_1297::method_5864));
        legacy.registerOptionalBooleanFunction("source", EntityTypeCondition::parse, data -> Optional.ofNullable(data.damageSource().method_5526()).map(class_1297::method_5864));
        legacy.registerOptionalBooleanFunction("source_tag", LegacyEntityTypeTagCondition::parse, data -> Optional.ofNullable(data.damageSource().method_5526()).map(class_1297::method_5864));
        legacy.registerNumberFunction("player_effect", effect -> effect.method_5578() + 1, EffectOperation::parse, Data::player);
        legacy.registerNumberFunction("player_attribute", class_1324::method_6194, AttributeOperation::parse, Data::player);
        legacy.registerNumberFunction("damage", data -> data.damage());
        LegacyBuiltinPrototypes.registerAlias(PROTOTYPE, SkillsMod.createIdentifier("player"), SkillsMod.createIdentifier("get_player"));
        LegacyBuiltinPrototypes.registerAlias(PROTOTYPE, SkillsMod.createIdentifier("damage_source"), SkillsMod.createIdentifier("get_damage_source"));
        LegacyBuiltinPrototypes.registerAlias(PROTOTYPE, SkillsMod.createIdentifier("damage"), SkillsMod.createIdentifier("get_taken_damage"));
    }

    private record Data(class_3222 player, class_1799 weapon, float damage, class_1282 damageSource) {
    }
}

