/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.commands.arguments.CategoryArgumentType;
import net.puffish.skillsmod.util.CommandUtils;
import net.puffish.skillsmod.util.PointSources;

public class PointsCommand {
    public static LiteralArgumentBuilder<class_2168> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"points").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"category", (ArgumentType)CategoryArgumentType.category()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(PointsCommand::addTotal)).then(class_2170.method_9244((String)"source", (ArgumentType)class_2232.method_9441()).executes(PointsCommand::add))))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"category", (ArgumentType)CategoryArgumentType.category()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(PointsCommand::setTotal)).then(class_2170.method_9244((String)"source", (ArgumentType)class_2232.method_9441()).executes(PointsCommand::set))))))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"category", (ArgumentType)CategoryArgumentType.category()).executes(PointsCommand::getTotal)).then(class_2170.method_9244((String)"source", (ArgumentType)class_2232.method_9441()).executes(PointsCommand::get)))));
    }

    private static int add(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection players = class_2186.method_9312(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        int count = IntegerArgumentType.getInteger(context, (String)"count");
        class_2960 source = class_2232.method_9443(context, (String)"source");
        for (class_3222 player : players) {
            category.addPoints(player, source, count);
        }
        CommandUtils.sendSuccess(context, players, "points.add", count, category.getId());
        return players.size();
    }

    private static int set(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection players = class_2186.method_9312(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        int count = IntegerArgumentType.getInteger(context, (String)"count");
        class_2960 source = class_2232.method_9443(context, (String)"source");
        for (class_3222 player : players) {
            category.setPoints(player, source, count);
        }
        CommandUtils.sendSuccess(context, players, "points.set", count, category.getId());
        return players.size();
    }

    private static int get(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"player");
        Category category = CategoryArgumentType.getCategory(context, "category");
        class_2960 source = class_2232.method_9443(context, (String)"source");
        int count = category.getPoints(player, source);
        CommandUtils.sendSuccess(context, player, "points.get", count, category.getId());
        return count;
    }

    private static int addTotal(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection players = class_2186.method_9312(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        int count = IntegerArgumentType.getInteger(context, (String)"count");
        for (class_3222 player : players) {
            category.addPoints(player, PointSources.COMMANDS, count);
        }
        CommandUtils.sendSuccess(context, players, "points.add", count, category.getId());
        return players.size();
    }

    private static int setTotal(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection players = class_2186.method_9312(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        int count = IntegerArgumentType.getInteger(context, (String)"count");
        for (class_3222 player : players) {
            category.addPoints(player, PointSources.COMMANDS, count - category.getPointsTotal(player));
        }
        CommandUtils.sendSuccess(context, players, "points.set", count, category.getId());
        return players.size();
    }

    private static int getTotal(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"player");
        Category category = CategoryArgumentType.getCategory(context, "category");
        int count = category.getPointsTotal(player);
        CommandUtils.sendSuccess(context, player, "points.get", count, category.getId());
        return count;
    }
}

