/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5223;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.jetbrains.annotations.Nullable;

public class ComponentDecomposer {
    private static final class_2583 EMPTY = class_2583.field_24360.method_36139(class_124.field_1068.method_532().intValue()).method_10982(Boolean.valueOf(false)).method_10978(Boolean.valueOf(false)).method_30938(Boolean.valueOf(false)).method_36140(Boolean.valueOf(false)).method_36141(Boolean.valueOf(false));

    public static String toFormattedString(class_2561 component) {
        StringBuilder builder = new StringBuilder();
        component.method_27658((style, string) -> {
            builder.append(ComponentDecomposer.applyLegacyFormatting(string, style));
            return Optional.empty();
        }, class_2583.field_24360);
        return builder.toString();
    }

    private static String applyLegacyFormatting(String string, class_2583 style) {
        return ComponentDecomposer.toLegacyFormatting(style).stream().map(class_124::toString).reduce(String::concat).map(formattings -> formattings.concat(string).concat(class_124.field_1070.toString())).orElse(string);
    }

    private static List<class_124> toLegacyFormatting(class_2583 style) {
        class_124 chatFormatting;
        ArrayList formattings = Lists.newArrayList();
        if (style.method_10967()) {
            return formattings;
        }
        class_5251 textColor = style.method_10973();
        if (textColor != null && (chatFormatting = class_124.method_533((String)textColor.toString())) != null) {
            formattings.add(chatFormatting);
        }
        if (style.method_10984()) {
            formattings.add(class_124.field_1067);
        }
        if (style.method_10966()) {
            formattings.add(class_124.field_1056);
        }
        if (style.method_10965()) {
            formattings.add(class_124.field_1073);
        }
        if (style.method_10986()) {
            formattings.add(class_124.field_1055);
        }
        if (style.method_10987()) {
            formattings.add(class_124.field_1051);
        }
        return ImmutableList.copyOf((Collection)formattings);
    }

    public static class_2561 toFormattedComponent(@Nullable String value) {
        return (class_2561)ComponentDecomposer.toComponentEntries(value).stream().map(entry -> class_2561.method_43470((String)entry.string().get()).method_27696(entry.style())).reduce(class_5250::method_10852).orElse(class_2561.method_43473());
    }

    public static String removeLast(@Nullable String value, int amount) {
        Deque<ComponentEntry> componentEntries = ComponentDecomposer.toComponentEntries(value);
        for (int i = 0; i < amount; ++i) {
            ComponentEntry componentEntry = componentEntries.peekLast();
            if (componentEntry == null) continue;
            if (!componentEntry.string().get().isEmpty()) {
                componentEntry.string().updateAndGet(s -> s.substring(0, s.length() - 1));
            }
            if (!componentEntry.string().get().isEmpty()) continue;
            componentEntries.pollLast();
        }
        return componentEntries.stream().map(entry -> ComponentDecomposer.applyLegacyFormatting(entry.string().get(), entry.style())).collect(Collectors.joining());
    }

    private static Deque<ComponentEntry> toComponentEntries(@Nullable String value) {
        LinkedList values = Lists.newLinkedList();
        if (value == null) {
            return values;
        }
        class_5223.method_27479((String)value, (class_2583)EMPTY, (i, style, j) -> {
            ComponentEntry last = (ComponentEntry)values.peekLast();
            if (last != null && last.style().equals((Object)style)) {
                last.string().updateAndGet(s -> s + Character.toString(j));
            } else {
                values.offerLast(new ComponentEntry(new AtomicReference<String>(Character.toString(j)), style));
            }
            return true;
        });
        return values;
    }

    public static int getStringLength(String value) {
        return ComponentDecomposer.toFormattedComponent(value).getString().length();
    }

    private record ComponentEntry(AtomicReference<String> string, class_2583 style) {
    }
}

