/*
 * Decompiled with CFR 0.152.
 */
package elocindev.tierify.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import draylar.tiered.api.PotentialAttribute;
import elocindev.tierify.gson.EntityAttributeModifierDeserializer;
import elocindev.tierify.gson.EntityAttributeModifierSerializer;
import elocindev.tierify.gson.EquipmentSlotDeserializer;
import elocindev.tierify.gson.EquipmentSlotSerializer;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttributeDataLoader
extends class_4309
implements SimpleSynchronousResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(class_1322.class, (Object)new EntityAttributeModifierDeserializer()).registerTypeAdapter(class_1322.class, (Object)new EntityAttributeModifierSerializer()).registerTypeAdapter(class_1304.class, (Object)new EquipmentSlotSerializer()).registerTypeAdapter(class_1304.class, (Object)new EquipmentSlotDeserializer()).registerTypeHierarchyAdapter(class_2583.class, (Object)new class_2583.class_2584()).create();
    private static final String PARSING_ERROR_MESSAGE = "Parsing error loading recipe {}";
    private static final String LOADED_RECIPES_MESSAGE = "Loaded {} recipes";
    private static final Logger LOGGER = LogManager.getLogger();
    private Map<class_2960, PotentialAttribute> itemAttributes = new HashMap<class_2960, PotentialAttribute>();

    public AttributeDataLoader() {
        super(GSON, "item_attributes");
    }

    protected void apply(Map<class_2960, JsonElement> loader, class_3300 manager, class_3695 profiler) {
        HashMap readItemAttributes = Maps.newHashMap();
        for (Map.Entry<class_2960, JsonElement> entry : loader.entrySet()) {
            class_2960 identifier = entry.getKey();
            try {
                PotentialAttribute itemAttribute = (PotentialAttribute)GSON.fromJson(entry.getValue(), PotentialAttribute.class);
                readItemAttributes.put(new class_2960(itemAttribute.getID()), itemAttribute);
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                LOGGER.error(PARSING_ERROR_MESSAGE, (Object)identifier, (Object)exception);
            }
        }
        this.itemAttributes = readItemAttributes;
        LOGGER.info(LOADED_RECIPES_MESSAGE, (Object)readItemAttributes.size());
    }

    public Map<class_2960, PotentialAttribute> getItemAttributes() {
        return this.itemAttributes;
    }

    public class_2960 getFabricId() {
        return new class_2960("tiered", "item_attributes");
    }

    public void method_14491(class_3300 resourceManager) {
    }
}

