/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.mixin;

import com.mojang.authlib.GameProfile;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.SpeedModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import java.util.Optional;
import net.combatroll.CombatRoll;
import net.combatroll.client.animation.AdjustmentModifier;
import net.combatroll.client.animation.AnimatablePlayer;
import net.combatroll.client.animation.AnimationRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_638;
import net.minecraft.class_742;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_742.class})
public abstract class AbstractClientPlayerEntityMixin
extends class_1657
implements AnimatablePlayer {
    private final ModifierLayer base = new ModifierLayer(null, new AbstractModifier[0]);
    private final SpeedModifier speedModifier = new SpeedModifier();
    private class_243 lastRollDirection;

    public AbstractClientPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void postInit(class_638 world, GameProfile profile, CallbackInfo ci) {
        AnimationStack stack = ((IAnimatedPlayer)this).getAnimationStack();
        this.base.addModifier((AbstractModifier)this.createAdjustmentModifier(), 0);
        this.base.addModifier((AbstractModifier)this.speedModifier, 0);
        this.speedModifier.speed = 1.2f;
        stack.addAnimLayer(1000, (IAnimation)this.base);
    }

    @Override
    public void playRollAnimation(String animationName, class_243 direction) {
        try {
            class_1657 player = this;
            KeyframeAnimation animation = AnimationRegistry.animations.get(animationName);
            KeyframeAnimation.AnimationBuilder copy = animation.mutableCopy();
            this.lastRollDirection = direction;
            int fadeIn = copy.beginTick;
            float length = copy.endTick;
            this.speedModifier.speed = length / (float)CombatRoll.config.roll_duration;
            this.base.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fadeIn, (Ease)Ease.INOUTSINE), (IAnimation)new KeyframeAnimationPlayer(copy.build(), 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AdjustmentModifier createAdjustmentModifier() {
        AbstractClientPlayerEntityMixin player = this;
        return new AdjustmentModifier(partName -> {
            float rotationX = 0.0f;
            float rotationY = 0.0f;
            float rotationZ = 0.0f;
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            float offsetZ = 0.0f;
            switch (partName) {
                case "body": {
                    if (this.lastRollDirection != null) {
                        class_243 absoluteOrientation = new class_243(0.0, 0.0, 1.0).method_1024((float)Math.toRadians(-1.0 * (double)player.field_6283));
                        float angle = (float)this.angleWithSignBetween(absoluteOrientation, this.lastRollDirection, new class_243(0.0, 1.0, 0.0));
                        rotationY = (float)Math.toRadians(angle);
                        break;
                    }
                    return Optional.empty();
                }
                default: {
                    return Optional.empty();
                }
            }
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }

    private double angleWithSignBetween(class_243 a, class_243 b, class_243 planeNormal) {
        double cosineTheta = a.method_1026(b) / (a.method_1033() * b.method_1033());
        double angle = Math.toDegrees(Math.acos(cosineTheta));
        class_243 cross = a.method_1036(b);
        if (Double.isNaN(angle *= Math.signum(cross.method_1026(planeNormal)))) {
            return 0.0;
        }
        return angle;
    }
}

