/*
 * Decompiled with CFR 0.152.
 */
package artifality.mixin.common;

import artifality.extension.PlayerExtension;
import artifality.item.BalloonItem;
import artifality.item.HauntingSoul;
import artifality.registry.ArtifalityDimensions;
import artifality.registry.ArtifalityEnchants;
import artifality.registry.ArtifalityItems;
import artifality.registry.ArtifalityParticles;
import artifality.util.EffectsUtils;
import artifality.util.TiersUtils;
import artifality.util.TrinketsUtils;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
abstract class PlayerMixin
extends class_1309
implements PlayerExtension {
    class_1657 self = (class_1657)this;
    public PlayerExtension.PlayerPosition prevPosition = null;

    protected PlayerMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"getAttackCooldownProgressPerTick"}, at={@At(value="HEAD")}, cancellable=true)
    void getAttackCooldownProgressPerTick(CallbackInfoReturnable<Float> cir) {
        if (class_1890.method_8222((class_1799)this.self.method_5998(class_1268.field_5808)).containsKey(ArtifalityEnchants.LUNAR_DAMAGE)) {
            int level = class_1890.method_8225((class_1887)ArtifalityEnchants.LUNAR_DAMAGE, (class_1799)this.self.method_5998(class_1268.field_5808));
            cir.setReturnValue((Object)Float.valueOf((float)(1.0 / this.self.method_26825(class_5134.field_23723) * 20.0) + (float)level + 2.0f));
        }
    }

    @ModifyVariable(method={"attack"}, at=@At(value="STORE", ordinal=0))
    private float modifyDamage(float original) {
        class_1799 artifact = TrinketsUtils.getTrinket(this.self, ArtifalityItems.HAUNTING_SOUL);
        if (!artifact.method_7960()) {
            return original + HauntingSoul.getDamageModifier(artifact);
        }
        return original;
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")})
    void volatileCurse(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (!this.self.method_37908().method_8608() && !this.self.method_5679(source) && source.method_5529() != null) {
            for (class_1799 stack : this.self.method_5743()) {
                if (!class_1890.method_8222((class_1799)stack).containsKey(ArtifalityEnchants.VOLATILE_CURSE) || this.self.method_7357().method_7904(stack.method_7909())) continue;
                this.self.method_37908().method_8437((class_1297)this.self, this.self.method_23317(), this.self.method_23318(), this.self.method_23321(), 1.0f, class_1937.class_7867.field_40888);
                this.self.method_7357().method_7906(stack.method_7909(), 400);
                break;
            }
        }
    }

    @Inject(method={"jump"}, at={@At(value="TAIL")})
    void jump(CallbackInfo ci) {
        if (!this.self.method_37908().method_8608() && (this.self.method_5998(class_1268.field_5808).method_31574(ArtifalityItems.BALLOON) || this.self.method_5998(class_1268.field_5810).method_31574(ArtifalityItems.BALLOON) || BalloonItem.hasBalloonOnHead(this.self))) {
            this.self.method_6092(new class_1293(class_1294.field_5902, 14, 2, false, false));
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    void tick(CallbackInfo ci) {
        if (!this.self.method_37908().method_8608()) {
            if (!(this.self.method_24828() || this.self.method_6128() || this.self.method_5799() || this.self.method_6059(class_1294.field_5902))) {
                this.useBalloon();
            }
            if (!this.self.method_7337() && this.self.method_37908().method_44013().method_29177().equals((Object)ArtifalityDimensions.LUNAR_BAZAAR.method_29177()) && this.self.method_24828() && this.self.field_6012 % 40 == 0) {
                ((class_3218)this.self.method_37908()).method_14199((class_2394)ArtifalityParticles.LUNAR_CHAIN, this.self.method_23317(), this.self.method_23318() + 0.05, this.self.method_23321(), 0, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Unique
    void useBalloon() {
        TrinketsUtils.getTrinketsArray(this.self).forEach(stack -> {
            if (stack.method_31574(ArtifalityItems.BALLOON) && stack.method_7919() != stack.method_7936()) {
                EffectsUtils.ticking((class_1309)this.self, class_1294.field_5906);
                if (this.self.method_6051().method_43048(30 * TiersUtils.getTier(stack)) == 0) {
                    stack.method_7974(stack.method_7919() + 1);
                }
            }
        });
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="HEAD")})
    void writeCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        if (this.prevPosition != null) {
            class_2487 compound = new class_2487();
            compound.method_10549("x", this.prevPosition.pos.field_1352);
            compound.method_10549("y", this.prevPosition.pos.field_1351);
            compound.method_10549("z", this.prevPosition.pos.field_1350);
            compound.method_10548("yaw", this.prevPosition.yaw);
            compound.method_10548("pitch", this.prevPosition.pitch);
            compound.method_10582("dimension", this.prevPosition.dimension.toString());
            nbt.method_10566("PrevPositionBeforeBazaar", (class_2520)compound);
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="HEAD")})
    void readCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10545("PrevPositionBeforeBazaar")) {
            class_2487 compound = nbt.method_10562("PrevPositionBeforeBazaar");
            this.prevPosition = new PlayerExtension.PlayerPosition(new class_243(compound.method_10574("x"), compound.method_10574("y"), compound.method_10574("z")), compound.method_10583("yaw"), compound.method_10583("pitch"), new class_2960(compound.method_10558("dimension")));
        }
    }

    @Override
    public void savePrevPosition() {
        this.prevPosition = new PlayerExtension.PlayerPosition(this.method_19538(), this.method_36454(), this.method_36455(), this.method_37908().method_44013().method_29177());
    }

    @Override
    public void teleportToPrevPosition() {
        if (this.prevPosition != null) {
            for (class_3218 world : this.method_5682().method_3738()) {
                if (!world.method_44013().method_29177().equals((Object)this.prevPosition.dimension)) continue;
                this.method_48105(world, this.prevPosition.pos.field_1352, this.prevPosition.pos.field_1351 + 0.5, this.prevPosition.pos.field_1350, Set.of(), this.prevPosition.yaw, this.prevPosition.pitch);
                this.resetPrevPosition();
                break;
            }
        }
    }

    @Override
    public void resetPrevPosition() {
        this.prevPosition = null;
    }

    @Override
    public void setPrevPosition(PlayerExtension.PlayerPosition pos) {
        this.prevPosition = pos;
    }

    @Override
    public PlayerExtension.PlayerPosition getPrevPosition() {
        return this.prevPosition;
    }
}

