/*
 * Decompiled with CFR 0.152.
 */
package artifality.item;

import artifality.item.ArtifactSettings;
import artifality.item.base.ArtifactItem;
import artifality.util.TiersUtils;
import artifality.util.TooltipAppender;
import dev.emi.trinkets.api.Trinket;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public class HauntingSoul
extends ArtifactItem
implements Trinket {
    public HauntingSoul(ArtifactSettings settings) {
        super(settings);
    }

    @Override
    public void appendTooltipInfo(class_1799 stack, List<class_2561> tooltip) {
        tooltip.add((class_2561)class_2561.method_43473());
        int max = 120;
        if (TiersUtils.getTier(stack) == 2) {
            max = 160;
        } else if (TiersUtils.getTier(stack) == 3) {
            max = 240;
        }
        tooltip.add((class_2561)class_2561.method_43470((String)TooltipAppender.ofKey("souls").replaceAll("%", HauntingSoul.getSouls(stack) + "/" + max)).method_27692(class_124.field_1077));
        tooltip.add((class_2561)class_2561.method_43470((String)TooltipAppender.ofKey("extra_damage").replaceAll("%", Float.toString(HauntingSoul.getDamageModifier(stack)))).method_27692(class_124.field_1077));
    }

    public static int getSouls(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (nbt.method_10545("HauntingSouls")) {
            return nbt.method_10550("HauntingSouls");
        }
        return 0;
    }

    public static float getDamageModifier(class_1799 stack) {
        int max = 120;
        if (TiersUtils.getTier(stack) == 2) {
            max = 160;
        } else if (TiersUtils.getTier(stack) == 3) {
            max = 240;
        }
        int souls = HauntingSoul.getSouls(stack);
        if (souls >= max) {
            return (float)max / 40.0f;
        }
        return (float)(souls / 20) * 0.5f;
    }

    public static void addSoul(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (nbt.method_10545("HauntingSouls")) {
            int souls = nbt.method_10550("HauntingSouls");
            nbt.method_10569("HauntingSouls", ++souls);
        } else {
            nbt.method_10569("HauntingSouls", 1);
        }
    }

    public static void addSouls(class_1799 stack, int increment) {
        class_2487 nbt = stack.method_7948();
        if (nbt.method_10545("HauntingSouls")) {
            int souls = nbt.method_10550("HauntingSouls");
            nbt.method_10569("HauntingSouls", souls += increment);
        } else {
            nbt.method_10569("HauntingSouls", increment);
        }
    }

    public static void setSouls(class_1799 stack, int count) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10569("HauntingSouls", count);
    }
}

