/*
 * Decompiled with CFR 0.152.
 */
package net.wizards.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.fabric_extras.structure_pool.api.StructurePoolConfig;
import net.spell_engine.api.item.ItemConfig;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.item.weapon.Weapon;
import net.wizards.item.Armors;
import net.wizards.item.Weapons;

public class Default {
    public static final ItemConfig itemConfig = new ItemConfig();
    public static final StructurePoolConfig villageConfig;

    @SafeVarargs
    private static <T> List<T> joinLists(List<T> ... lists) {
        return Arrays.stream(lists).flatMap(Collection::stream).collect(Collectors.toList());
    }

    static {
        for (Weapon.Entry weapon : Weapons.entries) {
            Default.itemConfig.weapons.put(weapon.name(), weapon.defaults());
        }
        for (Armor.Entry armorSet : Armors.entries) {
            Default.itemConfig.armor_sets.put(armorSet.name(), armorSet.defaults());
        }
        villageConfig = new StructurePoolConfig();
        int limit = 1;
        Default.villageConfig.entries.addAll(List.of(new StructurePoolConfig.Entry("minecraft:village/desert/houses", new ArrayList<StructurePoolConfig.Entry.Structure>(Arrays.asList(new StructurePoolConfig.Entry.Structure("wizards:village/desert/wizard_tower", 1, limit), new StructurePoolConfig.Entry.Structure("wizards:village/desert/wizard_tower_2", 3, limit)))), new StructurePoolConfig.Entry("minecraft:village/savanna/houses", "wizards:village/savanna/wizard_tower", 3, limit), new StructurePoolConfig.Entry("minecraft:village/plains/houses", "wizards:village/plains/wizard_tower", 3, limit), new StructurePoolConfig.Entry("minecraft:village/taiga/houses", "wizards:village/taiga/wizard_tower", 3, limit), new StructurePoolConfig.Entry("minecraft:village/snowy/houses", new ArrayList<StructurePoolConfig.Entry.Structure>(Arrays.asList(new StructurePoolConfig.Entry.Structure("wizards:village/snowy/wizard_tower", 1, limit), new StructurePoolConfig.Entry.Structure("wizards:village/snowy/wizard_tower_2", 3, limit))))));
    }
}

