/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_3419;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entitydata.UmbralTrespassData;
import net.soulsweaponry.events.LivingEntityTickCallback;
import net.soulsweaponry.items.DetonateGroundItem;
import net.soulsweaponry.items.IUltraHeavy;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.ModifyDamageUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public class LivingEntityMixin {
    @Unique
    private class_1282 capturedDamageSource;

    @Inject(method={"modifyAppliedDamage"}, at={@At(value="HEAD")})
    private void captureDamageSource(class_1282 source, float amount, CallbackInfoReturnable<Float> info) {
        this.capturedDamageSource = source;
    }

    @ModifyReturnValue(method={"modifyAppliedDamage"}, at={@At(value="TAIL")})
    private float modifyDamageReturnValue(float originalAmount) {
        class_1309 entity = (class_1309)this;
        if (this.capturedDamageSource != null) {
            return ModifyDamageUtil.modifyDamageTakenTail(entity, originalAmount, this.capturedDamageSource);
        }
        return originalAmount;
    }

    @Inject(method={"damage"}, at={@At(value="TAIL")})
    public void interceptDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> info) {
        class_1309 entity = (class_1309)this;
        if (((Boolean)info.getReturnValue()).booleanValue() && entity.method_6059(EffectRegistry.BLADE_DANCE)) {
            int amp = entity.method_6112(EffectRegistry.BLADE_DANCE).method_5578();
            int duration = entity.method_6112(EffectRegistry.BLADE_DANCE).method_5584();
            entity.method_6016(EffectRegistry.BLADE_DANCE);
            if (--amp >= 0) {
                entity.method_6092(new class_1293(EffectRegistry.BLADE_DANCE, duration, amp));
            }
        }
    }

    @Inject(method={"heal"}, at={@At(value="HEAD")}, cancellable=true)
    public void interceptHeal(float amount, CallbackInfo info) {
        class_1309 entity = (class_1309)this;
        if (entity.method_6059(EffectRegistry.DISABLE_HEAL)) {
            info.cancel();
        }
    }

    @Inject(method={"handleFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void interceptFallDamage(float fallDistance, float damageMultiplier, class_1282 source, CallbackInfoReturnable<Boolean> info) {
        class_1309 entity = (class_1309)this;
        if (!(entity instanceof class_1657) && DetonateGroundItem.triggerCalculateFall(entity, fallDistance, source)) {
            info.setReturnValue((Object)false);
            info.cancel();
        }
    }

    @Inject(method={"onDismounted"}, at={@At(value="HEAD")})
    public void interceptDismount(class_1297 entity, CallbackInfo info) {
        class_1309 thisEntity = (class_1309)this;
        if (!thisEntity.method_37908().field_9236 && entity instanceof class_1309) {
            class_1657 player;
            class_1309 target = (class_1309)entity;
            if (thisEntity instanceof class_1657 && UmbralTrespassData.shouldDamageRiding((class_1309)(player = (class_1657)thisEntity))) {
                float damage = UmbralTrespassData.getAbilityDamage((class_1309)player);
                boolean shouldHeal = UmbralTrespassData.shouldAbilityHeal((class_1309)player);
                if (shouldHeal) {
                    float healing = (damage += target.method_6063() * (ConfigConstructor.darkin_scythe_prime_ability_percent_health_damage / 100.0f)) * ConfigConstructor.darkin_scythe_prime_heal_modifier;
                    player.method_6025(healing);
                }
                player.method_6016(class_1294.field_5905);
                player.method_6016(EffectRegistry.GHOSTLY);
                target.method_5643(player.method_37908().method_48963().method_48812((class_1309)player), damage);
                UmbralTrespassData.setShouldDamageRiding((class_1309)player, false);
                if (!player.method_37908().field_9236 && player.method_24515() != null) {
                    player.method_37908().method_8396(null, player.method_24515(), SoundRegistry.SLICE_TARGET_EVENT, class_3419.field_15248, 0.8f, 1.0f);
                    ParticleHandler.particleOutburstMap(player.method_37908(), 150, player.method_23317(), player.method_23320(), player.method_23321(), ParticleEvents.SOUL_FLAME_SMALL_OUTBURST_MAP, 1.0f);
                }
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")}, cancellable=true)
    private void interceptTick(CallbackInfo info) {
        class_1309 entity = (class_1309)this;
        class_1269 result = ((LivingEntityTickCallback)LivingEntityTickCallback.EVENT.invoker()).tick(entity);
        if (result == class_1269.field_5814) {
            info.cancel();
        }
    }

    @Inject(method={"disablesShield"}, at={@At(value="HEAD")}, cancellable=true)
    private void interceptDisablesShield(CallbackInfoReturnable<Boolean> info) {
        IUltraHeavy item;
        class_1792 class_17922;
        class_1309 entity = (class_1309)this;
        if (ConfigConstructor.ultra_heavy_disables_shields && (class_17922 = entity.method_6047().method_7909()) instanceof IUltraHeavy && (item = (IUltraHeavy)class_17922).isHeavy()) {
            info.setReturnValue((Object)true);
            info.cancel();
        }
    }
}

