/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.staff;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1937;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.DragonStaffProjectile;
import net.soulsweaponry.entity.projectile.GrowingFireball;
import net.soulsweaponry.entity.projectile.WitheredWabbajackProjectile;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.util.LuckChosenObject;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import org.jetbrains.annotations.Nullable;

public class WitheredWabbajack
extends ModdedSword {
    private static final List<LuckChosenObject<class_1299<?>>> PROJECTILES = new ArrayList();

    public WitheredWabbajack(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, ConfigConstructor.withered_wabbajack_damage, ConfigConstructor.withered_wabbajack_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.WABBAJACK, TooltipAbilities.LUCK_BASED);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (this.isDisabled(itemStack)) {
            this.notifyDisabled((class_1309)user);
            return class_1271.method_22431((Object)itemStack);
        }
        user.method_7357().method_7906((class_1792)this, 1);
        world.method_43128(user, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14934, class_3419.field_15254, 0.5f, 2.0f / (world.method_8409().method_43057() * 0.4f + 0.8f));
        if (!world.field_9236) {
            class_1299<?> type = this.calculateProjectile((class_1309)user);
            class_1297 entity = type.method_5883(world);
            if (entity instanceof class_1676) {
                class_1676 projectile = (class_1676)entity;
                projectile.method_7432((class_1297)user);
                if (entity instanceof DragonStaffProjectile) {
                    DragonStaffProjectile dragonStaffProjectile = (DragonStaffProjectile)entity;
                    dragonStaffProjectile.setRadius(2.0f + user.method_6051().method_43057() * (float)WeaponUtil.getLuckFactor((class_1309)user));
                }
                projectile.method_23327(user.method_23317(), user.method_23320(), user.method_23321());
                if (entity instanceof GrowingFireball) {
                    GrowingFireball ball = (GrowingFireball)entity;
                    float power = 1.0f + user.method_6051().method_43057() * 10.0f * (float)WeaponUtil.getLuckFactor((class_1309)user);
                    int duration = user.method_6051().method_39332(10, 100 + 20 * WeaponUtil.getLuckFactor((class_1309)user));
                    float speed = (float)user.method_6051().method_39332(25, 300 + 20 * WeaponUtil.getLuckFactor((class_1309)user)) / 100.0f;
                    ball.setMaxAge(duration);
                    ball.setRadiusGrowth(power / (float)duration);
                    ball.method_24919((class_1297)user, user.method_36455(), user.method_36454(), 0.0f, speed, 0.0f);
                } else {
                    projectile.method_24919((class_1297)user, user.method_36455(), user.method_36454(), 0.0f, 1.5f, 0.0f);
                }
                world.method_8649(entity);
                itemStack.method_7956(1, (class_1309)user, p_220045_0_ -> p_220045_0_.method_20236(hand));
            }
            for (LuckChosenObject<class_1299<?>> luckChosenEntity : PROJECTILES) {
                luckChosenEntity.setLuckFactor(10);
            }
        }
        return class_1271.method_29237((Object)itemStack, (boolean)world.method_8608());
    }

    private class_1299<?> calculateProjectile(class_1309 user) {
        ArrayList projectileList = new ArrayList();
        for (LuckChosenObject<class_1299<?>> luckChosenObject : PROJECTILES) {
            switch (luckChosenObject.getLuckType()) {
                case BAD: {
                    luckChosenObject.setLuckFactor(luckChosenObject.getLuckFactor() - WeaponUtil.getLuckFactor(user));
                    break;
                }
                case GOOD: {
                    luckChosenObject.setLuckFactor(luckChosenObject.getLuckFactor() + WeaponUtil.getLuckFactor(user));
                }
            }
            if (luckChosenObject.getLuckFactor() <= 0) continue;
            projectileList.add(luckChosenObject);
        }
        int totalChance = 0;
        for (LuckChosenObject luckChosenObject : projectileList) {
            totalChance += luckChosenObject.getLuckFactor();
        }
        int n = user.method_6051().method_43048(totalChance);
        class_1299<?> class_12992 = this.getEntityType(projectileList, n);
        if (class_12992 != null) {
            return class_12992;
        }
        return class_1299.field_6122;
    }

    @Nullable
    private class_1299<?> getEntityType(List<LuckChosenObject<class_1299<?>>> projectileList, int random) {
        int cumulativeFactor = 0;
        for (LuckChosenObject<class_1299<?>> luckChosen : projectileList) {
            if (random >= (cumulativeFactor += luckChosen.getLuckFactor())) continue;
            return luckChosen.getObject();
        }
        return null;
    }

    @Override
    public boolean isDisabled(class_1799 stack) {
        return ConfigConstructor.disable_use_withered_wabbajack;
    }

    @Override
    public boolean canEnchantReduceCooldown(class_1799 stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(class_1799 stack) {
        return null;
    }

    @Override
    public boolean method_24358() {
        return ConfigConstructor.is_fireproof_withered_wabbajack;
    }

    static {
        PROJECTILES.add(new LuckChosenObject<class_1299>(class_1299.field_6122, WeaponUtil.LuckType.BAD));
        PROJECTILES.add(new LuckChosenObject<class_1299>(class_1299.field_6144, WeaponUtil.LuckType.BAD));
        PROJECTILES.add(new LuckChosenObject<class_1299>(class_1299.field_6082, WeaponUtil.LuckType.BAD));
        PROJECTILES.add(new LuckChosenObject<class_1299>(class_1299.field_6064, WeaponUtil.LuckType.BAD));
        PROJECTILES.add(new LuckChosenObject<class_1299>(class_1299.field_6049, WeaponUtil.LuckType.BAD));
        PROJECTILES.add(new LuckChosenObject<class_1299>(class_1299.field_6068, WeaponUtil.LuckType.BAD));
        PROJECTILES.add(new LuckChosenObject<class_1299>(class_1299.field_6130, WeaponUtil.LuckType.BAD));
        PROJECTILES.add(new LuckChosenObject<class_1299>(class_1299.field_6066, WeaponUtil.LuckType.NEUTRAL));
        PROJECTILES.add(new LuckChosenObject<class_1299<GrowingFireball>>(EntityRegistry.GROWING_FIREBALL_ENTITY, WeaponUtil.LuckType.NEUTRAL));
        PROJECTILES.add(new LuckChosenObject<class_1299<DragonStaffProjectile>>(EntityRegistry.DRAGON_STAFF_PROJECTILE, WeaponUtil.LuckType.NEUTRAL));
        PROJECTILES.add(new LuckChosenObject<class_1299<WitheredWabbajackProjectile>>(EntityRegistry.WITHERED_WABBAJACK_PROJECTILE, WeaponUtil.LuckType.GOOD));
    }
}

