/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.axe;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_756;
import net.soulsweaponry.client.renderer.item.LeviathanAxeRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.LeviathanAxeEntity;
import net.soulsweaponry.items.ModdedAxe;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LeviathanAxe
extends ModdedAxe
implements GeoItem {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);

    public LeviathanAxe(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, ConfigConstructor.leviathan_axe_damage, ConfigConstructor.leviathan_axe_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.FREEZE, TooltipAbilities.PERMAFROST, TooltipAbilities.HEAVY_THROW, TooltipAbilities.RETURNING);
    }

    @Override
    public boolean isDisabled(class_1799 stack) {
        return ConfigConstructor.disable_use_leviathan_axe;
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (this.isDisabled(stack)) {
            return super.method_7873(stack, target, attacker);
        }
        int sharpness = class_3532.method_15375((float)class_1890.method_8218((class_1799)stack, (class_1310)target.method_6046()));
        target.method_6092(new class_1293(EffectRegistry.FREEZING, 200, sharpness));
        return super.method_7873(stack, target, attacker);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        super.method_7840(stack, world, user, remainingUseTicks);
        if (user instanceof class_1657) {
            class_1657 playerEntity = (class_1657)user;
            int i = this.method_7881(stack) - remainingUseTicks;
            if (i >= 10) {
                stack.method_7956(3, (class_1309)playerEntity, p_220045_0_ -> p_220045_0_.method_20236(user.method_6058()));
                LeviathanAxeEntity entity = new LeviathanAxeEntity(world, user, stack);
                entity.saveOnPlayer(playerEntity);
                float speed = (float)class_1890.method_8225((class_1887)class_1893.field_9118, (class_1799)stack) / 5.0f;
                entity.method_24919((class_1297)playerEntity, playerEntity.method_36455(), playerEntity.method_36454(), 0.0f, 2.5f + speed, 1.0f);
                entity.field_7572 = class_1665.class_1666.field_7594;
                world.method_8649((class_1297)entity);
                world.method_8396(playerEntity, playerEntity.method_24515(), class_3417.field_15001, class_3419.field_15248, 1.0f, 0.5f);
                if (!playerEntity.method_31549().field_7477) {
                    playerEntity.method_31548().method_7378(stack);
                }
            }
        }
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8951;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (this.isDisabled(itemStack)) {
            this.notifyDisabled((class_1309)user);
            return class_1271.method_22431((Object)user.method_5998(hand));
        }
        if (itemStack.method_7919() >= itemStack.method_7936() - 1) {
            return class_1271.method_22431((Object)itemStack);
        }
        user.method_6019(hand);
        return class_1271.method_22428((Object)itemStack);
    }

    public static void iceExplosion(class_1937 world, class_2338 pos, @Nullable class_1297 attacker, int amplifier) {
        class_238 box = new class_238(pos).method_1014(1.0);
        List entities = world.method_8335(attacker, box);
        for (class_1297 entity : entities) {
            if (!(entity instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)entity;
            if (entity instanceof class_1657) continue;
            livingEntity.method_5643(world.method_48963().method_48836(), (float)(amplifier + 1) * 1.5f);
            livingEntity.method_6092(new class_1293(EffectRegistry.FREEZING, 200, amplifier));
        }
        if (!world.field_9236) {
            ParticleHandler.particleSphere(world, 300, pos.method_10263(), (float)pos.method_10264() + 0.5f, pos.method_10260(), ParticleEvents.ICE_PARTICLE, 1.0f);
        }
        world.method_8396(null, pos, class_3417.field_15081, class_3419.field_15251, 1.0f, 1.0f);
        world.method_8396(null, pos, class_3417.field_15081, class_3419.field_15251, 1.0f, 0.5f);
    }

    @Override
    public boolean method_24358() {
        return ConfigConstructor.is_fireproof_leviathan_axe;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private final LeviathanAxeRenderer renderer = new LeviathanAxeRenderer();

            public class_756 getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    @Override
    public boolean canEnchantReduceCooldown(class_1799 stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(class_1799 stack) {
        return null;
    }
}

