/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.soulsweaponry.registry.ParticleRegistry;

public class DeathSpiralLogic {
    private final class_243 pos;
    private final float radius;
    private int age;
    private boolean switchParticle = true;
    private final List<List<class_243>> spirals;

    public DeathSpiralLogic(class_243 pos, float radius) {
        this.pos = pos;
        this.radius = radius;
        this.spirals = this.getSpirals();
    }

    public void tick(class_1937 world, class_243 origin) {
        ++this.age;
        if (world.field_9236) {
            for (List<class_243> list : this.spirals) {
                if (list.size() == 0) continue;
                class_2400 type = this.switchParticle ? ParticleRegistry.DAZZLING_PARTICLE : ParticleRegistry.DARK_STAR;
                class_243 vec = new class_243(list.get(0).method_10216(), list.get(0).method_10214(), list.get(0).method_10215()).method_1019(origin);
                world.method_8406((class_2394)type, vec.method_10216(), vec.method_10214(), vec.method_10215(), 0.0, 0.0, 0.0);
                this.switchParticle = !this.switchParticle;
                list.remove(0);
            }
        }
    }

    private List<List<class_243>> getSpirals() {
        ArrayList<class_243> list1 = new ArrayList<class_243>();
        ArrayList<class_243> list2 = new ArrayList<class_243>();
        ArrayList<List<class_243>> list3 = new ArrayList<List<class_243>>();
        float r = this.radius;
        for (int theta = 0; theta < 360; ++theta) {
            if (theta % 2 != 0) continue;
            double x0 = this.pos.method_10216();
            double y0 = this.pos.method_10214() + 3.0;
            double z0 = this.pos.method_10215();
            double x = x0 + (double)r * Math.cos((double)theta * Math.PI / 180.0);
            double z = z0 + (double)r * Math.sin((double)theta * Math.PI / 180.0);
            list1.add(new class_243(x, this.pos.method_10214() + (double)theta * Math.PI / 180.0, z));
            list2.add(new class_243(x, y0 + (double)r * Math.tan((double)theta * Math.PI / 180.0), z));
        }
        list3.add(list1);
        list3.add(list2);
        return list3;
    }

    public boolean isFinished() {
        int i = 0;
        for (List<class_243> list : this.spirals) {
            i += list.size();
        }
        return i == 0;
    }
}

