/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1352;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1669;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.soulsweaponry.entity.mobs.Remnant;
import net.soulsweaponry.entity.mobs.SoulReaperGhost;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import net.soulsweaponry.util.IAnimatedDeath;
import net.soulsweaponry.util.WeaponUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class Soulmass
extends Remnant
implements GeoEntity,
IAnimatedDeath {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public int deathTicks;
    private List<Integer> summonIds = new ArrayList<Integer>();
    private static final class_2940<Boolean> CLAP = class_2945.method_12791(Soulmass.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SMASH = class_2945.method_12791(Soulmass.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> START_BEAM = class_2945.method_12791(Soulmass.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> STOP_BEAM = class_2945.method_12791(Soulmass.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> BEAMING = class_2945.method_12791(Soulmass.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SACRIFICE = class_2945.method_12791(Soulmass.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_2338> BEAM_CORDS = class_2945.method_12791(Soulmass.class, (class_2941)class_2943.field_13324);

    public Soulmass(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 30;
    }

    private PlayState predicate(AnimationState<?> state) {
        if (this.getSacrifice()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("sacrifice"));
        } else if (this.getStartBeam()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("start_beam"));
        } else if (this.method_5715()) {
            state.getController().setAnimation(RawAnimation.begin().then("start_beam", Animation.LoopType.HOLD_ON_LAST_FRAME));
        } else if (this.getStopBeam()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("stop_beam"));
        } else if (this.getBeaming()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("beaming"));
        } else if (this.getClap()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("clap"));
        } else if (this.getSmash()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("smash_ground"));
        } else {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
        }
        return PlayState.CONTINUE;
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(2, (class_1352)new SoulmassGoal(this));
        super.method_5959();
    }

    public boolean method_5810() {
        return false;
    }

    @Override
    public int getSoulAmount() {
        return 30;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CLAP, (Object)Boolean.FALSE);
        this.field_6011.method_12784(SMASH, (Object)Boolean.FALSE);
        this.field_6011.method_12784(START_BEAM, (Object)Boolean.FALSE);
        this.field_6011.method_12784(STOP_BEAM, (Object)Boolean.FALSE);
        this.field_6011.method_12784(BEAMING, (Object)Boolean.FALSE);
        this.field_6011.method_12784(SACRIFICE, (Object)Boolean.FALSE);
        this.field_6011.method_12784(BEAM_CORDS, (Object)new class_2338(0, 0, 0));
    }

    public static class_5132.class_5133 createSoulmassAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 20.0).method_26868(class_5134.field_23716, 50.0).method_26868(class_5134.field_23719, 0.28).method_26868(class_5134.field_23721, 8.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23724, 4.0);
    }

    public void setClap(boolean bl) {
        this.field_6011.method_12778(CLAP, (Object)bl);
    }

    public boolean getClap() {
        return (Boolean)this.field_6011.method_12789(CLAP);
    }

    public void setSmash(boolean bl) {
        this.field_6011.method_12778(SMASH, (Object)bl);
    }

    public boolean getSmash() {
        return (Boolean)this.field_6011.method_12789(SMASH);
    }

    public void setStartBeam(boolean bl) {
        this.field_6011.method_12778(START_BEAM, (Object)bl);
    }

    public boolean getStartBeam() {
        return (Boolean)this.field_6011.method_12789(START_BEAM);
    }

    public void setStopBeam(boolean bl) {
        this.field_6011.method_12778(STOP_BEAM, (Object)bl);
    }

    public boolean getStopBeam() {
        return (Boolean)this.field_6011.method_12789(STOP_BEAM);
    }

    public void setBeaming(boolean bl) {
        this.field_6011.method_12778(BEAMING, (Object)bl);
    }

    public boolean getBeaming() {
        return (Boolean)this.field_6011.method_12789(BEAMING);
    }

    public void setSacrifice(boolean bl) {
        this.field_6011.method_12778(SACRIFICE, (Object)bl);
    }

    public boolean getSacrifice() {
        return (Boolean)this.field_6011.method_12789(SACRIFICE);
    }

    public void setBeamCords(double x, double y, double z) {
        this.field_6011.method_12778(BEAM_CORDS, (Object)class_2338.method_49637((double)x, (double)y, (double)z));
    }

    public class_2338 getBeamCords() {
        return (class_2338)this.field_6011.method_12789(BEAM_CORDS);
    }

    public void resetAnimations() {
        this.setClap(false);
        this.setSmash(false);
        this.setBeaming(false);
        this.setStartBeam(false);
        this.setStopBeam(false);
    }

    @Override
    public int getTicksUntilDeath() {
        return 60;
    }

    @Override
    public void setDeath() {
        this.setSacrifice(true);
    }

    @Override
    public void method_6078(class_1282 damageSource) {
        super.method_6078(damageSource);
        this.setDeath();
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public void method_6108() {
        ++this.deathTicks;
        if (this.deathTicks >= this.getTicksUntilDeath() && !this.method_37908().method_8608()) {
            this.method_37908().method_8421((class_1297)this, (byte)60);
            CustomDeathHandler.deathExplosionEvent(this.method_37908(), this.method_19538(), SoundRegistry.DAWNBREAKER_EVENT, new class_2394[]{ParticleRegistry.PURPLE_FLAME, class_2398.field_22246, class_2398.field_11237});
            this.sacrificeEvent();
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    public void sacrificeEvent() {
        class_238 chunkBox = new class_238(this.method_24515()).method_1014(16.0);
        List nearbyEntities = this.method_37908().method_8335((class_1297)this, chunkBox);
        for (class_1297 nearbyEntity : nearbyEntities) {
            if (!(nearbyEntity instanceof class_1588)) continue;
            class_1309 closestTarget = (class_1309)nearbyEntity;
            closestTarget.method_6092(new class_1293(class_1294.field_5909, 80, 1));
            closestTarget.method_6092(new class_1293(class_1294.field_5911, 80, 1));
            closestTarget.method_5643(this.method_37908().method_48963().method_48831(), 16.0f);
        }
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10572("summon_ids", this.summonIds);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("summon_ids")) {
            this.summonIds = WeaponUtil.arrayToList(nbt.method_10561("summon_ids"));
        }
    }

    public void addSummonIds(int id) {
        this.summonIds.add(id);
    }

    public boolean hasSummonsAlive() {
        if (!this.method_37908().field_9236) {
            for (int id : this.summonIds) {
                if (this.method_37908().method_8469(id) == null) continue;
                return true;
            }
        }
        this.summonIds.clear();
        return false;
    }

    @Override
    public void method_6007() {
        super.method_6007();
        this.method_37908().method_8406((class_2394)class_2398.field_11237, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_5715() && !this.method_29504()) {
            this.soulCircle(this.method_37908(), this.method_23317(), this.method_23320() + 1.0, this.method_23321());
            if (this.method_6032() < this.method_6063()) {
                this.method_6025(1.0f);
            }
        } else if (this.getBeaming()) {
            double e = (double)this.getBeamCords().method_10263() - this.method_23317();
            double f = (double)this.getBeamCords().method_10264() - this.method_23320();
            double g = (double)this.getBeamCords().method_10260() - this.method_23321();
            double h = Math.sqrt(e * e + f * f + g * g);
            e /= h;
            f /= h;
            g /= h;
            double j = this.field_5974.method_43058();
            for (int i = 0; i < 10; ++i) {
                this.method_37908().method_8406((class_2394)class_2398.field_22246, this.method_23317() + e * (j += 0.5 + this.field_5974.method_43058()), this.method_23320() + 1.0 + f * j, this.method_23321() + g * j, 0.0, 0.0, 0.0);
                this.method_37908().method_8406((class_2394)class_2398.field_23114, this.method_23317() + e * j, this.method_23320() + 1.0 + f * j, this.method_23321() + g * j, 0.0, 0.0, 0.0);
            }
            this.soulCircle(this.method_37908(), this.method_23317(), this.method_23320() + 1.0, this.method_23321());
        }
    }

    public void soulCircle(class_1937 world, double x, double y, double z) {
        double points = 30.0;
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        int i = 0;
        while ((double)i < points) {
            double velocityY = 1.0 - (double)i / (points - 1.0) * 2.0;
            double radius = Math.sqrt(1.0 - velocityY * velocityY);
            double theta = phi * (double)i;
            double velocityX = Math.cos(theta) * radius;
            double velocityZ = Math.sin(theta) * radius;
            world.method_8466((class_2394)class_2398.field_22246, true, x + velocityX / 2.0, y + velocityY / 2.0, z + velocityZ / 2.0, 0.0, 0.0, 0.0);
            ++i;
        }
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14688;
    }

    @Override
    protected class_3414 method_5994() {
        return SoundRegistry.SOULMASS_IDLE_EVENT;
    }

    @Override
    protected class_3414 method_6002() {
        return class_3417.field_14931;
    }

    @Override
    public void initEquip() {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    static class SoulmassGoal
    extends class_1352 {
        private final Soulmass entity;
        private int attackCooldown;
        private int attackStatus;
        private int uniqueCooldown;
        private int nextAttack = 0;

        public SoulmassGoal(Soulmass entity) {
            this.entity = entity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 target = this.entity.method_5968();
            return target != null && target.method_5805() && this.entity.method_18395(target);
        }

        public void method_6270() {
            super.method_6270();
            this.entity.resetAnimations();
            this.entity.method_19540(false);
            this.resetCooldowns(10, 10);
        }

        public void newAttack() {
            this.nextAttack = this.entity.field_5974.method_43048(5);
        }

        private void resetCooldowns(int uniqueCooldown, int attackCooldown) {
            this.attackCooldown = attackCooldown;
            this.uniqueCooldown = uniqueCooldown;
            this.attackStatus = 0;
            this.newAttack();
        }

        public void method_6268() {
            class_1309 target;
            if (this.attackCooldown > -1) {
                --this.attackCooldown;
            }
            if (this.uniqueCooldown > -1) {
                --this.uniqueCooldown;
            }
            if ((target = this.entity.method_5968()) != null) {
                double distanceToEntity = this.entity.method_5858((class_1297)target);
                this.entity.method_19540(true);
                this.entity.method_5988().method_20248(target.method_23317(), target.method_23320(), target.method_23321());
                if (this.attackCooldown < 0) {
                    if (this.nextAttack > 1) {
                        this.entity.setClap(true);
                    } else if (this.uniqueCooldown > 10) {
                        this.newAttack();
                    }
                    if (this.uniqueCooldown < 0) {
                        if (this.nextAttack == 0) {
                            this.entity.setStartBeam(true);
                            this.resetCooldowns(80, 50);
                        } else if (this.nextAttack == 1) {
                            if (!this.entity.hasSummonsAlive()) {
                                this.entity.setSmash(true);
                            } else {
                                this.entity.setSmash(false);
                                this.newAttack();
                            }
                        }
                    }
                }
                if (this.entity.getClap()) {
                    ++this.attackStatus;
                    if (this.attackStatus == 5) {
                        this.castSpell(target);
                    } else if (this.attackStatus >= 20) {
                        this.entity.setClap(false);
                        this.resetCooldowns(0, 10);
                    }
                }
                if (this.entity.getSmash()) {
                    ++this.attackStatus;
                    if (this.attackStatus == 10) {
                        int[][] cords;
                        for (int[] cord : cords = new int[][]{{4, 4}, {-4, 4}, {4, -4}, {-4, -4}}) {
                            class_243 pos = new class_243(this.entity.method_23317() + (double)cord[0], this.entity.method_23318(), this.entity.method_23321() + (double)cord[1]);
                            if (!this.entity.method_37908().field_9236) {
                                ParticleHandler.particleOutburstMap(this.entity.method_37908(), 50, pos.method_10216(), pos.method_10214(), pos.method_10215(), ParticleEvents.CONJURE_ENTITY_MAP, 1.0f);
                            }
                            this.entity.method_37908().method_8396(null, target.method_24515(), SoundRegistry.NIGHTFALL_SPAWN_EVENT, class_3419.field_15248, 0.6f, 1.0f);
                            SoulReaperGhost mob = new SoulReaperGhost(EntityRegistry.SOUL_REAPER_GHOST, this.entity.method_37908());
                            mob.setSoulAmount(0);
                            this.entity.addSummonIds(mob.method_5628());
                            mob.method_23327(this.entity.method_23317() + (double)cord[0], this.entity.method_23318() + (double)0.1f, this.entity.method_23321() + (double)cord[1]);
                            if (this.entity.method_35057() instanceof class_1657) {
                                mob.method_6170((class_1657)this.entity.method_35057());
                            }
                            this.entity.method_37908().method_8649((class_1297)mob);
                        }
                    } else if (this.attackStatus >= 20) {
                        this.entity.setSmash(false);
                        this.resetCooldowns(100, 10);
                    }
                }
                if (this.entity.getStartBeam()) {
                    ++this.attackStatus;
                    if (this.attackStatus == 12) {
                        this.entity.setBeaming(true);
                        this.attackStatus = 0;
                        this.entity.setStartBeam(false);
                    }
                }
                if (this.entity.getBeaming()) {
                    ++this.attackStatus;
                    if (this.attackStatus > 30 || target.method_29504() || distanceToEntity > 140.0) {
                        this.entity.setBeaming(false);
                        this.entity.setStopBeam(true);
                        this.attackStatus = 0;
                    }
                    this.entity.setBeamCords(target.method_31477(), target.method_23320(), target.method_31479());
                    if (this.attackStatus % 5 == 0 && distanceToEntity < 130.0) {
                        target.method_5643(this.entity.method_37908().method_48963().method_48812((class_1309)this.entity), 6.0f);
                        this.entity.method_6025(2.0f);
                        this.entity.method_37908().method_8396(null, target.method_24515(), class_3417.field_14970, class_3419.field_15248, 1.0f, 1.0f);
                    }
                }
                if (this.entity.getStopBeam()) {
                    ++this.attackStatus;
                    if (this.attackStatus == 12) {
                        this.entity.setStopBeam(false);
                        this.resetCooldowns(150, 10);
                    }
                }
                super.method_6268();
            }
        }

        protected void castSpell(class_1309 livingEntity) {
            double d = Math.min(livingEntity.method_23318(), this.entity.method_23318());
            double e = Math.max(livingEntity.method_23318(), this.entity.method_23318()) + 1.0;
            float f = (float)class_3532.method_15349((double)(livingEntity.method_23321() - this.entity.method_23321()), (double)(livingEntity.method_23317() - this.entity.method_23317()));
            if (this.entity.method_5858((class_1297)livingEntity) < 9.0) {
                float g;
                int i;
                for (i = 0; i < 5; ++i) {
                    g = f + (float)i * (float)Math.PI * 0.4f;
                    this.conjureFangs(this.entity.method_23317() + (double)class_3532.method_15362((float)g) * 1.5, this.entity.method_23321() + (double)class_3532.method_15374((float)g) * 1.5, d, e, g, 0);
                }
                for (i = 0; i < 8; ++i) {
                    g = f + (float)i * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.conjureFangs(this.entity.method_23317() + (double)class_3532.method_15362((float)g) * 2.5, this.entity.method_23321() + (double)class_3532.method_15374((float)g) * 2.5, d, e, g, 3);
                }
            } else {
                for (int i = 0; i < 16; ++i) {
                    double h = 1.25 * (double)(i + 1);
                    this.conjureFangs(this.entity.method_23317() + (double)class_3532.method_15362((float)f) * h, this.entity.method_23321() + (double)class_3532.method_15374((float)f) * h, d, e, f, i);
                }
            }
        }

        private void conjureFangs(double x, double z, double maxY, double y, float yaw, int warmup) {
            class_2338 blockPos = new class_2338((int)x, (int)y, (int)z);
            boolean bl = false;
            double d = 0.0;
            do {
                class_2680 blockState2;
                class_265 voxelShape;
                class_2338 blockPos2 = blockPos.method_10074();
                class_2680 blockState = this.entity.method_37908().method_8320(blockPos2);
                if (!blockState.method_26206((class_1922)this.entity.method_37908(), blockPos2, class_2350.field_11036)) continue;
                if (!this.entity.method_37908().method_22347(blockPos) && !(voxelShape = (blockState2 = this.entity.method_37908().method_8320(blockPos)).method_26220((class_1922)this.entity.method_37908(), blockPos)).method_1110()) {
                    d = voxelShape.method_1105(class_2350.class_2351.field_11052);
                }
                bl = true;
                break;
            } while ((blockPos = blockPos.method_10074()).method_10264() >= class_3532.method_15357((double)maxY) - 1);
            if (bl) {
                this.entity.method_37908().method_8649((class_1297)new class_1669(this.entity.method_37908(), x, (double)blockPos.method_10264() + d, z, yaw, warmup, (class_1309)this.entity));
            }
        }
    }
}

