/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1403;
import net.minecraft.class_1406;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1924;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6025;
import net.minecraft.class_6067;
import net.minecraft.class_8567;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.IConfigDisable;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.BlockRegistry;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import org.jetbrains.annotations.Nullable;

public class BigChungus
extends class_1321
implements class_6067 {
    private static final class_2940<Integer> STATE = class_2945.method_12791(BigChungus.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> AGGRESSIVE = class_2945.method_12791(BigChungus.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> TRADE_TICKS = class_2945.method_12791(BigChungus.class, (class_2941)class_2943.field_13327);
    private boolean healthUpdated = false;
    private final class_1277 inventory = new class_1277(1);
    private int maxTradeCount = 16;
    private float turnChance = 1.0f / (float)this.maxTradeCount;

    public BigChungus(class_1299<? extends BigChungus> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 50;
        this.method_6173(false);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(2, (class_1352)new class_1366((class_1314)this, 2.0, false));
        this.field_6201.method_6277(3, (class_1352)new class_1350((class_1321)this, 1.0, 10.0f, 5.0f, false));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new class_1406((class_1321)this));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, true, p -> (!p.method_6059(EffectRegistry.CHUNGUS_TONIC_EFFECT) || this.isAggressive()) && !this.method_6181()));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, class_1308.class, true, entity -> entity instanceof class_1569 && !(entity instanceof class_1548) && this.method_6181() && !this.method_5722((class_1297)entity)));
        this.field_6185.method_6277(6, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
    }

    public static class_5132.class_5133 createChungusAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23716, 14.0).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23721, 2.0);
    }

    public boolean method_5957(class_4538 view) {
        class_2338 blockUnderEntity = new class_2338(this.method_31477(), this.method_31478() - 1, this.method_31479());
        class_2338 positionEntity = new class_2338(this.method_31477(), this.method_31478(), this.method_31479());
        class_2680 state = this.method_37908().method_8320(positionEntity);
        return view.method_8606((class_1297)this) && this.method_37908().method_23886() && !this.method_37908().method_22345(this.method_5829()) && state.method_26204().method_9538(state) && this.method_37908().method_8320(blockUnderEntity).method_26170((class_1922)view, blockUnderEntity, EntityRegistry.BIG_CHUNGUS) && this.isSpawnable() && this.checkForMonolith();
    }

    public boolean checkForMonolith() {
        class_2338 entityPos = this.method_24515();
        int radius = ConfigConstructor.chungus_monolith_radius;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x * x + z * z > radius * radius) continue;
                class_2338 checkPos = entityPos.method_10069(x, 0, z);
                class_2248 block = this.method_37908().method_8320(checkPos).method_26204();
                if (block != BlockRegistry.CHUNGUS_MONOLITH) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSpawnable() {
        return ConfigConstructor.can_moderatly_sized_chungus_spawn;
    }

    protected class_3414 method_5994() {
        return SoundRegistry.BIG_CHUNGUS_EVENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15164;
    }

    protected class_3414 method_6002() {
        return SoundRegistry.FART_EVENT;
    }

    protected class_3414 getStepSound() {
        return class_3417.field_14894;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(this.getStepSound(), 0.15f, 1.0f);
    }

    protected void method_5958() {
        super.method_5958();
        if (!this.healthUpdated) {
            int rand = this.method_6051().method_43048(100);
            switch (rand) {
                case 1: {
                    this.setState(ChungusStates.BOSNIAN);
                    this.updateStats(50.0f, 200);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.setState(ChungusStates.DREAM);
                    break;
                }
                default: {
                    this.setState(ChungusStates.NORMAL);
                }
            }
            this.healthUpdated = true;
        }
        if (!this.method_35199().method_5442() && !this.isAggressive()) {
            this.increaseTradeTicks(1);
            this.method_6092(new class_1293(class_1294.field_5909, 30, 250, true, false));
            this.method_6092(new class_1293(class_1294.field_5911, 30, 250, true, false));
            if (this.getTradeTicks() >= 60 && !this.method_37908().field_9236) {
                this.inventory.method_24514();
                switch (this.getState()) {
                    case BOSNIAN: {
                        ParticleHandler.particleSphereList(this.method_37908(), 10, this.method_23317(), this.method_23318(), this.method_23321(), ParticleEvents.DARK_EXPLOSION_LIST, 0.2f);
                        break;
                    }
                    case DREAM: {
                        class_1792 item = this.method_6051().method_43056() ? class_1802.field_8634 : class_1802.field_8894;
                        for (int i = 0; i < this.method_6051().method_39332(1, 9); ++i) {
                            this.trade(item.method_7854());
                        }
                        break;
                    }
                    default: {
                        this.trade(this.getBarterItem());
                    }
                }
                this.setTradeTicks(0);
            }
        }
    }

    private void trade(class_1799 stack) {
        class_1542 entity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), stack);
        entity.method_18800(0.0, 0.5, 0.0);
        this.method_37908().method_8649((class_1297)entity);
        this.maxTradeCount = Math.max(this.maxTradeCount - 1, 1);
        this.turnChance = 1.0f / (float)this.maxTradeCount;
        if (this.method_6051().method_43057() < this.turnChance) {
            this.setState(ChungusStates.BOSNIAN);
            this.updateStats(50.0f, 200);
            ParticleHandler.particleSphereList(this.method_37908(), 10, this.method_23317(), this.method_23318(), this.method_23321(), ParticleEvents.DARK_EXPLOSION_LIST, 0.2f);
        }
    }

    private void updateStats(float health, int exp) {
        this.method_5996(class_5134.field_23716).method_6192((double)health);
        this.method_6033(health);
        this.field_6194 = exp;
    }

    public void method_6007() {
        super.method_6007();
        if (this.getTradeTicks() > 0 && this.getTradeTicks() % 4 == 0) {
            for (int i = 0; i < 3; ++i) {
                this.method_37908().method_8406((class_2394)class_2398.field_17741, this.method_23322(0.8f), this.method_23319() + (double)0.2f, this.method_23325(0.8f), 0.0, 0.0, 0.0);
            }
        }
    }

    public int getTradeTicks() {
        return (Integer)this.field_6011.method_12789(TRADE_TICKS);
    }

    public void increaseTradeTicks(int i) {
        this.setTradeTicks(this.getTradeTicks() + i);
    }

    public void setTradeTicks(int i) {
        this.field_6011.method_12778(TRADE_TICKS, (Object)i);
    }

    public ChungusStates getState() {
        return ChungusStates.values()[(Integer)this.field_6011.method_12789(STATE)];
    }

    public void setState(ChungusStates state) {
        for (int i = 0; i < ChungusStates.values().length; ++i) {
            if (!ChungusStates.values()[i].equals((Object)state)) continue;
            this.field_6011.method_12778(STATE, (Object)i);
        }
    }

    public void setStateId(int state) {
        this.field_6011.method_12778(STATE, (Object)state);
    }

    public int getStateId() {
        return (Integer)this.field_6011.method_12789(STATE);
    }

    public boolean isAggressive() {
        return (Boolean)this.field_6011.method_12789(AGGRESSIVE);
    }

    public void setAggressive(boolean bl) {
        this.field_6011.method_12778(AGGRESSIVE, (Object)bl);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(STATE, (Object)0);
        this.field_6011.method_12784(TRADE_TICKS, (Object)0);
        this.field_6011.method_12784(AGGRESSIVE, (Object)false);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("healthUpdated")) {
            this.healthUpdated = nbt.method_10577("healthUpdated");
        }
        if (nbt.method_10545("state")) {
            this.setStateId(nbt.method_10550("state"));
        }
        if (nbt.method_10545("tradeCounter")) {
            this.maxTradeCount = nbt.method_10550("tradeCounter");
        }
        if (nbt.method_10545("turnChance")) {
            this.turnChance = nbt.method_10583("turnChance");
        }
        if (nbt.method_10545("aggressive")) {
            this.setAggressive(nbt.method_10577("aggressive"));
        }
        this.method_46400(nbt);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("healthUpdated", this.healthUpdated);
        nbt.method_10569("state", this.getStateId());
        nbt.method_10569("tradeCounter", this.maxTradeCount);
        nbt.method_10548("turnChance", this.turnChance);
        nbt.method_10556("aggressive", this.isAggressive());
        this.method_46399(nbt);
    }

    protected class_1799 addItem(class_1799 stack) {
        return this.inventory.method_5491(stack);
    }

    protected void method_6099(class_1282 source, int lootingMultiplier, boolean allowDrops) {
        super.method_6099(source, lootingMultiplier, allowDrops);
        this.inventory.method_24514().forEach(arg_0 -> ((BigChungus)this).method_5775(arg_0));
    }

    public class_1277 method_35199() {
        return this.inventory;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (ConfigConstructor.can_chungus_barter && stack.method_31574(ItemRegistry.CHUNGUS_EMERALD) && this.method_35199().method_5442() && !this.isAggressive()) {
            this.addItem(stack);
            if (!player.method_7337()) {
                stack.method_7934(1);
            }
            return class_1269.field_5812;
        }
        if (stack.method_31574((class_1792)WeaponRegistry.CHUNGUS_STAFF) && !((IConfigDisable)stack.method_7909()).isDisabled(stack) && !this.isAggressive() && !this.method_6181()) {
            this.method_6173(true);
            this.method_6170(player);
            this.method_5980(null);
            this.method_37908().method_8421((class_1297)this, (byte)7);
            this.field_6189.method_6340();
            return class_1269.field_5812;
        }
        if (this.method_6181() && this.method_6171((class_1309)player) && this.getTradeTicks() == 0) {
            this.method_24346(!this.method_24345());
            if (this.method_24345()) {
                this.method_37908().method_8421((class_1297)this, (byte)6);
            } else {
                this.method_37908().method_8421((class_1297)this, (byte)60);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private class_1799 getBarterItem() {
        class_52 lootTable = this.method_37908().method_8503().method_3857().getLootTable(new class_2960("soulsweapons", "gameplay/chungus_bartering"));
        ObjectArrayList list = lootTable.method_51878(new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_1226, (Object)this).method_51875(class_173.field_22403));
        return list.isEmpty() ? class_1802.field_8831.method_7854() : (class_1799)list.get(0);
    }

    public boolean method_5936() {
        return this.inventory.method_5442() && ConfigConstructor.can_chungus_barter;
    }

    protected void method_5949(class_1542 item) {
        if (item.method_6983().method_31574(ItemRegistry.CHUNGUS_EMERALD)) {
            this.method_35199().method_5491(item.method_6983());
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15197, this.method_5634(), 1.0f, 1.0f);
            item.method_6983().method_7934(1);
        }
    }

    public boolean method_5722(class_1297 other) {
        if (other instanceof class_6025 && ((class_6025)other).method_35057() != null && this.method_35057() != null && ((class_6025)other).method_35057() == this.method_35057()) {
            return true;
        }
        return super.method_5722(other);
    }

    public class_1924 method_48926() {
        return super.method_37908();
    }

    public static boolean canSpawnInDark(class_1299<? extends class_1308> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8407() != class_1267.field_5801 && BigChungus.isSpawnDark(world, pos, random) && BigChungus.method_20636(type, (class_1936)world, (class_3730)spawnReason, (class_2338)pos, (class_5819)random);
    }

    public static boolean isSpawnDark(class_5425 world, class_2338 pos, class_5819 random) {
        if (world.method_8314(class_1944.field_9284, pos) > random.method_43048(32)) {
            return false;
        }
        class_2874 dimensionType = world.method_8597();
        int i = dimensionType.method_44223();
        if (i < 15 && world.method_8314(class_1944.field_9282, pos) > i) {
            return false;
        }
        int j = world.method_8410().method_8546() ? world.method_22346(pos, 10) : world.method_22339(pos);
        return j <= dimensionType.method_44222().method_35008(random);
    }

    public static enum ChungusStates {
        NORMAL,
        BOSNIAN,
        DREAM;

    }
}

