/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1528;
import net.minecraft.class_1588;
import net.minecraft.class_1639;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.ai.goal.AccursedLordGoal;
import net.soulsweaponry.entity.mobs.BossEntity;
import net.soulsweaponry.entity.mobs.ChaosMonarch;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class AccursedLordBoss
extends BossEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public int deathTicks;
    private int spawnTicks;
    private static final class_2940<Integer> ATTACKS = class_2945.method_12791(AccursedLordBoss.class, (class_2941)class_2943.field_13327);
    public ArrayList<class_2338> lavaPos = new ArrayList();

    public AccursedLordBoss(class_1299<? extends AccursedLordBoss> entityType, class_1937 world) {
        super(entityType, world, class_1259.class_1260.field_5784);
    }

    @Override
    public boolean method_5753() {
        return ConfigConstructor.decaying_king_is_fire_immune;
    }

    private PlayState attackAnimations(AnimationState<?> state) {
        switch (this.getAttackAnimation()) {
            case FIREBALLS: 
            case WITHERBALLS: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.model.shootFireMouth"));
                break;
            }
            case HAND_SLAM: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.model.groundSlamHand"));
                break;
            }
            case HEATWAVE: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.model.explosion"));
                break;
            }
            case PULL: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.model.pull"));
                break;
            }
            case SPIN: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.model.spin"));
                break;
            }
            case SWORDSLAM: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.model.swordSlam"));
                break;
            }
            case DEATH: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.model.death"));
                break;
            }
            case SPAWN: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.model.spawn"));
                break;
            }
            default: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.model.idle"));
            }
        }
        return PlayState.CONTINUE;
    }

    @Override
    public int getTicksUntilDeath() {
        return 150;
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public int getXp() {
        return ConfigConstructor.decaying_king_xp;
    }

    @Override
    public class_3414 getBossMusic() {
        return null;
    }

    @Override
    public boolean hasBossMusic() {
        return false;
    }

    @Override
    public void method_6108() {
        ++this.deathTicks;
        if (this.deathTicks >= this.getTicksUntilDeath() && !this.method_37908().field_9236) {
            this.method_37908().method_8421((class_1297)this, (byte)60);
            CustomDeathHandler.deathExplosionEvent(this.method_37908(), this.method_19538(), SoundRegistry.DAWNBREAKER_EVENT, new class_2394[]{class_2398.field_11237, class_2398.field_11240});
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new AccursedLordGoal(this));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, ChaosMonarch.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1639.class, true));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1528.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        super.method_5959();
    }

    public static class_5132.class_5133 createDemonAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 60.0).method_26868(class_5134.field_23716, ConfigConstructor.decaying_king_health).method_26868(class_5134.field_23719, 0.15).method_26868(class_5134.field_23721, 20.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23724, 5.0).method_26868(class_5134.field_23722, 2.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ATTACKS, (Object)9);
    }

    public void setAttackAnimation(AccursedLordAnimations attack) {
        for (int i = 0; i < AccursedLordAnimations.values().length; ++i) {
            if (!AccursedLordAnimations.values()[i].equals((Object)attack)) continue;
            this.field_6011.method_12778(ATTACKS, (Object)i);
        }
    }

    public void setAttackAnimation(int random) {
        this.field_6011.method_12778(ATTACKS, (Object)random);
    }

    public void method_6007() {
        super.method_6007();
        if (this.getAttackAnimation().equals((Object)AccursedLordAnimations.SPAWN)) {
            ++this.spawnTicks;
            for (int i = 0; i < 50; ++i) {
                class_5819 random = this.method_6051();
                class_2338 pos = this.method_24515();
                double d = random.method_43059() * 0.05;
                double e = random.method_43059() * 0.05;
                double newX = random.method_43058() - 0.5 + random.method_43059() * 0.15 + d;
                double newZ = random.method_43058() - 0.5 + random.method_43059() * 0.15 + e;
                double newY = random.method_43058() - 0.5 + random.method_43058() * 0.5;
                this.method_37908().method_8406((class_2394)class_2398.field_11240, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), newX / 2.0, newY / 6.0, newZ / 2.0);
                this.method_37908().method_8406((class_2394)class_2398.field_11237, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), newX / 2.0, newY / 6.0, newZ / 2.0);
            }
            if (this.spawnTicks % 10 == 0 && this.spawnTicks < 70) {
                this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14742, class_3419.field_15251, 1.0f, 1.0f);
            }
            if (this.spawnTicks == 111) {
                this.method_37908().method_8396(null, this.method_24515(), SoundRegistry.DAWNBREAKER_EVENT, class_3419.field_15251, 1.0f, 1.0f);
                class_238 chunkBox = new class_238(this.method_24515()).method_1014(5.0);
                List nearbyEntities = this.method_37908().method_8335((class_1297)this, chunkBox);
                for (class_1297 nearbyEntity : nearbyEntities) {
                    if (!(nearbyEntity instanceof class_1309)) continue;
                    class_1309 closestTarget = (class_1309)nearbyEntity;
                    double x = closestTarget.method_23317() - this.method_23317();
                    double z = closestTarget.method_23321() - this.method_23321();
                    closestTarget.method_6005(10.0, -x, -z);
                    closestTarget.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), 50.0f * ConfigConstructor.decaying_king_damage_modifier);
                }
                if (!this.method_37908().field_9236) {
                    ParticleHandler.particleSphere(this.method_37908(), 1000, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), (class_2394)class_2398.field_11240, 1.0f);
                    ParticleHandler.particleOutburstMap(this.method_37908(), 200, this.method_23317(), this.method_23318() + (double)0.1f, this.method_23321(), ParticleEvents.DAWNBREAKER_MAP, 1.0f);
                }
            }
            if (this.spawnTicks >= 125) {
                this.setAttackAnimation(AccursedLordAnimations.IDLE);
            }
        }
    }

    public void removePlacedLava() {
        for (class_2338 pos : this.lavaPos) {
            if (!this.method_37908().method_8320(pos).method_27852(class_2246.field_10164)) continue;
            this.method_37908().method_8501(pos, class_2246.field_10124.method_9564());
        }
        this.lavaPos.clear();
    }

    public AccursedLordAnimations getAttackAnimation() {
        return AccursedLordAnimations.values()[(Integer)this.field_6011.method_12789(ATTACKS)];
    }

    @Override
    public void setDeath() {
        this.setAttackAnimation(AccursedLordAnimations.DEATH);
        this.removePlacedLava();
    }

    @Override
    public boolean method_5999() {
        return ConfigConstructor.decaying_king_is_undead;
    }

    @Override
    public String getGroupId() {
        return ConfigConstructor.decaying_king_group_type;
    }

    @Override
    public String[] getBlacklistedStatusEffects() {
        return ConfigConstructor.decaying_king_status_effect_blacklist;
    }

    @Override
    public boolean method_42149() {
        return ConfigConstructor.decaying_king_disables_shields;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::attackAnimations)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected class_3414 method_5994() {
        return SoundRegistry.DEMON_BOSS_IDLE_EVENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return SoundRegistry.DEMON_BOSS_HURT_EVENT;
    }

    protected class_3414 method_6002() {
        return SoundRegistry.DEMON_BOSS_DEATH_EVENT;
    }

    public static enum AccursedLordAnimations {
        SWORDSLAM,
        FIREBALLS,
        PULL,
        HEATWAVE,
        SPIN,
        WITHERBALLS,
        HAND_SLAM,
        SPAWN,
        DEATH,
        IDLE;

    }
}

