/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.blocks;

import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4970;
import net.minecraft.class_5556;
import net.minecraft.class_5819;
import net.soulsweaponry.blocks.entity.CrimsonObsidianBlockEntity;
import net.soulsweaponry.fluid.PurifiedBloodCauldronBlock;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.FluidRegistry;
import net.soulsweaponry.util.ModTags;
import org.jetbrains.annotations.Nullable;

public class CrimsonObsidian
extends class_2237 {
    public static final class_265 DRIP_COLLISION_SHAPE = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public CrimsonObsidian(class_4970.class_2251 settings) {
        super(settings.method_9640());
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        world.method_39279(pos, (class_2248)this, 20 + random.method_43048(40));
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (random.method_43048(5) == 0) {
            this.addParticles(world, random, pos, state, 1);
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CrimsonObsidianBlockEntity(pos, state);
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        CrimsonObsidianBlockEntity blockEntity;
        if (!world.field_9236 && (blockEntity = (CrimsonObsidianBlockEntity)world.method_8321(pos)) != null && !entity.method_5864().method_20210(ModTags.Entities.SKELETONS) && entity.method_5643(world.method_48963().method_48820(), 1.0f)) {
            blockEntity.increaseBloodCount();
        }
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!world.field_9236) {
            class_2338 blockPos = CrimsonObsidian.getCauldronPos((class_1937)world, pos, (class_2275)FluidRegistry.PURIFIED_BLOOD_CAULDRON);
            if (blockPos != null) {
                CrimsonObsidianBlockEntity blockEntity = (CrimsonObsidianBlockEntity)world.method_8321(pos);
                class_2680 blockState = world.method_8320(blockPos);
                if (blockEntity != null && blockEntity.getBloodCount() >= 5) {
                    PurifiedBloodCauldronBlock cauldron;
                    if (blockState.method_27852(class_2246.field_10593)) {
                        world.method_8501(blockPos, (class_2680)FluidRegistry.PURIFIED_BLOOD_CAULDRON.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(1)));
                        this.addParticles((class_1937)world, random, pos, state, 8);
                    } else if (blockState.method_27852((class_2248)FluidRegistry.PURIFIED_BLOOD_CAULDRON) && !(cauldron = (PurifiedBloodCauldronBlock)blockState.method_26204()).method_32766(blockState) && blockEntity.dripBlood()) {
                        cauldron.incrementFluidLevel((class_1937)world, blockPos, blockState);
                        this.addParticles((class_1937)world, random, pos, state, 8);
                    }
                }
            }
            world.method_39279(pos, (class_2248)this, 20 + random.method_43048(40));
        }
    }

    private void addParticles(class_1937 world, class_5819 random, class_2338 pos, class_2680 state, int amount) {
        class_2350 direction = class_2350.field_11033;
        class_2338 blockPos = pos.method_10093(direction);
        class_2680 blockState = world.method_8320(blockPos);
        if (!state.method_26225() || !blockState.method_26206((class_1922)world, blockPos, direction.method_10153())) {
            for (int i = 0; i < amount; ++i) {
                double f;
                double d = direction.method_10148() == 0 ? random.method_43058() : 0.5 + (double)direction.method_10148() * 0.6;
                double e = direction.method_10164() == 0 ? random.method_43058() : 0.5 + (double)direction.method_10164() * 0.6;
                double d2 = f = direction.method_10165() == 0 ? random.method_43058() : 0.5 + (double)direction.method_10165() * 0.6;
                if (world.field_9236) {
                    world.method_8406((class_2394)class_2398.field_18304, (double)pos.method_10263() + d, (double)pos.method_10264() + e, (double)pos.method_10260() + f, 0.0, 0.0, 0.0);
                    continue;
                }
                ParticleHandler.singleParticle(world, (class_2394)class_2398.field_18304, (double)pos.method_10263() + d, (double)pos.method_10264() + e, (double)pos.method_10260() + f, 0.0, 0.0, 0.0);
            }
        }
    }

    @Nullable
    public static class_2338 getCauldronPos(class_1937 world, class_2338 pos, class_2275 acceptableCauldron) {
        Predicate<class_2680> predicate = state -> {
            class_2275 cauldron;
            class_2248 patt5482$temp = state.method_26204();
            return patt5482$temp instanceof class_2275 && ((cauldron = (class_2275)patt5482$temp).equals(acceptableCauldron) || cauldron.equals(class_2246.field_10593));
        };
        BiPredicate<class_2338, class_2680> biPredicate = (posx, state) -> CrimsonObsidian.canDripThrough((class_1922)world, posx, state);
        return CrimsonObsidian.searchInDirection((class_1936)world, pos, class_2350.field_11033.method_10171(), biPredicate, predicate, 11).orElse(null);
    }

    public static boolean canDripThrough(class_1922 world, class_2338 pos, class_2680 state) {
        if (state.method_26215()) {
            return true;
        }
        if (state.method_26216(world, pos)) {
            return false;
        }
        if (!state.method_26227().method_15769()) {
            return false;
        }
        class_265 voxelShape = state.method_26220(world, pos);
        return !class_259.method_1074((class_265)DRIP_COLLISION_SHAPE, (class_265)voxelShape, (class_247)class_247.field_16896);
    }

    public static Optional<class_2338> searchInDirection(class_1936 world, class_2338 pos, class_2350.class_2352 direction, BiPredicate<class_2338, class_2680> continuePredicate, Predicate<class_2680> stopPredicate, int range) {
        class_2350 direction2 = class_2350.method_10156((class_2350.class_2352)direction, (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_2338.class_2339 mutable = pos.method_25503();
        for (int i = 1; i < range; ++i) {
            mutable.method_10098(direction2);
            class_2680 blockState = world.method_8320((class_2338)mutable);
            if (stopPredicate.test(blockState)) {
                return Optional.of(mutable.method_10062());
            }
            if (!world.method_31601(mutable.method_10264()) && continuePredicate.test((class_2338)mutable, blockState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }
}

