/*
 * Decompiled with CFR 0.152.
 */
package net.aleganza.plentyofarmors.item.custom;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.aleganza.plentyofarmors.effect.ModEffects;
import net.aleganza.plentyofarmors.item.ModArmorMaterials;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

public class ModArmorHardenedIce
extends class_1738 {
    public static final int effectDuration = 400;
    public static final int amplifier = 1;
    private static final Map<class_1741, class_1293> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)ModArmorMaterials.HARDENED_ICE_SHARD, (Object)new class_1293(class_1294.field_5926, 400, 1)).build();

    public ModArmorHardenedIce(class_1741 material, class_1738.class_8051 slot, class_1792.class_1793 settings) {
        super(material, slot, settings);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_1657 player;
        if (!world.method_8608() && entity instanceof class_1657 && this.hasFullSuitOfArmorOn(player = (class_1657)entity)) {
            this.evaluateArmorEffects(player);
        }
        super.method_7888(stack, world, entity, slot, selected);
    }

    private void evaluateArmorEffects(class_1657 player) {
        for (Map.Entry<class_1741, class_1293> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            ModArmorMaterials mapArmorMaterial = ModArmorMaterials.HARDENED_ICE_SHARD;
            class_1293 mapStatusEffect = new class_1293(ModEffects.FROST_WALKER, 400, 1, false, false, false);
            if (!this.hasCorrectArmorOn(mapArmorMaterial, player)) continue;
            this.addStatusEffectForMaterial(player, mapArmorMaterial, mapStatusEffect);
        }
    }

    private void addStatusEffectForMaterial(class_1657 player, class_1741 mapArmorMaterial, class_1293 mapStatusEffect) {
        boolean hasPlayerEffect = player.method_6059(mapStatusEffect.method_5579());
        if (this.hasCorrectArmorOn(mapArmorMaterial, player) && !hasPlayerEffect) {
            player.method_6092(new class_1293(ModEffects.FROST_WALKER, 400, 1, false, false, false));
        }
        if (player.method_6088().containsKey(ModEffects.FROST_WALKER) && ((class_1293)player.method_6088().get(mapStatusEffect.method_5579())).method_5584() < 221) {
            player.method_6092(new class_1293(ModEffects.FROST_WALKER, 400, 1, false, false, false));
        }
    }

    private boolean hasFullSuitOfArmorOn(class_1657 player) {
        class_1799 boots = player.method_31548().method_7372(0);
        class_1799 leggings = player.method_31548().method_7372(1);
        class_1799 breastplate = player.method_31548().method_7372(2);
        class_1799 helmet = player.method_31548().method_7372(3);
        return !helmet.method_7960() && !breastplate.method_7960() && !leggings.method_7960() && !boots.method_7960();
    }

    private boolean doesArmorHaveMaterial(class_1741 material, class_1657 player) {
        for (int i = 0; i < 4; ++i) {
            try {
                ((class_1738)player.method_31548().method_7372(i).method_7909()).method_7686();
                continue;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private boolean hasCorrectArmorOn(class_1741 material, class_1657 player) {
        if (!this.doesArmorHaveMaterial(material, player)) {
            return false;
        }
        class_1738 boots = (class_1738)player.method_31548().method_7372(0).method_7909();
        class_1738 leggings = (class_1738)player.method_31548().method_7372(1).method_7909();
        class_1738 breastplate = (class_1738)player.method_31548().method_7372(2).method_7909();
        class_1738 helmet = (class_1738)player.method_31548().method_7372(3).method_7909();
        return helmet.method_7686() == material && breastplate.method_7686() == material && leggings.method_7686() == material && boots.method_7686() == material;
    }
}

