/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.guardiansgalore.entity;

import com.yahoo.chirpycricket.guardiansgalore.LivingEntitySoundInterface;
import com.yahoo.chirpycricket.guardiansgalore.blocks.AnchorStoneEntity;
import com.yahoo.chirpycricket.guardiansgalore.config.Settings;
import com.yahoo.chirpycricket.guardiansgalore.registry.Entities;
import java.util.List;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1359;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1386;
import net.minecraft.class_1399;
import net.minecraft.class_1403;
import net.minecraft.class_1406;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1548;
import net.minecraft.class_1571;
import net.minecraft.class_1588;
import net.minecraft.class_1590;
import net.minecraft.class_1593;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1924;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4836;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_5532;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GuardianEntity
extends class_1321
implements GeoEntity {
    private static final class_2940<Boolean> ATTACKING;
    private static final class_2940<Boolean> LOOKING;
    private static final class_2940<Boolean> SITTING;
    private static final class_2940<Boolean> SLEEPING;
    private static final class_2940<Boolean> HAS_SHRINE;
    private static final class_2940<String> VARIANT;
    private static final class_2940<Integer> SHRINE_POS_X;
    private static final class_2940<Integer> SHRINE_POS_Y;
    private static final class_2940<Integer> SHRINE_POS_Z;
    protected class_1792 tamingItem = Entities.BLAZE_BELL;
    protected boolean canEatMeat = true;
    protected boolean canEatVeg = true;
    public static final double maxDistFromHome = 20.0;
    public static final double maxAuraRange = 48.0;
    public static final double tamedAuraRange = 2.0;
    private int auraTimer = 0;
    private double auraRange = 1.0;
    private final int maxDespawnTicks = 1000;
    private int despawnTimer = 0;
    private int sleepTimer = 0;
    private int sleepTime = 0;
    int sitTimer = 0;
    int sitTime = 0;
    int minSitTime = 400;
    int maxSitTime = 2000;
    int minSleepTime = 1000;
    int maxSleepTime = 5000;
    protected Settings.GuardianKey guardianKey;
    protected Settings.GuardianSettings settings;
    float soundVolume = 100.0f;
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private AnimationPhase lastPose;
    private AnimationPhase lastState;
    private AnimationPhase currentState;
    private double lastTick = 0.0;
    private double currentTick = 0.0;
    private double tickDelta = 0.0;
    private double animationTimer = 0.0;
    private double animationLength = 1.0;
    private double animationSittingTimer = 0.0;
    private double animationSittingTime = 0.0;
    private final int minAnimationSittingTime = 7;
    private final int maxAnimationSittingTime = 60;
    protected static int textureCounter;
    int deadTimer = 0;
    protected AnimationController<GuardianEntity> animationController = new AnimationController((GeoAnimatable)this, "moveController", 0, this::moveAnimationPredicate);
    protected AnimationController<GuardianEntity> blinkAnimationController = new AnimationController((GeoAnimatable)this, "blinkController", 0, this::blinkAnimationPredicate);

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        this.animationController = new AnimationController((GeoAnimatable)this, "moveController", 0, this::moveAnimationPredicate);
        this.blinkAnimationController = new AnimationController((GeoAnimatable)this, "blinkController", 0, this::blinkAnimationPredicate);
        this.animationController.transitionLength(10);
        this.blinkAnimationController.transitionLength(10);
        controllers.add(new AnimationController[]{this.animationController, this.blinkAnimationController});
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }

    public GuardianEntity(class_1299<? extends class_1321> type, class_1937 worldIn, Settings.GuardianKey guardianKey) {
        super(type, worldIn);
        this.init(guardianKey);
    }

    public void init(Settings.GuardianKey guardianKey) {
        this.guardianKey = guardianKey;
        this.settings = Settings.settings.get((Object)guardianKey);
        this.soundVolume = (float)(this.settings.volume / 100.0);
        if (this.settings.diet.equals("herbivore")) {
            this.canEatMeat = false;
            this.canEatVeg = true;
        }
        if (this.settings.diet.equals("carnivore")) {
            this.canEatMeat = true;
            this.canEatVeg = false;
        }
        if (this.settings.diet.equals("omnivore")) {
            this.canEatMeat = true;
            this.canEatVeg = true;
        }
    }

    public String getDefaultTexture() {
        return "textures/model/entity/steve.png";
    }

    protected void initSuperGoals() {
        super.method_5959();
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new GuardianSitGoal(this));
        this.field_6201.method_6277(4, (class_1352)new class_1359((class_1308)this, 0.4f));
        this.field_6201.method_6277(5, (class_1352)new class_1366((class_1314)this, 2.0, true));
        this.field_6201.method_6277(6, (class_1352)new class_1350((class_1321)this, 1.0, 2.0f, 10.0f, true));
        this.field_6201.method_6277(7, (class_1352)new GuardianWanderAroundGoal(this, 1.0, 500));
        this.field_6201.method_6277(14, (class_1352)new GuardianLookAtEntityGoal(this, class_1657.class, 6.0f));
        this.field_6201.method_6277(15, (class_1352)new GuardianLookAtEntityGoal(this, class_1309.class, 6.0f));
        this.field_6201.method_6277(16, (class_1352)new GuardianLookAroundGoal(this));
        this.field_6185.method_6277(18, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(20, (class_1352)new class_1406((class_1321)this));
        this.field_6185.method_6277(3, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(8, (class_1352)new class_5398((class_1308)this, true));
    }

    protected void method_5958() {
        super.method_5958();
        if (!this.method_37908().field_9236) {
            ++this.auraTimer;
            this.auraTimer %= 10000;
            if (this.method_6181() && this.auraTimer % 100 == 0 && !this.hasHomeShrine()) {
                this.setOwnerRespawnPoint();
            }
            if (!this.method_6181() && !this.hasHomeShrine()) {
                ++this.despawnTimer;
                if (this.despawnTimer >= 1000) {
                    this.method_5783(class_3417.field_15026, 1.0f, 1.0f);
                    this.method_5650(class_1297.class_5529.field_26999);
                    return;
                }
            }
            this.setTrackedAttacking(this.method_6510());
            class_2382 shrinePos = this.getShrinePos();
            double dist = this.method_19538().method_1022(new class_243((double)shrinePos.method_10263(), (double)shrinePos.method_10264(), (double)shrinePos.method_10260()));
            if (!this.method_6181() && this.hasHomeShrine() && dist > 20.0) {
                ++this.despawnTimer;
                if (this.despawnTimer >= 1000) {
                    this.despawnTimer = 0;
                    this.teleportToPos(shrinePos.method_10263(), (float)shrinePos.method_10264() + 1.5f, shrinePos.method_10260());
                    return;
                }
            }
            if (this.method_6181() || !this.method_6181() && this.hasHomeShrine() && dist <= 32.0) {
                if (this.auraTimer % 10 == 0 && this.settings.particles) {
                    this.applyParticlesToEntity((class_1309)this, 1, class_2398.field_11207, 0.005);
                }
            } else if (this.despawnTimer < 250) {
                if (this.auraTimer % 10 == 0) {
                    this.applyParticlesToEntity((class_1309)this, 1, class_2398.field_11207, 0.005);
                    this.applyParticlesToEntity((class_1309)this, 3, class_2398.field_11251, 0.005);
                }
            } else if (this.despawnTimer < 500) {
                if (this.auraTimer % 10 == 0) {
                    this.applyParticlesToEntity((class_1309)this, 5, class_2398.field_11251, 0.005);
                }
            } else if (this.despawnTimer < 750) {
                if (this.auraTimer % 5 == 0) {
                    this.applyParticlesToEntity((class_1309)this, 5, class_2398.field_11251, 0.005);
                }
            } else {
                this.applyParticlesToEntity((class_1309)this, 5, class_2398.field_11251, 0.005);
            }
            if (this.auraTimer % 20 == 0) {
                if (this.getShrinePos() != null) {
                    class_2586 lookupBlockEntity = this.method_37908().method_8321(new class_2338(this.getShrinePos()));
                    AnchorStoneEntity blockEntity = null;
                    if (lookupBlockEntity instanceof AnchorStoneEntity) {
                        blockEntity = (AnchorStoneEntity)lookupBlockEntity;
                    }
                    if (blockEntity != null) {
                        double currentBells = ((AnchorStoneEntity)this.method_37908().method_8321(new class_2338(this.getShrinePos()))).getBells();
                        double range = currentBells / 11.0;
                        this.setAuraRange(range);
                    } else {
                        this.setAuraRange(2.0);
                    }
                }
                if (this.method_6181()) {
                    this.setAuraRange(2.0);
                }
                List entititesWithinRange = this.method_37908().method_18467(class_1309.class, this.method_5829().method_1014(this.auraRange));
                for (class_1309 livingEntity : entititesWithinRange) {
                    if (livingEntity instanceof class_1588) {
                        if (!(!(livingEntity instanceof class_4836) & !(livingEntity instanceof class_1590))) continue;
                        this.applyAuraDamage(livingEntity);
                        continue;
                    }
                    if (!(livingEntity instanceof class_1571) && !(livingEntity instanceof class_1593)) continue;
                    this.applyAuraDamage(livingEntity);
                }
            }
            if (this.method_24828() && !this.method_6510()) {
                if (this.auraTimer % 200 == 0 && this.field_5974.method_43058() < 0.075 && !this.method_24345() && !this.method_6181()) {
                    this.method_24346(true);
                }
                if (this.auraTimer % 400 == 0 && this.field_5974.method_43058() < 0.1 && this.method_24345() && !this.getIsAsleep()) {
                    this.method_24346(true);
                    this.setSleeping(true);
                }
                if (this.getIsAsleep()) {
                    ++this.sleepTimer;
                    if (this.sleepTimer >= this.sleepTime) {
                        this.setSleeping(false);
                    }
                } else if (this.method_24345() && !this.method_6181()) {
                    ++this.sitTimer;
                    if (this.sitTimer >= this.sitTime) {
                        this.method_24346(false);
                    }
                }
            }
        }
    }

    public void applyAuraDamage(class_1309 livingEntity) {
        if (livingEntity.method_6032() >= 0.5f * livingEntity.method_6063()) {
            livingEntity.method_5643(this.method_37908().method_48963().method_48831(), (float)livingEntity.method_6051().method_43058() * 0.15f * livingEntity.method_6063());
            if (this.auraTimer % 10 == 0) {
                this.applyParticlesToEntity(livingEntity, 1, class_2398.field_11207, 0.005);
            }
        } else {
            livingEntity.method_5783(((LivingEntitySoundInterface)livingEntity).gs_getDeathSound(), 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
            this.applyParticlesToEntity(livingEntity, 20, class_2398.field_11203, 0.005);
            livingEntity.method_5650(class_1297.class_5529.field_26999);
        }
    }

    public float method_6107() {
        return this.soundVolume;
    }

    public void applyParticlesToEntity(class_1309 livingEntity, int amount, class_2400 particleType, double speed) {
        if (!this.method_37908().field_9236) {
            for (int i = 0; i < amount; ++i) {
                double d = livingEntity.method_6051().method_43059() * 0.02;
                double e = livingEntity.method_6051().method_43059() * 0.02;
                double f = livingEntity.method_6051().method_43059() * 0.02;
                ((class_3218)this.method_37908()).method_14199((class_2394)particleType, livingEntity.method_23322(1.0), livingEntity.method_23319() + 0.5, livingEntity.method_23325(1.0), 1, d, e, f, speed);
            }
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1792 item = itemStack.method_7909();
        if (this.method_37908().field_9236) {
            boolean bl = this.method_6171((class_1309)player) || this.method_6181() || item == this.tamingItem && !this.method_6181();
            return bl ? class_1269.field_21466 : class_1269.field_5811;
        }
        this.setSleeping(false);
        if (this.method_6181()) {
            if (this.canEatFood(item)) {
                if (this.method_6032() < this.method_6063()) {
                    if (!player.method_7337()) {
                        itemStack.method_7934(1);
                    }
                    System.out.println("can eat: " + this.canEatFood(item));
                    this.method_6025(item.method_19264().method_19230());
                    this.method_37908().method_8421((class_1297)this, (byte)7);
                    this.method_5783(class_3417.field_20614, 1.0f, 1.0f);
                    return class_1269.field_5812;
                }
            } else {
                if (item == class_1802.field_8868 && (this.method_6139().equals(player.method_5667()) || player.method_7337())) {
                    this.method_6174(null);
                    this.method_6173(false);
                    this.method_5980(null);
                    this.method_24346(false);
                    this.method_5706((class_1935)Entities.BLAZE_BELL);
                    this.method_5783((class_3414)class_3417.field_14725.comp_349(), 1.0f, 0.5f);
                    this.method_5783(class_3417.field_24065, 1.0f, 1.0f);
                    return class_1269.field_5812;
                }
                if (player.method_5715() && this.canPet()) {
                    this.method_5783(this.method_5994(), this.soundVolume, 1.5f);
                    this.method_37908().method_8421((class_1297)this, (byte)7);
                } else {
                    class_1269 actionResult = super.method_5992(player, hand);
                    if ((!actionResult.method_23665() || this.method_6109()) && this.method_6171((class_1309)player)) {
                        this.method_24346(!this.method_24345());
                        this.field_6282 = false;
                        this.field_6189.method_6340();
                        this.method_5980(null);
                        return class_1269.field_5812;
                    }
                }
            }
        } else if (item == this.tamingItem) {
            if (!player.method_7337()) {
                itemStack.method_7934(1);
            }
            this.method_6173(true);
            this.method_6170(player);
            this.field_6189.method_6340();
            this.method_5980(null);
            this.method_24346(true);
            this.method_37908().method_8421((class_1297)this, (byte)7);
            this.method_5783((class_3414)class_3417.field_14725.comp_349(), 1.0f, 1.0f);
            this.despawnTimer = 0;
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public boolean canPet() {
        return true;
    }

    public boolean method_6178(class_1309 target, class_1309 owner) {
        if (!(target instanceof class_1548) && !(target instanceof class_1571)) {
            if (target instanceof class_1493) {
                class_1493 wolfEntity = (class_1493)target;
                return !wolfEntity.method_6181() || wolfEntity.method_35057() != owner;
            }
            if (target instanceof GuardianEntity) {
                return false;
            }
            if (target instanceof class_1657 && owner instanceof class_1657 && !((class_1657)owner).method_7256((class_1657)target)) {
                return false;
            }
            if (target instanceof class_1496 && ((class_1496)target).method_6727()) {
                return false;
            }
            return !(target instanceof class_1321) || !((class_1321)target).method_6181();
        }
        return false;
    }

    public void method_6078(class_1282 source) {
        if (!this.method_37908().field_9236 && this.method_6181() && Settings.globalSettings.enableRespawn) {
            class_3222 serverPlayerEntity;
            this.method_18800(0.0, 0.1, 0.0);
            class_2382 tpTarget = this.getShrinePos();
            if (tpTarget != null && (tpTarget.method_10263() != 0 || tpTarget.method_10264() != 0 || tpTarget.method_10260() != 0)) {
                this.method_6033(this.method_6063());
                this.teleportToPos(tpTarget.method_10263(), (float)tpTarget.method_10264() + 1.5f, tpTarget.method_10260());
                this.method_24346(true);
                this.method_5980(null);
                return;
            }
            if (this.method_6139() != null && (tpTarget = (serverPlayerEntity = this.method_37908().method_8503().method_3760().method_14602(this.method_6139())).method_26280()) != null) {
                this.method_6033(this.method_6063());
                this.teleportToPos(tpTarget.method_10263(), (float)tpTarget.method_10264() + 1.5f, tpTarget.method_10260());
                this.method_24346(true);
                this.method_5980(null);
                return;
            }
        }
        super.method_6078(source);
    }

    private void teleportToPos(float x, float y, float z) {
        this.method_5783(class_3417.field_15026, 1.0f, 1.0f);
        this.method_5783(class_3417.field_14890, 1.0f, 1.0f);
        this.applyParticlesToEntity((class_1309)this, 20, class_2398.field_11203, 0.005);
        this.method_20620(x, y, z);
        this.applyParticlesToEntity((class_1309)this, 20, class_2398.field_11203, 0.005);
        this.method_5783(class_3417.field_15026, 1.0f, 1.0f);
        this.method_5783(class_3417.field_14890, 1.0f, 1.0f);
    }

    public class_243 getLeashAttachPoint() {
        class_243 attachPoint = new class_243(0.0, (double)this.method_5751() * 0.7, (double)this.method_17681() * 0.2);
        if (this.getSitting()) {
            attachPoint = new class_243(0.0, (double)this.method_5751() * 0.35, (double)this.method_17681() * 0.2);
        }
        return attachPoint;
    }

    protected boolean canEatFood(class_1792 item) {
        if (item.method_19263()) {
            if (this.canEatMeat && item.method_19264().method_19232()) {
                return true;
            }
            if (this.canEatVeg && !item.method_19264().method_19232()) {
                return true;
            }
        }
        return false;
    }

    public void setAuraRange(double range) {
        this.auraRange = this.method_6181() ? 2.0 : (double)((int)(range * 48.0));
    }

    public void method_5650(class_1297.class_5529 reason) {
        this.applyParticlesToEntity((class_1309)this, 20, class_2398.field_11203, 0.005);
        super.method_5650(reason);
    }

    public boolean method_5643(class_1282 source, float amount) {
        this.setSleeping(false);
        if (!this.method_6181()) {
            this.method_24346(false);
        }
        return super.method_5643(source, amount);
    }

    protected <P extends GeoEntity> PlayState moveAnimationPredicate(AnimationState<P> event) {
        this.animationController.transitionLength(0);
        if (this.animationController.getCurrentAnimation() != null) {
            this.animationLength = this.animationController.getCurrentAnimation().animation().length();
        }
        this.lastTick = this.currentTick;
        this.currentTick = event.animationTick;
        this.tickDelta = this.currentTick - this.lastTick;
        this.animationTimer += this.tickDelta;
        this.lastState = this.currentState;
        this.currentState = this.getIsAsleep() ? AnimationPhase.SLEEP : (event.isMoving() ? AnimationPhase.WALK : (this.getSitting() ? AnimationPhase.SIT : AnimationPhase.STAND));
        if (this.method_37908().field_9236 && this.animationTimer >= this.animationLength || this.lastState != this.currentState) {
            this.animationTimer = 0.0;
            if (this.getIsAsleep()) {
                if (this.lastPose == AnimationPhase.SIT) {
                    this.animationController.setAnimation(this.getLayDownAnimation());
                    this.lastPose = AnimationPhase.LAYDOWN;
                }
                if (this.lastPose == AnimationPhase.LAYDOWN) {
                    this.animationController.setAnimation(this.getGoToSleepAnimation());
                    this.lastPose = AnimationPhase.SLEEP;
                } else {
                    this.animationController.setAnimation(this.getSleepingAnimation());
                    this.lastPose = AnimationPhase.SLEEP;
                }
                this.animationSittingTimer = 0.0;
                return PlayState.CONTINUE;
            }
            if (this.getSitting()) {
                if (this.animationSittingTimer > 2.0 * this.animationSittingTime) {
                    this.animationSittingTimer = 0.0;
                }
                if (this.animationSittingTimer <= 0.0) {
                    this.animationSittingTime = this.field_5974.method_43048(53) + 7;
                }
                this.animationSittingTimer += 1.0;
                if (this.animationSittingTimer < this.animationSittingTime) {
                    if (this.lastPose == AnimationPhase.SLEEP) {
                        this.animationController.setAnimation(this.getWakeUpAnimation());
                        this.lastPose = AnimationPhase.LAYDOWN;
                    } else if (this.lastPose == AnimationPhase.LAYDOWN) {
                        this.animationController.setAnimation(this.getGetUpAnimation());
                        this.lastPose = AnimationPhase.SIT;
                    } else {
                        this.animationController.setAnimation(this.getSittingAnimation());
                        this.lastPose = AnimationPhase.SIT;
                    }
                } else {
                    if (this.lastPose == AnimationPhase.SIT) {
                        this.animationController.setAnimation(this.getLayDownAnimation());
                    } else if (this.lastPose == AnimationPhase.SLEEP) {
                        this.animationController.setAnimation(this.getWakeUpAnimation());
                    } else {
                        this.animationController.setAnimation(this.getLayingDownAnimation());
                    }
                    this.lastPose = AnimationPhase.LAYDOWN;
                }
                return PlayState.CONTINUE;
            }
            if (event.isMoving()) {
                if (this.lastPose == AnimationPhase.LAYDOWN) {
                    this.animationController.setAnimation(this.getGetUpAnimation());
                    this.lastPose = AnimationPhase.SIT;
                } else {
                    this.animationController.setAnimation(this.getWalkAnimation());
                }
                this.lastPose = AnimationPhase.WALK;
                this.animationSittingTimer = 0.0;
                return PlayState.CONTINUE;
            }
            if (this.lastPose == AnimationPhase.LAYDOWN) {
                this.animationController.setAnimation(this.getGetUpAnimation());
                this.lastPose = AnimationPhase.SIT;
            } else {
                this.animationController.setAnimation(this.getIdleAnimation());
            }
            this.lastPose = AnimationPhase.STAND;
            this.animationSittingTimer = 0.0;
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    protected <P extends GeoEntity> PlayState blinkAnimationPredicate(AnimationState<P> event) {
        this.blinkAnimationController.transitionLength(0);
        if (!this.getIsAsleep()) {
            this.blinkAnimationController.setAnimation(this.getBlinkAnimation());
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public static class_5132.class_5133 createGuardianAttributes(Settings.GuardianKey guardianKey) {
        return GuardianEntity.method_26828().method_26868(class_5134.field_23719, Settings.settings.get((Object)((Object)guardianKey)).speed).method_26868(class_5134.field_23716, Settings.settings.get((Object)((Object)guardianKey)).health).method_26868(class_5134.field_23721, Settings.settings.get((Object)((Object)guardianKey)).attack);
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14894, 1.0f, 1.0f);
    }

    protected class_3414 method_5994() {
        return class_3417.field_14615;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14940;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14732;
    }

    protected RawAnimation getWalkAnimation() {
        return RawAnimation.begin().thenLoop("animation.default.walk");
    }

    protected RawAnimation getIdleAnimation() {
        return RawAnimation.begin().thenLoop("animation.default.idle");
    }

    protected RawAnimation getSittingAnimation() {
        return RawAnimation.begin().thenLoop("animation.default.sit");
    }

    protected RawAnimation getLayingDownAnimation() {
        return RawAnimation.begin().thenLoop("animation.default.sit");
    }

    protected RawAnimation getSleepingAnimation() {
        return null;
    }

    protected RawAnimation getBlinkAnimation() {
        return null;
    }

    protected RawAnimation getGoToSleepAnimation() {
        return null;
    }

    protected RawAnimation getWakeUpAnimation() {
        return null;
    }

    protected RawAnimation getLayDownAnimation() {
        return null;
    }

    protected RawAnimation getGetUpAnimation() {
        return null;
    }

    protected String getRandomTexture() {
        return "";
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ATTACKING, (Object)false);
        this.field_6011.method_12784(LOOKING, (Object)false);
        this.field_6011.method_12784(SITTING, (Object)false);
        this.field_6011.method_12784(SLEEPING, (Object)false);
        this.field_6011.method_12784(VARIANT, (Object)"");
        this.field_6011.method_12784(HAS_SHRINE, (Object)false);
        this.field_6011.method_12784(SHRINE_POS_X, (Object)0);
        this.field_6011.method_12784(SHRINE_POS_Y, (Object)0);
        this.field_6011.method_12784(SHRINE_POS_Z, (Object)0);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityTag) {
        boolean isSitting;
        boolean hasShrine;
        String textureFile;
        int x = 0;
        int y = 0;
        int z = 0;
        if (entityData instanceof GuardianData) {
            GuardianData data = (GuardianData)((Object)entityData);
            textureFile = ((GuardianData)((Object)entityData)).textureFile;
            hasShrine = ((GuardianData)((Object)entityData)).hasShrine;
            isSitting = ((GuardianData)((Object)entityData)).isSitting;
            x = data.shrineX;
            y = data.shrineY;
            z = data.shrineZ;
        } else {
            textureFile = this.getRandomTexture();
            hasShrine = false;
            isSitting = false;
            entityData = new GuardianData(textureFile, hasShrine, isSitting, x, y, z);
        }
        this.setVariant(textureFile);
        this.setHasShrine(hasShrine);
        this.setShrinePos(x, y, z);
        this.method_24346(isSitting);
        this.despawnTimer = 0;
        return super.method_5943(world, difficulty, spawnReason, entityData, entityTag);
    }

    public boolean hasHomeShrine() {
        return this.getHasShrine();
    }

    private void setHasShrine(boolean hasShrine) {
        this.field_6011.method_12778(HAS_SHRINE, (Object)hasShrine);
    }

    private Boolean getHasShrine() {
        return (Boolean)this.field_6011.method_12789(HAS_SHRINE);
    }

    public void setHomeShrine(int x, int y, int z) {
        this.despawnTimer = 0;
        this.setHasShrine(true);
        this.setShrinePos(x, y, z);
    }

    public void removeHomeShrine() {
        this.despawnTimer = 0;
        this.setHasShrine(false);
        if (!this.method_6181()) {
            this.setShrinePos(0, 0, 0);
        } else {
            this.setOwnerRespawnPoint();
        }
    }

    public void setOwnerRespawnPoint() {
        class_2338 respawnLoc;
        class_3222 serverPlayerEntity = this.method_37908().method_8503().method_3760().method_14602(this.method_6139());
        if (!(serverPlayerEntity == null || (respawnLoc = serverPlayerEntity.method_26280()) == null || respawnLoc.method_10263() == 0 && respawnLoc.method_10264() == 0 && respawnLoc.method_10260() == 0 || respawnLoc.equals((Object)new class_2338(this.getShrinePos())))) {
            this.setShrinePos(respawnLoc.method_10263(), respawnLoc.method_10264(), respawnLoc.method_10260());
        }
    }

    protected void setShrinePos(int x, int y, int z) {
        this.field_6011.method_12778(SHRINE_POS_X, (Object)x);
        this.field_6011.method_12778(SHRINE_POS_Y, (Object)y);
        this.field_6011.method_12778(SHRINE_POS_Z, (Object)z);
    }

    protected class_2382 getShrinePos() {
        Integer posX = (Integer)this.field_6011.method_12789(SHRINE_POS_X);
        Integer posY = (Integer)this.field_6011.method_12789(SHRINE_POS_Y);
        Integer posZ = (Integer)this.field_6011.method_12789(SHRINE_POS_Z);
        return new class_2382(posX.intValue(), posY.intValue(), posZ.intValue());
    }

    public boolean getTrackedAttacking() {
        return (Boolean)this.field_6011.method_12789(ATTACKING);
    }

    public void setTrackedAttacking(boolean attacking) {
        this.field_6011.method_12778(ATTACKING, (Object)attacking);
    }

    public boolean getHappy() {
        return (Boolean)this.field_6011.method_12789(LOOKING);
    }

    public void setHappy(boolean looking) {
        this.field_6011.method_12778(LOOKING, (Object)looking);
    }

    public boolean getSitting() {
        return (Boolean)this.field_6011.method_12789(SITTING);
    }

    public void method_24346(boolean setSitting) {
        super.method_24346(setSitting);
        this.sitTimer = 0;
        this.sitTime = this.field_5974.method_43048(this.maxSitTime - this.minSitTime) + this.minSitTime;
        this.field_6011.method_12778(SITTING, (Object)setSitting);
    }

    public boolean getIsAsleep() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    public void setSleeping(boolean setAsleep) {
        this.field_6011.method_12778(SLEEPING, (Object)setAsleep);
        this.sleepTimer = 0;
        this.sleepTime = this.field_5974.method_43048(this.maxSleepTime - this.minSleepTime) + this.minSleepTime;
        if (setAsleep && !this.getSitting()) {
            super.method_24346(true);
        }
    }

    public String getTextureFile() {
        return this.getVariant();
    }

    protected void setVariant(String variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    protected String getVariant() {
        return (String)this.field_6011.method_12789(VARIANT);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10582("Variant", this.getVariant());
        tag.method_10556("HasShrine", this.getHasShrine().booleanValue());
        tag.method_10556("IsSitting", this.getSitting());
        class_2382 shrinePos = this.getShrinePos();
        tag.method_10569("ShrinePosX", shrinePos.method_10263());
        tag.method_10569("ShrinePosY", shrinePos.method_10264());
        tag.method_10569("ShrinePosZ", shrinePos.method_10260());
        if (this.method_6139() != null) {
            tag.method_25927("Owner", this.method_6139());
        }
        if (!this.method_6181()) {
            tag.method_10551("Owner");
        }
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setVariant(tag.method_10558("Variant"));
        this.setHasShrine(tag.method_10577("HasShrine"));
        this.method_24346(tag.method_10577("IsSitting"));
        int x = tag.method_10550("ShrinePosX");
        int y = tag.method_10550("ShrinePosY");
        int z = tag.method_10550("ShrinePosZ");
        this.setShrinePos(x, y, z);
    }

    public int getGlow() {
        return this.settings.glow;
    }

    static {
        textureCounter = (int)(Math.random() * 100.0);
        ATTACKING = class_2945.method_12791(GuardianEntity.class, (class_2941)class_2943.field_13323);
        LOOKING = class_2945.method_12791(GuardianEntity.class, (class_2941)class_2943.field_13323);
        SITTING = class_2945.method_12791(GuardianEntity.class, (class_2941)class_2943.field_13323);
        SLEEPING = class_2945.method_12791(GuardianEntity.class, (class_2941)class_2943.field_13323);
        VARIANT = class_2945.method_12791(GuardianEntity.class, (class_2941)class_2943.field_13326);
        HAS_SHRINE = class_2945.method_12791(GuardianEntity.class, (class_2941)class_2943.field_13323);
        SHRINE_POS_X = class_2945.method_12791(GuardianEntity.class, (class_2941)class_2943.field_13327);
        SHRINE_POS_Y = class_2945.method_12791(GuardianEntity.class, (class_2941)class_2943.field_13327);
        SHRINE_POS_Z = class_2945.method_12791(GuardianEntity.class, (class_2941)class_2943.field_13327);
    }

    public static class GuardianSitGoal
    extends class_1386 {
        GuardianEntity e;

        public GuardianSitGoal(GuardianEntity mob) {
            super((class_1321)mob);
            this.e = mob;
        }

        public boolean method_6264() {
            if (this.e.method_5816()) {
                return false;
            }
            if (!this.e.method_24828()) {
                return false;
            }
            class_1309 livingEntity = this.e.method_35057();
            if (livingEntity != null && this.e.method_5858((class_1297)livingEntity) < 144.0 && livingEntity.method_6065() != null) {
                return false;
            }
            return this.e.method_24345();
        }
    }

    public static class GuardianWanderAroundGoal
    extends class_1379 {
        GuardianEntity e;

        public GuardianWanderAroundGoal(GuardianEntity mob, double speed) {
            super((class_1314)mob, speed);
            this.e = mob;
        }

        public GuardianWanderAroundGoal(GuardianEntity mob, double speed, int chance) {
            super((class_1314)mob, speed, chance, true);
            this.e = mob;
        }

        public GuardianWanderAroundGoal(GuardianEntity mob, double d, int i, boolean bl) {
            super((class_1314)mob, d, i, bl);
            this.e = mob;
        }

        public boolean method_6264() {
            return !this.e.getSitting() && !this.e.getIsAsleep() && super.method_6264();
        }

        public boolean method_6266() {
            return !this.e.getSitting() && !this.e.getIsAsleep() && super.method_6266();
        }

        public void method_6269() {
            if (!this.e.getSitting() && !this.e.getIsAsleep()) {
                super.method_6269();
            }
        }

        protected class_243 method_6302() {
            class_2382 v = this.e.getShrinePos();
            class_243 pos = new class_243((double)v.method_10263(), (double)(v.method_10264() + 1), (double)v.method_10260());
            if (this.e.field_5974.method_43058() < 0.15 || this.e.method_19538().method_1022(pos) > 20.0) {
                return class_5532.method_31510((class_1314)this.field_6566, (int)5, (int)5);
            }
            return class_5532.method_31510((class_1314)this.field_6566, (int)10, (int)10);
        }
    }

    public static class GuardianLookAtEntityGoal
    extends class_1361 {
        GuardianEntity e;

        public GuardianLookAtEntityGoal(GuardianEntity mob, Class<? extends class_1309> targetType, float range) {
            super((class_1308)mob, targetType, range);
            this.e = mob;
        }

        public GuardianLookAtEntityGoal(GuardianEntity mob, Class<? extends class_1309> targetType, float range, float chance) {
            super((class_1308)mob, targetType, range, chance);
            this.e = mob;
        }

        public boolean method_6264() {
            return !this.e.getIsAsleep() && super.method_6264();
        }

        public boolean method_6266() {
            return !this.e.getIsAsleep() && super.method_6266();
        }

        public void method_6269() {
            if (!this.e.getIsAsleep()) {
                super.method_6269();
            }
        }

        public void method_6268() {
            if (!this.e.getIsAsleep()) {
                super.method_6268();
            }
        }
    }

    public static class GuardianLookAroundGoal
    extends class_1376 {
        GuardianEntity e;

        public GuardianLookAroundGoal(GuardianEntity mob) {
            super((class_1308)mob);
            this.e = mob;
        }

        public boolean method_6264() {
            return !this.e.getIsAsleep() && super.method_6264();
        }

        public boolean method_6266() {
            return !this.e.getIsAsleep() && super.method_6266();
        }

        public void method_6269() {
            if (!this.e.getIsAsleep()) {
                super.method_6269();
            }
        }

        public void method_6268() {
            if (!this.e.getIsAsleep()) {
                super.method_6268();
            }
        }
    }

    private static enum AnimationPhase {
        WALK,
        STAND,
        SIT,
        LAYDOWN,
        SLEEP;

    }

    public static class GuardianData
    extends class_1296.class_4697 {
        public final String textureFile;
        public final boolean hasShrine;
        public final boolean isSitting;
        public final int shrineX;
        public final int shrineY;
        public final int shrineZ;

        public GuardianData(String textureFilename, boolean hasShrine, boolean isSitting, int x, int y, int z) {
            super(true);
            this.textureFile = textureFilename;
            this.hasShrine = hasShrine;
            this.isSitting = isSitting;
            this.shrineX = x;
            this.shrineY = y;
            this.shrineZ = z;
        }
    }
}

