/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.guardiansgalore.config;

import com.yahoo.chirpycricket.guardiansgalore.config.ConfigFileHelper;
import com.yahoo.chirpycricket.guardiansgalore.entity.BearEntity;
import com.yahoo.chirpycricket.guardiansgalore.entity.BoarEntity;
import com.yahoo.chirpycricket.guardiansgalore.entity.ChickenEntity;
import com.yahoo.chirpycricket.guardiansgalore.entity.CricketEntity;
import com.yahoo.chirpycricket.guardiansgalore.entity.DeerEntity;
import com.yahoo.chirpycricket.guardiansgalore.entity.DoveEntity;
import com.yahoo.chirpycricket.guardiansgalore.entity.DragonEntity;
import com.yahoo.chirpycricket.guardiansgalore.entity.FoxEntity;
import com.yahoo.chirpycricket.guardiansgalore.entity.LiondogEntity;
import com.yahoo.chirpycricket.guardiansgalore.entity.RabbitEntity;
import com.yahoo.chirpycricket.guardiansgalore.entity.RavenEntity;
import com.yahoo.chirpycricket.guardiansgalore.entity.ToadEntity;
import com.yahoo.chirpycricket.guardiansgalore.entity.TortoiseEntity;
import com.yahoo.chirpycricket.guardiansgalore.entity.WolfEntity;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class Settings {
    public static HashMap<GuardianKey, GuardianSettings> settings;
    public static HashMap<GuardianKey, Class> classes;
    public static GlobalSettings globalSettings;

    public static void init() {
        if (settings != null) {
            return;
        }
        settings = new HashMap();
        classes = new HashMap();
        classes.put(GuardianKey.Bear, BearEntity.class);
        classes.put(GuardianKey.Boar, BoarEntity.class);
        classes.put(GuardianKey.Chicken, ChickenEntity.class);
        classes.put(GuardianKey.Cricket, CricketEntity.class);
        classes.put(GuardianKey.Deer, DeerEntity.class);
        classes.put(GuardianKey.Dove, DoveEntity.class);
        classes.put(GuardianKey.Dragon, DragonEntity.class);
        classes.put(GuardianKey.Fox, FoxEntity.class);
        classes.put(GuardianKey.Liondog, LiondogEntity.class);
        classes.put(GuardianKey.Rabbit, RabbitEntity.class);
        classes.put(GuardianKey.Raven, RavenEntity.class);
        classes.put(GuardianKey.Toad, ToadEntity.class);
        classes.put(GuardianKey.Tortoise, TortoiseEntity.class);
        classes.put(GuardianKey.Wolf, WolfEntity.class);
        try {
            Settings.initSettings(ConfigFileHelper.readOrCreateSettingsFile());
            int version = 0;
            if (globalSettings != null) {
                version = Settings.globalSettings.configVersion;
            }
            if (version < 3) {
                ConfigFileHelper.createBackupSettingsFile(version);
                ConfigFileHelper.createDefaultSettings();
                Settings.initSettings(ConfigFileHelper.readOrCreateSettingsFile());
            }
        }
        catch (IOException e) {
            Settings.initSettings("Config MOB properties here\r\n\r\nImportant! Do not modify the value of the config version in this file or the mod may overwrite custom settings.\r\n[Global] Config Version: 3\r\n\r\nParticles: turns guardians' ambient particle effect on/off\r\n\r\nGlow: used to adjust how bright a guardian appears (the strength of the glow effect)\r\n\r\nLoudness: sets the volume of guardians' ambient noises\r\n\r\nHealth: sets the max health the the guardian\r\n\r\nSpeed: sets the max speed at which guardians travel\r\n\r\nAttack: sets the amount of damage for guardian's melee attacks\r\n\r\nDiet: sets the kinds of food the guardian will eat\r\n\r\n-------------------------------------------------------------\r\n\r\n[Global] Enable Respawn for Tamed Guardians: on\r\n\r\nBear Particles: on\r\nBear Glow: 200\r\nBear Loudness: 40\r\nBear Health: 30\r\nBear Speed: 0.30000001192092896\r\nBear Attack: 7\r\nBear Diet: omnivore\r\n\r\nBoar Particles: on\r\nBoar Glow: 200\r\nBoar Loudness: 30\r\nBoar Health: 30\r\nBoar Speed: 0.30000001192092896\r\nBoar Attack: 7\r\nBoar Diet: herbivore\r\n\r\nChicken Particles: on\r\nChicken Glow: 200\r\nChicken Loudness: 40\r\nChicken Health: 30\r\nChicken Speed: 0.30000001192092896\r\nChicken Attack: 7\r\nChicken Diet: herbivore\r\n\r\nCricket Particles: on\r\nCricket Glow: 200\r\nCricket Loudness: 30\r\nCricket Health: 30\r\nCricket Speed: 0.30000001192092896\r\nCricket Attack: 7\r\nCricket Diet: herbivore\r\n\r\nDeer Particles: on\r\nDeer Glow: 200\r\nDeer Loudness: 40\r\nDeer Health: 30\r\nDeer Speed: 0.30000001192092896\r\nDeer Attack: 7\r\nDeer Diet: herbivore\r\n\r\nDove Particles: on\r\nDove Glow: 200\r\nDove Loudness: 40\r\nDove Health: 30\r\nDove Speed: 0.30000001192092896\r\nDove Attack: 7\r\nDove Diet: herbivore\r\n\r\nDragon Particles: on\r\nDragon Glow: 200\r\nDragon Loudness: 40\r\nDragon Health: 30\r\nDragon Speed: 0.30000001192092896\r\nDragon Attack: 7\r\nDragon Diet: omnivore\r\n\r\nFox Particles: on\r\nFox Glow: 200\r\nFox Loudness: 35\r\nFox Health: 30\r\nFox Speed: 0.30000001192092896\r\nFox Attack: 7\r\nFox Diet: omnivore\r\n\r\nLiondog Particles: on\r\nLiondog Glow: 200\r\nLiondog Loudness: 35\r\nLiondog Health: 30\r\nLiondog Speed: 0.30000001192092896\r\nLiondog Attack: 7\r\nLiondog Diet: omnivore\r\n\r\nRabbit Particles: on\r\nRabbit Glow: 200\r\nRabbit Loudness: 40\r\nRabbit Health: 30\r\nRabbit Speed: 0.30000001192092896\r\nRabbit Attack: 7\r\nRabbit Diet: herbivore\r\n\r\nRaven Particles: on\r\nRaven Glow: 200\r\nRaven Loudness: 30\r\nRaven Health: 30\r\nRaven Speed: 0.30000001192092896\r\nRaven Attack: 7\r\nRaven Diet: omnivore\r\n\r\nToad Particles: on\r\nToad Glow: 200\r\nToad Loudness: 35\r\nToad Health: 30\r\nToad Speed: 0.30000001192092896\r\nToad Attack: 7\r\nToad Diet: omnivore\r\n\r\nTortoise Particles: on\r\nTortoise Glow: 200\r\nTortoise Loudness: 30\r\nTortoise Health: 30\r\nTortoise Speed: 0.30000001192092896\r\nTortoise Attack: 7\r\nTortoise Diet: herbivore\r\n\r\nWolf Particles: on\r\nWolf Glow: 200\r\nWolf Loudness: 40\r\nWolf Health: 30\r\nWolf Speed: 0.30000001192092896\r\nWolf Attack: 7\r\nWolf Diet: omnivore\r\n");
            e.printStackTrace();
        }
    }

    private static void initSettings(BufferedReader br) throws IOException {
        String line;
        if (br == null) {
            System.out.println("Could not read config file.");
            return;
        }
        HashMap fileContents = new HashMap();
        ArrayList<String> globalSettings = new ArrayList<String>();
        for (GuardianKey k : GuardianKey.values()) {
            fileContents.put(k, new ArrayList());
        }
        while ((line = br.readLine()) != null) {
            GuardianKey[] guardianKeyArray = GuardianKey.values();
            int n = guardianKeyArray.length;
            for (int k = 0; k < n; ++k) {
                GuardianKey k2 = guardianKeyArray[k];
                if (line.contains(k2.name())) {
                    ((ArrayList)fileContents.get((Object)k2)).add(line);
                }
                if (!line.contains("[Global] ")) continue;
                globalSettings.add(line);
            }
        }
        for (GuardianKey k : GuardianKey.values()) {
            GuardianSettings s = new GuardianSettings((ArrayList)fileContents.get((Object)k));
            settings.put(k, s);
        }
        Settings.globalSettings = new GlobalSettings(globalSettings);
    }

    private static void initSettings(String fileStr) {
        String[] lines = fileStr.split("\r\n");
        HashMap fileContents = new HashMap();
        ArrayList<String> globalSettings = new ArrayList<String>();
        for (GuardianKey guardianKey : GuardianKey.values()) {
            fileContents.put(guardianKey, new ArrayList());
        }
        for (String string : lines) {
            for (GuardianKey k : GuardianKey.values()) {
                if (string.contains(k.name())) {
                    ((ArrayList)fileContents.get((Object)k)).add(string);
                }
                if (!string.contains("[Global] ")) continue;
                globalSettings.add(string);
            }
        }
        for (GuardianKey guardianKey : GuardianKey.values()) {
            GuardianSettings s = new GuardianSettings((ArrayList)fileContents.get((Object)guardianKey));
            settings.put(guardianKey, s);
        }
        Settings.globalSettings = new GlobalSettings(globalSettings);
    }

    public static void print() {
        for (GuardianKey k : GuardianKey.values()) {
            System.out.println(System.lineSeparator() + k + System.lineSeparator() + settings.get((Object)k) + System.lineSeparator());
            System.out.println();
        }
    }

    public static Boolean parseBooleanValue(String line) {
        String val = line.substring(line.lastIndexOf(": ") + 2).toLowerCase().trim();
        return (val.contains("yes") || val.contains("true") || val.equals("y") || val.contains("on")) && !val.equals("0");
    }

    public static double parseDoubleValue(String line) {
        return Double.parseDouble(line.substring(line.lastIndexOf(": ") + 2).trim());
    }

    public static int parseIntValue(String line) {
        return Integer.parseInt(line.substring(line.lastIndexOf(": ") + 2).trim());
    }

    public static String parseString(String line) {
        return line.substring(line.lastIndexOf(": ") + 2).trim().toLowerCase(Locale.ROOT);
    }

    public static String[] parseStringArray(String line, String delimiter) {
        String[] strs = new String[]{};
        if (line.lastIndexOf(":") + 1 < line.length()) {
            strs = line.substring(line.lastIndexOf(": ") + 2).trim().split(delimiter);
        }
        for (int i = 0; i < strs.length; ++i) {
            strs[i] = strs[i].trim();
        }
        return strs;
    }

    public static enum GuardianKey {
        Bear,
        Boar,
        Chicken,
        Cricket,
        Deer,
        Dove,
        Dragon,
        Fox,
        Liondog,
        Rabbit,
        Raven,
        Toad,
        Tortoise,
        Wolf,
        Humanoid;

    }

    public static class GlobalSettings {
        public int configVersion = 0;
        public boolean enableRespawn = true;

        public GlobalSettings(ArrayList<String> lines) {
            for (String str : lines) {
                if (str.contains("Config Version:")) {
                    this.configVersion = Settings.parseIntValue(str);
                }
                if (!str.contains("Enable Respawn for Tamed Guardians:")) continue;
                this.enableRespawn = Settings.parseBooleanValue(str);
            }
        }
    }

    public static class GuardianSettings {
        public boolean particles = true;
        public int glow = 200;
        public double volume = 100.0;
        public double health = 30.0;
        public double speed = 0.3f;
        public double attack = 7.0;
        public String diet = "omnivore";

        public GuardianSettings(ArrayList<String> lines) {
            for (String str : lines) {
                if (str.contains("Particles:")) {
                    this.particles = Settings.parseBooleanValue(str);
                }
                if (str.contains("Glow:")) {
                    this.glow = Settings.parseIntValue(str);
                }
                if (str.contains("Loudness:")) {
                    this.volume = Settings.parseIntValue(str);
                }
                if (str.contains("Attack:")) {
                    this.attack = Settings.parseDoubleValue(str);
                }
                if (str.contains("Speed:")) {
                    this.speed = Settings.parseDoubleValue(str);
                }
                if (str.contains("Health:")) {
                    this.health = Settings.parseDoubleValue(str);
                }
                if (!str.contains("Diet:")) continue;
                this.diet = Settings.parseString(str);
                if (this.diet.equals("herbivore") || this.diet.equals("carnivore")) continue;
                this.diet = "omnivore";
            }
        }

        public String toString() {
            return "particles: " + this.particles + System.lineSeparator() + "glow: " + this.glow + System.lineSeparator() + "volume: " + this.volume + System.lineSeparator() + "attack: " + this.attack + System.lineSeparator() + "speed: " + this.speed + System.lineSeparator() + "health: " + this.health + System.lineSeparator() + "diet: " + this.diet + System.lineSeparator();
        }
    }
}

