/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.guardiansgalore.config;

import com.yahoo.chirpycricket.guardiansgalore.GuardiansGalore;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigFileHelper {
    public static final String configFileName = "GuardiansGalore.txt";

    protected static BufferedReader readOrCreateSettingsFile() {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(FabricLoader.getInstance().getConfigDir() + "/GuardiansGalore.txt"));
            return br;
        }
        catch (FileNotFoundException e) {
            try {
                ConfigFileHelper.createDefaultSettings();
                BufferedReader br2 = null;
                try {
                    br2 = new BufferedReader(new FileReader(FabricLoader.getInstance().getConfigDir() + "/GuardiansGalore.txt"));
                    return br2;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                    System.out.println("Created config file for guardiansgalore mod.");
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return br;
    }

    protected static void createDefaultSettings() throws IOException {
        FileWriter myWriter = new FileWriter(FabricLoader.getInstance().getConfigDir() + "/GuardiansGalore.txt");
        myWriter.write("Config MOB properties here\r\n\r\nImportant! Do not modify the value of the config version in this file or the mod may overwrite custom settings.\r\n[Global] Config Version: 3\r\n\r\nParticles: turns guardians' ambient particle effect on/off\r\n\r\nGlow: used to adjust how bright a guardian appears (the strength of the glow effect)\r\n\r\nLoudness: sets the volume of guardians' ambient noises\r\n\r\nHealth: sets the max health the the guardian\r\n\r\nSpeed: sets the max speed at which guardians travel\r\n\r\nAttack: sets the amount of damage for guardian's melee attacks\r\n\r\nDiet: sets the kinds of food the guardian will eat\r\n\r\n-------------------------------------------------------------\r\n\r\n[Global] Enable Respawn for Tamed Guardians: on\r\n\r\nBear Particles: on\r\nBear Glow: 200\r\nBear Loudness: 40\r\nBear Health: 30\r\nBear Speed: 0.30000001192092896\r\nBear Attack: 7\r\nBear Diet: omnivore\r\n\r\nBoar Particles: on\r\nBoar Glow: 200\r\nBoar Loudness: 30\r\nBoar Health: 30\r\nBoar Speed: 0.30000001192092896\r\nBoar Attack: 7\r\nBoar Diet: herbivore\r\n\r\nChicken Particles: on\r\nChicken Glow: 200\r\nChicken Loudness: 40\r\nChicken Health: 30\r\nChicken Speed: 0.30000001192092896\r\nChicken Attack: 7\r\nChicken Diet: herbivore\r\n\r\nCricket Particles: on\r\nCricket Glow: 200\r\nCricket Loudness: 30\r\nCricket Health: 30\r\nCricket Speed: 0.30000001192092896\r\nCricket Attack: 7\r\nCricket Diet: herbivore\r\n\r\nDeer Particles: on\r\nDeer Glow: 200\r\nDeer Loudness: 40\r\nDeer Health: 30\r\nDeer Speed: 0.30000001192092896\r\nDeer Attack: 7\r\nDeer Diet: herbivore\r\n\r\nDove Particles: on\r\nDove Glow: 200\r\nDove Loudness: 40\r\nDove Health: 30\r\nDove Speed: 0.30000001192092896\r\nDove Attack: 7\r\nDove Diet: herbivore\r\n\r\nDragon Particles: on\r\nDragon Glow: 200\r\nDragon Loudness: 40\r\nDragon Health: 30\r\nDragon Speed: 0.30000001192092896\r\nDragon Attack: 7\r\nDragon Diet: omnivore\r\n\r\nFox Particles: on\r\nFox Glow: 200\r\nFox Loudness: 35\r\nFox Health: 30\r\nFox Speed: 0.30000001192092896\r\nFox Attack: 7\r\nFox Diet: omnivore\r\n\r\nLiondog Particles: on\r\nLiondog Glow: 200\r\nLiondog Loudness: 35\r\nLiondog Health: 30\r\nLiondog Speed: 0.30000001192092896\r\nLiondog Attack: 7\r\nLiondog Diet: omnivore\r\n\r\nRabbit Particles: on\r\nRabbit Glow: 200\r\nRabbit Loudness: 40\r\nRabbit Health: 30\r\nRabbit Speed: 0.30000001192092896\r\nRabbit Attack: 7\r\nRabbit Diet: herbivore\r\n\r\nRaven Particles: on\r\nRaven Glow: 200\r\nRaven Loudness: 30\r\nRaven Health: 30\r\nRaven Speed: 0.30000001192092896\r\nRaven Attack: 7\r\nRaven Diet: omnivore\r\n\r\nToad Particles: on\r\nToad Glow: 200\r\nToad Loudness: 35\r\nToad Health: 30\r\nToad Speed: 0.30000001192092896\r\nToad Attack: 7\r\nToad Diet: omnivore\r\n\r\nTortoise Particles: on\r\nTortoise Glow: 200\r\nTortoise Loudness: 30\r\nTortoise Health: 30\r\nTortoise Speed: 0.30000001192092896\r\nTortoise Attack: 7\r\nTortoise Diet: herbivore\r\n\r\nWolf Particles: on\r\nWolf Glow: 200\r\nWolf Loudness: 40\r\nWolf Health: 30\r\nWolf Speed: 0.30000001192092896\r\nWolf Attack: 7\r\nWolf Diet: omnivore\r\n");
        myWriter.close();
    }

    protected static void createBackupSettingsFile(int configVersion) throws IOException {
        System.out.println("Current config file is outdated. Created backup and regenerated new config for MythicMounts mod.");
        FileWriter myWriter = new FileWriter(FabricLoader.getInstance().getConfigDir() + "/GuardiansGalore.txt.backup_version" + configVersion + ".txt");
        BufferedReader br = new BufferedReader(new FileReader(FabricLoader.getInstance().getConfigDir() + "/GuardiansGalore.txt"));
        for (Object line : br.lines().toArray()) {
            myWriter.write(line + System.lineSeparator());
        }
        myWriter.close();
        br.close();
    }

    private static InputStream getFileFromResourceAsStream(String fileName) {
        ClassLoader classLoader = GuardiansGalore.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(fileName);
        if (inputStream == null) {
            throw new IllegalArgumentException("file not found! " + fileName);
        }
        return inputStream;
    }
}

