/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.settings;

import ht.treechop.TreeChop;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.settings.SneakBehavior;
import java.util.Optional;
import net.minecraft.class_2487;

public class SyncedChopData {
    protected static final String FELLING_ENABLED_KEY = "fellingEnabled";
    protected static final String CHOPPING_ENABLED_KEY = "choppingEnabled";
    protected static final String SNEAK_BEHAVIOR_KEY = "sneakBehavior";
    protected static final String TREES_MUST_HAVE_LEAVES_KEY = "treesMustHaveLeaves";
    protected static final String CHOP_IN_CREATIVE_MODE_KEY = "chopInCreativeMode";
    protected static final String IS_SYNCED_KEY = "isSynced";
    private final ChopSettings settings;
    private boolean isSynced = false;

    public SyncedChopData(ChopSettings settings) {
        this.settings = settings;
    }

    public ChopSettings getSettings() {
        return this.settings;
    }

    public boolean isSynced() {
        return this.isSynced;
    }

    public void setSynced() {
        this.isSynced = true;
    }

    public class_2487 makeSaveData() {
        class_2487 nbt = new class_2487();
        nbt.method_10556(CHOPPING_ENABLED_KEY, this.settings.getChoppingEnabled());
        nbt.method_10556(FELLING_ENABLED_KEY, this.settings.getFellingEnabled());
        nbt.method_10582(SNEAK_BEHAVIOR_KEY, this.settings.getSneakBehavior().name());
        nbt.method_10556(TREES_MUST_HAVE_LEAVES_KEY, this.settings.getTreesMustHaveLeaves());
        nbt.method_10556(CHOP_IN_CREATIVE_MODE_KEY, this.settings.getChopInCreativeMode());
        nbt.method_10556(IS_SYNCED_KEY, this.isSynced());
        return nbt;
    }

    public SyncedChopData readSaveData(class_2487 tag) {
        if (tag.method_10545(IS_SYNCED_KEY)) {
            String sneakBehaviorId;
            Optional<Boolean> choppingEnabled = this.getBoolean(tag, CHOPPING_ENABLED_KEY);
            Optional<Boolean> fellingEnabled = this.getBoolean(tag, FELLING_ENABLED_KEY);
            Optional<Boolean> onlyChopTreesWithLeaves = this.getBoolean(tag, TREES_MUST_HAVE_LEAVES_KEY);
            Optional<Boolean> chopInCreativeMode = this.getBoolean(tag, CHOP_IN_CREATIVE_MODE_KEY);
            Optional<Boolean> isSynced = this.getBoolean(tag, IS_SYNCED_KEY);
            SneakBehavior defaultSneakBehavior = ConfigHandler.defaultChopSettings.get().getSneakBehavior();
            String string = sneakBehaviorId = tag.method_10545(SNEAK_BEHAVIOR_KEY) ? tag.method_10558(SNEAK_BEHAVIOR_KEY) : "";
            if (sneakBehaviorId.isEmpty()) {
                this.settings.setSneakBehavior(defaultSneakBehavior);
            } else {
                SneakBehavior sneakBehavior;
                try {
                    sneakBehavior = SneakBehavior.valueOf(sneakBehaviorId);
                }
                catch (IllegalArgumentException e) {
                    TreeChop.LOGGER.warn(String.format("NBT contains bad sneak behavior value \"%s\"; using default value \"%s\"", tag.method_10558(SNEAK_BEHAVIOR_KEY), defaultSneakBehavior.name()));
                    sneakBehavior = defaultSneakBehavior;
                }
                this.settings.setSneakBehavior(sneakBehavior);
            }
            this.settings.setChoppingEnabled(choppingEnabled.orElse(this.settings.getChoppingEnabled()));
            this.settings.setFellingEnabled(fellingEnabled.orElse(this.settings.getFellingEnabled()));
            this.settings.setTreesMustHaveLeaves(onlyChopTreesWithLeaves.orElse(this.settings.getTreesMustHaveLeaves()));
            this.settings.setChopInCreativeMode(chopInCreativeMode.orElse(this.settings.getChopInCreativeMode()));
            if (isSynced.orElse(false).booleanValue()) {
                this.setSynced();
            }
        }
        return this;
    }

    protected Optional<Boolean> getBoolean(class_2487 CompoundTag, String key) {
        return CompoundTag.method_10545(key) ? Optional.of(CompoundTag.method_10577(key)) : Optional.empty();
    }
}

