/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.settings;

import ht.treechop.common.settings.SettingsField;
import net.minecraft.class_2540;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Setting {
    private final SettingsField field;
    private Object value;

    Setting(SettingsField field) {
        this.field = field;
        this.value = field.getDefaultValue();
    }

    public Setting(SettingsField field, Object value) {
        this.field = field;
        this.value = value;
    }

    public SettingsField getField() {
        return this.field;
    }

    public Object getValue() {
        return this.value;
    }

    public void set(Object newValue) {
        if (!newValue.getClass().isInstance(this.value)) {
            throw new IllegalArgumentException(String.format("SettingsField %s cannot accept value %s (%s)", new Object[]{this.field, newValue, newValue.getClass()}));
        }
        this.value = newValue;
    }

    public void encode(class_2540 buffer) {
        this.field.encode(buffer, this.value);
    }

    public static Setting decode(class_2540 buffer) {
        return SettingsField.decode(buffer);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Setting)) {
            return false;
        }
        Setting otherSetting = (Setting)other;
        return this.field == otherSetting.field && this.value.equals(otherSetting.value);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.field).append(this.value).toHashCode();
    }
}

