/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.network;

import ht.treechop.TreeChop;
import ht.treechop.client.settings.ClientChopSettings;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.network.ConfirmedSetting;
import ht.treechop.common.network.CustomPacket;
import ht.treechop.common.network.PacketChannel;
import ht.treechop.common.network.ServerConfirmSettingsPacket;
import ht.treechop.common.network.ServerPermissionsPacket;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.settings.Setting;
import ht.treechop.common.settings.SettingsField;
import ht.treechop.common.settings.SyncedChopData;
import ht.treechop.server.Server;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ClientRequestSettingsPacket
implements CustomPacket {
    public static final class_2960 ID = TreeChop.resource("client_request_settings");
    private final List<Setting> settings;
    private final Event event;

    public ClientRequestSettingsPacket(List<Setting> settings, Event event) {
        this.settings = settings;
        this.event = event;
    }

    public ClientRequestSettingsPacket(SettingsField field, Object value) {
        this(Collections.singletonList(new Setting(field, value)), Event.REQUEST);
    }

    public ClientRequestSettingsPacket(ClientChopSettings chopSettings) {
        this(chopSettings.getAll(), Event.FIRST_TIME_SYNC);
    }

    @Override
    public class_2540 encode(class_2540 buffer) {
        this.event.encode(buffer);
        buffer.writeInt(this.settings.size());
        this.settings.forEach(setting -> setting.encode(buffer));
        return buffer;
    }

    public static ClientRequestSettingsPacket decode(class_2540 buffer) {
        Event event = Event.decode(buffer);
        int numSettings = buffer.readInt();
        List<Setting> settings = IntStream.range(0, numSettings).mapToObj($ -> Setting.decode(buffer)).collect(Collectors.toList());
        return new ClientRequestSettingsPacket(settings, event);
    }

    public static void handle(ClientRequestSettingsPacket message, class_3222 player, PacketChannel replyChannel) {
        ClientRequestSettingsPacket.processSettingsRequest(Server.instance().getPlayerChopData((class_1657)player), message, player, replyChannel);
    }

    private static void processSettingsRequest(SyncedChopData chopData, ClientRequestSettingsPacket message, class_3222 player, PacketChannel replyChannel) {
        List<Setting> settings = message.event == Event.FIRST_TIME_SYNC && chopData.isSynced() ? chopData.getSettings().getAll() : message.settings;
        List<ConfirmedSetting> confirmedSettings = settings.stream().map(setting -> ClientRequestSettingsPacket.processSingleSettingRequest(setting, player, chopData.getSettings(), message.event)).collect(Collectors.toList());
        if (!chopData.isSynced()) {
            chopData.setSynced();
        }
        replyChannel.send(new ServerConfirmSettingsPacket(confirmedSettings));
        if (message.event == Event.FIRST_TIME_SYNC) {
            replyChannel.send(new ServerPermissionsPacket(ConfigHandler.getServerPermissions()));
        }
    }

    private static ConfirmedSetting processSingleSettingRequest(Setting setting, class_3222 player, ChopSettings chopSettings, Event requestEvent) {
        ConfirmedSetting.Event confirmEvent;
        if (ClientRequestSettingsPacket.playerHasPermission((class_1657)player, setting)) {
            chopSettings.set(setting);
            confirmEvent = ConfirmedSetting.Event.ACCEPT;
        } else {
            Setting defaultSetting = ClientRequestSettingsPacket.getDefaultSetting(player, setting);
            chopSettings.set(defaultSetting);
            confirmEvent = ConfirmedSetting.Event.DENY;
        }
        if (requestEvent == Event.FIRST_TIME_SYNC) {
            confirmEvent = ConfirmedSetting.Event.SILENT;
        }
        SettingsField field = setting.getField();
        return new ConfirmedSetting(new Setting(field, chopSettings.get(field)), confirmEvent);
    }

    private static Setting getDefaultSetting(class_3222 player, Setting setting) {
        return Server.getDefaultPlayerSettings().getSetting(setting.getField());
    }

    private static boolean playerHasPermission(class_1657 player, Setting setting) {
        return ConfigHandler.getServerPermissions().isPermitted(setting);
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    private static enum Event {
        FIRST_TIME_SYNC,
        REQUEST;

        private static final Event[] values;

        public static Event decode(class_2540 buffer) {
            int ordinal = buffer.readByte() % values.length;
            return values[ordinal];
        }

        public void encode(class_2540 buffer) {
            buffer.writeByte(this.ordinal());
        }

        static {
            values = Event.values();
        }
    }
}

