/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.chop;

import ht.treechop.api.AbstractTreeData;
import ht.treechop.api.IChoppableBlock;
import ht.treechop.common.chop.Chop;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.util.BlockNeighbors;
import ht.treechop.common.util.ClassUtil;
import ht.tuber.graph.DirectedGraph;
import ht.tuber.graph.FloodFill;
import ht.tuber.graph.FloodFillImpl;
import ht.tuber.graph.GraphUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.apache.commons.lang3.RandomUtils;

public class LazyTreeData
extends AbstractTreeData {
    private final class_1937 level;
    private final int chops;
    private final boolean smartDetection;
    private final int maxLeavesDistance;
    private double mass = 0.0;
    private boolean overrideLeaves = false;
    private Set<class_2338> logs = new HashSet<class_2338>(){

        @Override
        public boolean add(class_2338 blockPos) {
            if (super.add(blockPos)) {
                LazyTreeData.this.mass += ChopUtil.getSupportFactor(LazyTreeData.this.level, blockPos);
                return true;
            }
            return false;
        }
    };
    private final Set<class_2338> leaves = new HashSet<class_2338>(){

        @Override
        public boolean add(class_2338 blockPos) {
            return super.add(blockPos);
        }
    };
    private LogFinder logFinder;
    private Set<class_2338> base;
    private final DirectedGraph<class_2338> logsWorld;
    private final DirectedGraph<class_2338> leavesWorld;

    public LazyTreeData(class_1937 level, class_2338 origin, DirectedGraph<class_2338> logGraph, DirectedGraph<class_2338> leavesGraph, Predicate<class_2338> logFilter, Predicate<class_2338> leavesFilter, int maxNumLogs, int maxLeavesDistance, boolean smartDetection) {
        this.level = level;
        this.smartDetection = smartDetection;
        this.maxLeavesDistance = maxLeavesDistance;
        this.logsWorld = GraphUtil.filter(logGraph, this::gatherLog, pos -> this.check((class_2338)pos, logFilter, leavesFilter));
        this.leavesWorld = GraphUtil.filterNeighbors(leavesGraph, leavesFilter);
        this.makeTreeBase(level, origin);
        this.logs.addAll(this.base);
        this.chops = this.base.stream().map(pos -> ChopUtil.getNumChops(level, pos)).reduce(Integer::sum).orElse(0);
        this.logFinder = new LogFinder(this.logsWorld, this.base, maxNumLogs);
    }

    private boolean gatherLog(class_2338 pos) {
        this.logs.add(pos);
        return true;
    }

    private boolean check(class_2338 pos, Predicate<class_2338> logFilter, Predicate<class_2338> leavesFilter) {
        if (leavesFilter.test(pos)) {
            this.leaves.add(pos);
        }
        return logFilter.test(pos);
    }

    @Override
    public boolean hasLeaves() {
        if (this.overrideLeaves || !this.leaves.isEmpty()) {
            return true;
        }
        return this.logFinder.find().anyMatch(p -> !this.leaves.isEmpty() || this.overrideLeaves);
    }

    @Override
    public void setLogBlocks(Set<class_2338> logBlocks) {
        this.logs = logBlocks;
        this.mass = ChopUtil.getSupportFactor(this.level, this.logs.stream()).orElse(1.0);
        this.logFinder = new LogFinder(a -> Stream.empty(), Collections.emptySet(), 0);
    }

    @Override
    public void setLeaves(boolean hasLeaves) {
        this.overrideLeaves = hasLeaves;
    }

    @Override
    public Stream<class_2338> streamLogs() {
        return Stream.concat(this.logs.stream(), this.logFinder.find());
    }

    @Override
    public Stream<class_2338> streamLeaves() {
        LinkedList allLeaves = new LinkedList();
        this.forEachLeaves(this.leaves, allLeaves::add);
        return allLeaves.stream();
    }

    private void completeTree() {
        this.logFinder.find().count();
    }

    @Override
    public void forEachLeaves(Consumer<class_2338> consumer) {
        this.forEachLeaves(this.leaves, consumer);
    }

    private void forEachLeaves(Collection<class_2338> firstLeaves, Consumer<class_2338> forEach) {
        this.completeTree();
        if (this.smartDetection) {
            this.forEachLeavesSmart(firstLeaves, forEach);
        } else {
            this.forEachLeavesDumb(firstLeaves, forEach);
        }
    }

    private void forEachLeavesSmart(Collection<class_2338> firstLeaves, Consumer<class_2338> forEach) {
        this.leaves.stream().filter(pos -> this.leavesHasExactDistance(this.level.method_8320(pos), 1)).forEach(forEach);
        AtomicInteger highestDistance = new AtomicInteger(this.maxLeavesDistance);
        AtomicInteger distance = new AtomicInteger();
        DirectedGraph<class_2338> distancedLeavesGraph = GraphUtil.filterNeighbors(this.leavesWorld, pos -> {
            class_2680 state = this.level.method_8320(pos);
            state.method_28500((class_2769)class_2397.field_11199).ifPresent(d -> {
                if (d > highestDistance.get()) {
                    highestDistance.set((int)d);
                }
            });
            return this.leavesHasAtLeastDistance(state, distance.get());
        });
        FloodFillImpl<class_2338> flood = new FloodFillImpl<class_2338>(firstLeaves, distancedLeavesGraph, a -> 0);
        for (int i = 2; i <= highestDistance.get(); ++i) {
            distance.set(i);
            flood.fillOnce(forEach);
        }
    }

    private void forEachLeavesDumb(Collection<class_2338> firstLeaves, Consumer<class_2338> forEach) {
        FloodFillImpl<class_2338> flood = new FloodFillImpl<class_2338>(firstLeaves, this.leavesWorld, a -> 0);
        for (int i = 0; i < this.maxLeavesDistance; ++i) {
            flood.fillOnce(forEach);
        }
    }

    @Override
    public boolean readyToFell(int numChops) {
        if (!ChopUtil.enoughChopsToFell(numChops, this.mass)) {
            return false;
        }
        return this.logFinder.find().allMatch(ignored -> ChopUtil.enoughChopsToFell(numChops, this.mass));
    }

    @Override
    public int numChopsNeededToFell() {
        this.completeTree();
        return ChopUtil.numChopsToFell(this.mass);
    }

    @Override
    public int getChops() {
        return this.chops;
    }

    public class_1937 getLevel() {
        return this.level;
    }

    private boolean leavesHasExactDistance(class_2680 state, int distance) {
        return state.method_28500((class_2769)class_2397.field_11199).orElse(distance) == distance || state.method_28500((class_2769)class_2397.field_11200).orElse(false) != false;
    }

    private boolean leavesHasAtLeastDistance(class_2680 state, int distance) {
        return state.method_28500((class_2769)class_2397.field_11199).orElse(distance) >= distance || state.method_28500((class_2769)class_2397.field_11200).orElse(false) != false;
    }

    private void makeTreeBase(class_1937 level, class_2338 origin) {
        this.base = new HashSet<class_2338>();
        if (ChopUtil.isBlockChoppable(level, origin)) {
            DirectedGraph<class_2338> adjacentWorld = BlockNeighbors.ADJACENTS_AND_DIAGONALS::asStream;
            this.base.add(origin);
            GraphUtil.flood(GraphUtil.filterNeighbors(adjacentWorld, pos -> ChopUtil.getNumChops(level, pos) > 0), origin, class_2382::method_10264).fill().forEach(this.base::add);
        }
    }

    @Override
    public Collection<Chop> chop(class_2338 target, int numChops) {
        Stack<Chop> chops = new Stack<Chop>();
        AtomicInteger chopsLeft = new AtomicInteger(numChops);
        if (chopsLeft.get() > 0) {
            GraphUtil.flood(this.logsWorld, this.base, a -> ChopUtil.blockDistance(target, a) * 32 + RandomUtils.nextInt((int)0, (int)32)).fill().takeWhile(pos -> {
                chopsLeft.set(LazyTreeData.gatherChopAndGetNumChopsRemaining(this.level, pos, chopsLeft.get(), chops));
                return chopsLeft.get() > 0;
            }).count();
        }
        return chops;
    }

    private static int gatherChopAndGetNumChopsRemaining(class_1937 level, class_2338 pos, int numChops, List<Chop> chops) {
        class_2680 blockStateBeforeChopping = level.method_8320(pos);
        if (!(blockStateBeforeChopping.method_26204() instanceof IChoppableBlock) && LazyTreeData.isBlockSurrounded(level, pos)) {
            return numChops;
        }
        int adjustedNumChops = LazyTreeData.adjustNumChops(level, pos, blockStateBeforeChopping, numChops);
        if (adjustedNumChops > 0) {
            chops.add(new Chop(pos, adjustedNumChops));
        }
        return numChops - adjustedNumChops;
    }

    private static int adjustNumChops(class_1937 level, class_2338 blockPos, class_2680 blockState, int numChops) {
        IChoppableBlock choppableBlock = ClassUtil.getChoppableBlock((class_1922)level, blockPos, blockState);
        if (choppableBlock != null) {
            int currentNumChops = choppableBlock.getNumChops((class_1922)level, blockPos, blockState);
            int maxNondestructiveChops = choppableBlock.getMaxNumChops((class_1922)level, blockPos, blockState) - currentNumChops;
            return Math.min(maxNondestructiveChops, numChops);
        }
        return 0;
    }

    private static boolean isBlockSurrounded(class_1937 level, class_2338 pos) {
        return Stream.of(pos.method_10067(), pos.method_10095(), pos.method_10078(), pos.method_10072()).allMatch(neighborPos -> ChopUtil.isBlockALog(level, neighborPos));
    }

    private static class LogFinder {
        private int size = 0;
        private final int maxSize;
        FloodFill<class_2338> flood;

        public LogFinder(DirectedGraph<class_2338> logsWorld, Set<class_2338> base, int maxSize) {
            this.flood = GraphUtil.flood(logsWorld, base, v -> -v.method_10264());
            this.maxSize = maxSize;
        }

        public Stream<class_2338> find() {
            int n = this.size;
            return this.flood.fill().peek(a -> ++this.size).limit(this.maxSize - n);
        }
    }
}

