/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.loading.json.raw;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import mod.azure.azurelibarmor.AzureLib;
import mod.azure.azurelibarmor.util.JsonUtil;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public record FaceUV(@Nullable String materialInstance, double[] uv, double[] uvSize, Rotation uvRotation) {
    public static JsonDeserializer<FaceUV> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            String materialInstance = class_3518.method_15253((JsonObject)obj, (String)"material_instance", null);
            double[] uv = JsonUtil.jsonArrayToDoubleArray(class_3518.method_15292((JsonObject)obj, (String)"uv", null));
            double[] uvSize = JsonUtil.jsonArrayToDoubleArray(class_3518.method_15292((JsonObject)obj, (String)"uv_size", null));
            Rotation uvRotation = Rotation.fromValue(class_3518.method_15282((JsonObject)obj, (String)"uv_rotation", (int)0));
            return new FaceUV(materialInstance, uv, uvSize, uvRotation);
        };
    }

    public static enum Rotation {
        NONE,
        CLOCKWISE_90,
        CLOCKWISE_180,
        CLOCKWISE_270;


        public static Rotation fromValue(int value) throws JsonParseException {
            try {
                return Rotation.values()[value % 360 / 90];
            }
            catch (Exception e) {
                AzureLib.LOGGER.error("Invalid Face UV rotation: " + value);
                return Rotation.fromValue(class_3532.method_15375((float)((float)Math.abs(value) / 90.0f)) * 90);
            }
        }

        public float[] rotateUvs(float u, float v, float uWidth, float vHeight) {
            float[] fArray;
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NONE: {
                    float[] fArray2 = new float[8];
                    fArray2[0] = u;
                    fArray2[1] = v;
                    fArray2[2] = uWidth;
                    fArray2[3] = v;
                    fArray2[4] = uWidth;
                    fArray2[5] = vHeight;
                    fArray2[6] = u;
                    fArray = fArray2;
                    fArray2[7] = vHeight;
                    break;
                }
                case CLOCKWISE_90: {
                    float[] fArray3 = new float[8];
                    fArray3[0] = uWidth;
                    fArray3[1] = v;
                    fArray3[2] = uWidth;
                    fArray3[3] = vHeight;
                    fArray3[4] = u;
                    fArray3[5] = vHeight;
                    fArray3[6] = u;
                    fArray = fArray3;
                    fArray3[7] = v;
                    break;
                }
                case CLOCKWISE_180: {
                    float[] fArray4 = new float[8];
                    fArray4[0] = uWidth;
                    fArray4[1] = vHeight;
                    fArray4[2] = u;
                    fArray4[3] = vHeight;
                    fArray4[4] = u;
                    fArray4[5] = v;
                    fArray4[6] = uWidth;
                    fArray = fArray4;
                    fArray4[7] = v;
                    break;
                }
                case CLOCKWISE_270: {
                    float[] fArray5 = new float[8];
                    fArray5[0] = u;
                    fArray5[1] = vHeight;
                    fArray5[2] = u;
                    fArray5[3] = v;
                    fArray5[4] = uWidth;
                    fArray5[5] = v;
                    fArray5[6] = uWidth;
                    fArray = fArray5;
                    fArray5[7] = vHeight;
                }
            }
            return fArray;
        }
    }
}

