/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.world.structures;

import com.lion.graveyard.Graveyard;
import com.lion.graveyard.init.TGStructures;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3486;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_4966;
import net.minecraft.class_5539;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7151;

public class TGJigsawStructure
extends class_3195 {
    public static final Codec<TGJigsawStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_3195.class_7302.field_38430.forGetter(feature -> feature.config), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(config -> config.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(config -> config.startJigsawName), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(config -> config.size), (App)class_6122.field_31540.fieldOf("start_height").forGetter(config -> config.startHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(config -> config.useExpansionHack), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.INT.fieldOf("terrain_check_size").forGetter(structure -> structure.terrainCheckSize), (App)Codec.INT.fieldOf("max_height_difference").forGetter(structure -> structure.maxHeightDifference), (App)Codec.STRING.fieldOf("structure_name").forGetter(config -> config.structureName)).apply((Applicative)instance, TGJigsawStructure::new));
    public final class_6880<class_3785> startPool;
    public final Optional<class_2960> startJigsawName;
    public final int size;
    public final class_6122 startHeight;
    public final boolean useExpansionHack;
    public final Optional<class_2902.class_2903> projectStartToHeightmap;
    public final int maxDistanceFromCenter;
    public final int terrainCheckSize;
    public final int maxHeightDifference;
    public final String structureName;
    protected final class_3195.class_7302 config;

    public TGJigsawStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int size, class_6122 startHeight, Boolean useExpansionHack, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter, int terrainCheckSize, int maxHeightDifference, String structureName) {
        super(config);
        this.config = config;
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.useExpansionHack = useExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.maxHeightDifference = maxHeightDifference;
        this.terrainCheckSize = terrainCheckSize;
        this.structureName = structureName;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        if (!Graveyard.getConfig().enabled(new class_2960("graveyard", this.structureName))) {
            return Optional.empty();
        }
        class_2338 blockpos = context.comp_568().method_33943(0);
        if (this.structureName.equals("crypt")) {
            int minHeight = -40;
            int maxHeight = -10;
            class_1923 chunkPos = context.comp_568();
            class_2919 random = context.comp_566();
            int x = random.method_43048(chunkPos.method_8327() - chunkPos.method_8326()) + chunkPos.method_8326();
            int z = random.method_43048(chunkPos.method_8329() - chunkPos.method_8328()) + chunkPos.method_8328();
            int y = random.method_43048(maxHeight - minHeight) + minHeight;
            blockpos = new class_2338(x, y, z);
        } else if (this.structureName.equals("lich_prison")) {
            class_1923 chunkPos = context.comp_568();
            class_2919 random = context.comp_566();
            int x = random.method_43048(chunkPos.method_8327() - chunkPos.method_8326()) + chunkPos.method_8326();
            int z = random.method_43048(chunkPos.method_8329() - chunkPos.method_8328()) + chunkPos.method_8328();
            int y = 210;
            blockpos = new class_2338(x, y, z);
        } else if (!TGJigsawStructure.canGenerate(context, this.terrainCheckSize, this.structureName, blockpos, this.maxHeightDifference)) {
            return Optional.empty();
        }
        return class_3778.method_30419((class_3195.class_7149)context, this.startPool, this.startJigsawName, (int)this.size, (class_2338)blockpos, (boolean)this.useExpansionHack, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
    }

    private static boolean canGenerate(class_3195.class_7149 context, int size, String name, class_2338 centerOfChunk, int maxHeightDifference) {
        return TGJigsawStructure.isTerrainFlat(context, name, centerOfChunk, size, maxHeightDifference);
    }

    protected static boolean isTerrainFlat(class_3195.class_7149 context, String name, class_2338 centerChunk, int size, int maxHeightDifference) {
        class_2794 generator = context.comp_562();
        class_5539 heightLimitView = context.comp_569();
        int chunkX = centerChunk.method_10263();
        int chunkZ = centerChunk.method_10260();
        class_7138 noiseConfig = context.comp_564();
        int i1 = generator.method_18028(chunkX, chunkZ, class_2902.class_2903.field_13194, heightLimitView, noiseConfig);
        int j1 = generator.method_18028(chunkX, chunkZ + size, class_2902.class_2903.field_13194, heightLimitView, noiseConfig);
        int k1 = generator.method_18028(chunkX + size, chunkZ, class_2902.class_2903.field_13194, heightLimitView, noiseConfig);
        int o1 = generator.method_18028(chunkX, chunkZ - size, class_2902.class_2903.field_13194, heightLimitView, noiseConfig);
        int p1 = generator.method_18028(chunkX - size, chunkZ, class_2902.class_2903.field_13194, heightLimitView, noiseConfig);
        class_4966 sample1 = generator.method_26261(chunkX, chunkZ, heightLimitView, noiseConfig);
        class_4966 sample2 = generator.method_26261(chunkX, chunkZ + size, heightLimitView, noiseConfig);
        class_4966 sample3 = generator.method_26261(chunkX + size, chunkZ, heightLimitView, noiseConfig);
        class_4966 sample4 = generator.method_26261(chunkX, chunkZ - size, heightLimitView, noiseConfig);
        class_4966 sample5 = generator.method_26261(chunkX - size, chunkZ, heightLimitView, noiseConfig);
        if (!name.equals("haunted_house") && (sample1.method_32892(i1).method_26227().method_15767(class_3486.field_15517) || sample2.method_32892(j1).method_26227().method_15767(class_3486.field_15517) || sample3.method_32892(k1).method_26227().method_15767(class_3486.field_15517) || sample4.method_32892(o1).method_26227().method_15767(class_3486.field_15517) || sample5.method_32892(p1).method_26227().method_15767(class_3486.field_15517))) {
            return false;
        }
        int minSides = Math.min(Math.min(j1, p1), Math.min(o1, k1));
        int minHeight = Math.min(minSides, i1);
        int maxSides = Math.max(Math.max(j1, p1), Math.max(o1, k1));
        int maxHeight = Math.max(maxSides, i1);
        return Math.abs(maxHeight - minHeight) <= maxHeightDifference;
    }

    public class_7151<?> method_41618() {
        return TGStructures.TG_JIGSAW;
    }
}

