/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.template;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class TemplateInclusion {
    public String template;
    public String as;
    @SerializedName(value="using")
    public JsonObject localBindings = new JsonObject();
    public int x;
    public int y;
    transient Set<String> visitedTemplates = new LinkedHashSet<String>();

    public void upperMerge(@Nullable TemplateInclusion parent) {
        if (parent == null) {
            return;
        }
        if (parent.visitedTemplates.contains(this.template)) {
            throw new IllegalArgumentException("Breaking when include template " + this.template + ", circular dependencies aren't allowed (stack = " + parent.visitedTemplates + ")");
        }
        this.visitedTemplates = new LinkedHashSet<String>(parent.visitedTemplates);
        this.visitedTemplates.add(this.template);
        this.as = parent.qualifyName(this.as);
        this.x += parent.x;
        this.y += parent.y;
        for (Map.Entry entry : this.localBindings.entrySet()) {
            String realVal;
            String key = (String)entry.getKey();
            JsonElement val = (JsonElement)entry.getValue();
            if (!val.isJsonPrimitive() || !val.getAsString().startsWith("#") || !parent.localBindings.has(realVal = val.getAsString().substring(1))) continue;
            entry.setValue(parent.localBindings.get(realVal));
        }
    }

    public void process(class_1937 level, IComponentProcessor processor) {
        if (processor == null) {
            return;
        }
        for (Map.Entry entry : this.localBindings.entrySet()) {
            String realVal;
            IVariable res;
            String key = (String)entry.getKey();
            JsonElement val = (JsonElement)entry.getValue();
            if (!val.isJsonPrimitive() || !val.getAsString().startsWith("#") || (res = processor.process(level, realVal = val.getAsString().substring(1))) == null) continue;
            entry.setValue(res.unwrap());
        }
    }

    public String qualifyName(String name) {
        boolean prefixed = name.startsWith("#");
        String query = prefixed ? name.substring(1) : name;
        String result = IVariable.wrap(this.localBindings.get(query)).asString();
        if (result.startsWith("#")) {
            return result.substring(1);
        }
        return (prefixed ? "#" : "") + this.as + (String)(query.isEmpty() ? "" : "." + query);
    }

    public IVariable attemptVariableLookup(String key) {
        IVariable result;
        if (key.startsWith("#")) {
            key = key.substring(1);
        }
        return (result = IVariable.wrap(this.localBindings.get(key))).asString().isEmpty() || this.isUpreference(result) ? null : result;
    }

    public boolean isUpreference(IVariable v) {
        return v.unwrap().isJsonPrimitive() && v.asString().startsWith("#");
    }

    public IVariableProvider wrapProvider(final IVariableProvider provider) {
        return new IVariableProvider(){

            @Override
            public boolean has(String key) {
                return TemplateInclusion.this.attemptVariableLookup(key) != null || provider.has(TemplateInclusion.this.qualifyName(key));
            }

            @Override
            public IVariable get(String key) {
                IVariable vari = TemplateInclusion.this.attemptVariableLookup(key);
                return vari == null ? provider.get(TemplateInclusion.this.qualifyName(key)) : vari;
            }
        };
    }
}

