/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.AbstractReadStateHolder;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookIcon;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.page.PageEmpty;
import vazkii.patchouli.client.book.page.PageQuest;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.util.ItemStackUtil;
import vazkii.patchouli.common.util.SerializationUtil;

public final class BookEntry
extends AbstractReadStateHolder
implements Comparable<BookEntry> {
    private final String name;
    private final String flag;
    private final boolean priority;
    private final boolean secret;
    private final boolean readByDefault;
    private final BookPage[] pages;
    @Nullable
    private final class_2960 advancement;
    @Nullable
    private final class_2960 turnin;
    private final int sortnum;
    private final int entryColor;
    private final Map<String, Integer> extraRecipeMappings;
    private final class_2960 id;
    private final Book book;
    @Nullable
    private final String addedBy;
    private final class_2960 categoryId;
    private BookCategory category;
    private final BookIcon icon;
    private final List<BookPage> realPages = new ArrayList<BookPage>();
    private final List<ItemStackUtil.StackWrapper> relevantStacks = new LinkedList<ItemStackUtil.StackWrapper>();
    private boolean locked;
    private boolean built;
    private static final List<BookPage> NO_PAGE = ImmutableList.of((Object)new PageEmpty());

    public BookEntry(JsonObject root, class_2960 id, Book book, @Nullable String addedBy) {
        this.id = id;
        this.book = book;
        this.addedBy = addedBy;
        String categoryId = class_3518.method_15265((JsonObject)root, (String)"category");
        if (!categoryId.contains(":")) {
            String hint = String.format("`%s:%s`", book.id.method_12836(), categoryId);
            throw new IllegalArgumentException("`category` must be fully qualified (domain:name). Hint: Try " + hint);
        }
        this.categoryId = new class_2960(categoryId);
        this.name = class_3518.method_15265((JsonObject)root, (String)"name");
        this.flag = class_3518.method_15253((JsonObject)root, (String)"flag", (String)"");
        this.icon = BookIcon.from(class_3518.method_15265((JsonObject)root, (String)"icon"));
        this.priority = class_3518.method_15258((JsonObject)root, (String)"priority", (boolean)false);
        this.secret = class_3518.method_15258((JsonObject)root, (String)"secret", (boolean)false);
        this.readByDefault = class_3518.method_15258((JsonObject)root, (String)"read_by_default", (boolean)false);
        this.advancement = SerializationUtil.getAsResourceLocation(root, "advancement", null);
        this.turnin = SerializationUtil.getAsResourceLocation(root, "turnin", null);
        this.sortnum = class_3518.method_15282((JsonObject)root, (String)"sortnum", (int)0);
        String entryColor = class_3518.method_15253((JsonObject)root, (String)"entry_color", null);
        this.entryColor = entryColor != null ? Integer.parseInt(entryColor, 16) : book.textColor;
        this.pages = (BookPage[])ClientBookRegistry.INSTANCE.gson.fromJson((JsonElement)class_3518.method_15261((JsonObject)root, (String)"pages"), BookPage[].class);
        JsonObject extraRecipeMap = class_3518.method_15281((JsonObject)root, (String)"extra_recipe_mappings", null);
        this.extraRecipeMappings = extraRecipeMap == null ? Collections.emptyMap() : (Map)ClientBookRegistry.INSTANCE.gson.fromJson((JsonElement)extraRecipeMap, new TypeToken<Map<String, Integer>>(){}.getType());
    }

    public class_5250 getName() {
        return this.book.i18n ? class_2561.method_43471((String)this.name) : class_2561.method_43470((String)this.name);
    }

    public List<BookPage> getPages() {
        List<BookPage> pages = !this.getBook().advancementsEnabled() ? this.realPages : this.realPages.stream().filter(BookPage::isPageUnlocked).collect(Collectors.toList());
        return pages.isEmpty() ? NO_PAGE : pages;
    }

    public int getPageFromAnchor(String anchor) {
        List<BookPage> pages = this.getPages();
        for (int i = 0; i < pages.size(); ++i) {
            BookPage page = pages.get(i);
            if (!anchor.equals(page.anchor)) continue;
            return i;
        }
        return -1;
    }

    public boolean isPriority() {
        return this.priority;
    }

    public BookIcon getIcon() {
        return this.icon;
    }

    public void initCategory(class_2960 file, Function<class_2960, BookCategory> categories) {
        this.category = categories.apply(this.categoryId);
        if (this.category == null) {
            String msg = String.format("Entry in file %s does not have a valid category.", file);
            throw new RuntimeException(msg);
        }
        this.category.addEntry(this);
    }

    public BookCategory getCategory() {
        return this.category;
    }

    public void updateLockStatus() {
        boolean currLocked = this.locked;
        this.locked = this.advancement != null && !ClientAdvancements.hasDone(this.advancement.toString());
        boolean dirty = false;
        if (!this.locked && currLocked) {
            dirty = true;
            this.book.markUpdated();
        }
        if (!dirty && !this.readStateDirty && this.getReadState() == EntryDisplayState.PENDING && ClientAdvancements.hasDone(this.turnin.toString())) {
            dirty = true;
        }
        if (dirty) {
            this.markReadStateDirty();
        }
    }

    public boolean isLocked() {
        if (this.isSecret()) {
            return this.locked;
        }
        return this.getBook().advancementsEnabled() && this.locked;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public boolean shouldHide() {
        return this.isSecret() && this.isLocked();
    }

    public int getEntryColor() {
        return this.entryColor;
    }

    public class_2960 getId() {
        return this.id;
    }

    public boolean canAdd() {
        return this.flag.isEmpty() || PatchouliConfig.getConfigFlag(this.flag);
    }

    public boolean isFoundByQuery(String query) {
        if (this.getName().getString().toLowerCase().contains(query)) {
            return true;
        }
        for (ItemStackUtil.StackWrapper wrapper : this.relevantStacks) {
            if (!wrapper.stack.method_7964().getString().toLowerCase().contains(query)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(BookEntry o) {
        EntryDisplayState otherState;
        if (o.locked != this.locked) {
            return this.locked ? 1 : -1;
        }
        EntryDisplayState ourState = this.getReadState();
        if (ourState != (otherState = o.getReadState())) {
            return ourState.compareTo(otherState);
        }
        if (o.priority != this.priority) {
            return this.priority ? -1 : 1;
        }
        int sort = this.sortnum - o.sortnum;
        return sort == 0 ? this.getName().getString().compareTo(o.getName().getString()) : sort;
    }

    public void build(class_1937 level, BookContentsBuilder builder) {
        if (this.built) {
            return;
        }
        for (int i = 0; i < this.pages.length; ++i) {
            if (!this.pages[i].canAdd(this.book)) continue;
            try {
                this.pages[i].build(level, this, builder, i);
                this.realPages.add(this.pages[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Error while loading entry " + this.id + " page " + i, e);
            }
        }
        if (this.extraRecipeMappings != null) {
            for (Map.Entry<String, Integer> entry : this.extraRecipeMappings.entrySet()) {
                List<class_1799> stacks;
                String key = entry.getKey();
                int pageNumber = entry.getValue();
                try {
                    stacks = ItemStackUtil.loadStackListFromString(key);
                }
                catch (Exception e) {
                    PatchouliAPI.LOGGER.warn("Invalid extra recipe mapping: {} to page {} in entry {}: {}", (Object)key, (Object)pageNumber, (Object)this.id, (Object)e.getMessage());
                    continue;
                }
                if (!stacks.isEmpty() && pageNumber < this.pages.length) {
                    for (class_1799 stack : stacks) {
                        this.addRelevantStack(builder, stack, pageNumber);
                    }
                    continue;
                }
                PatchouliAPI.LOGGER.warn("Invalid extra recipe mapping: {} to page {} in entry {}: Empty entry or page out of bounds", (Object)key, (Object)pageNumber, (Object)this.id);
            }
        }
        this.built = true;
    }

    public void addRelevantStack(BookContentsBuilder builder, class_1799 stack, int page) {
        if (stack.method_7960()) {
            return;
        }
        ItemStackUtil.StackWrapper wrapper = ItemStackUtil.wrapStack(stack);
        this.relevantStacks.add(wrapper);
        builder.addRecipeMapping(wrapper, this, page / 2);
    }

    public Book getBook() {
        return this.book;
    }

    @Nullable
    public String getAddedBy() {
        return this.addedBy;
    }

    @Override
    protected EntryDisplayState computeReadState() {
        PersistentData.BookData data = PersistentData.data.getBookData(this.book);
        if (!(data == null || this.getId() == null || this.readByDefault || this.isLocked() || data.viewedEntries.contains(this.getId()))) {
            return EntryDisplayState.UNREAD;
        }
        if (this.turnin != null && !ClientAdvancements.hasDone(this.turnin.toString())) {
            return EntryDisplayState.PENDING;
        }
        for (BookPage page : this.pages) {
            if (!(page instanceof PageQuest) || !((PageQuest)page).isCompleted(this.book)) continue;
            return EntryDisplayState.COMPLETED;
        }
        return EntryDisplayState.NEUTRAL;
    }

    @Override
    public void markReadStateDirty() {
        super.markReadStateDirty();
        this.getCategory().markReadStateDirty();
    }
}

