/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.client;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2828;
import net.minecraft.class_2960;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.effect.EntityActionsAllowed;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellInfo;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.input.SpellHotbar;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterClient;
import net.spell_engine.network.Packets;
import net.spell_engine.utils.TargetHelper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_746.class})
public abstract class ClientPlayerEntityMixin
implements SpellCasterClient {
    @Shadow
    @Final
    public class_634 field_3944;
    private List<class_1297> targets = List.of();
    @Nullable
    private SpellCast.Process spellCastProcess;

    private class_746 player() {
        return (class_746)this;
    }

    private class_1297 firstTarget() {
        return this.targets.stream().findFirst().orElse(null);
    }

    @Override
    @Nullable
    public SpellCast.Process getSpellCastProcess() {
        return this.spellCastProcess;
    }

    @Override
    public Spell getCurrentSpell() {
        if (this.spellCastProcess != null) {
            return this.spellCastProcess.spell();
        }
        return null;
    }

    @Override
    public float getCurrentCastingSpeed() {
        if (this.spellCastProcess != null) {
            return this.spellCastProcess.speed();
        }
        return 1.0f;
    }

    @Override
    public boolean isCastingSpell() {
        return this.spellCastProcess != null;
    }

    private void setSpellCastProcess(SpellCast.Process newValue, boolean sync) {
        SpellCast.Process oldValue = this.spellCastProcess;
        this.spellCastProcess = newValue;
        if (sync && !Objects.equals(oldValue, newValue)) {
            class_2960 id = null;
            float speed = 0.0f;
            int length = 0;
            if (newValue != null) {
                id = newValue.id();
                speed = newValue.speed();
                length = newValue.length();
            }
            ClientPlayNetworking.send((class_2960)Packets.SpellCastSync.ID, (class_2540)new Packets.SpellCastSync(id, speed, length).write());
        }
    }

    @Override
    public SpellCast.Attempt startSpellCast(class_1799 itemStack, class_2960 spellId) {
        class_746 caster = this.player();
        if (caster.method_7325()) {
            return SpellCast.Attempt.none();
        }
        if (spellId == null) {
            this.cancelSpellCast();
            return SpellCast.Attempt.none();
        }
        Spell spell = SpellRegistry.getSpell(spellId);
        if (this.spellCastProcess != null && this.spellCastProcess.id().equals((Object)spellId) || spell == null || spell.mode == Spell.Mode.ITEM_USE) {
            return SpellCast.Attempt.none();
        }
        if (EntityActionsAllowed.isImpaired((class_1309)caster, EntityActionsAllowed.Player.CAST_SPELL, true)) {
            return SpellCast.Attempt.none();
        }
        SpellCast.Attempt attempt = SpellHelper.attemptCasting((class_1657)caster, itemStack, spellId);
        if (attempt.isSuccess()) {
            boolean instant;
            if (this.spellCastProcess != null) {
                this.cancelSpellCast(false);
            }
            boolean bl = instant = spell.cast.duration <= 0.0f;
            if (instant) {
                SpellCast.Process process = new SpellCast.Process(spellId, spell, itemStack.method_7909(), 1.0f, 0, caster.method_37908().method_8510());
                this.setSpellCastProcess(process, false);
                this.updateSpellCast();
                this.applyInstantGlobalCooldown();
            } else {
                SpellCast.Duration details = SpellHelper.getCastTimeDetails((class_1309)caster, spell);
                this.setSpellCastProcess(new SpellCast.Process(spellId, spell, itemStack.method_7909(), details.speed(), details.length(), caster.method_37908().method_8510()), true);
            }
        }
        return attempt;
    }

    private void applyInstantGlobalCooldown() {
        int duration = SpellEngineMod.config.spell_instant_cast_gcd;
        if (duration > 0) {
            for (SpellHotbar.Slot slot : SpellHotbar.INSTANCE.slots) {
                SpellInfo info = slot.spell();
                if (info.spell().cast == null || !(info.spell().cast.duration <= 0.0f)) continue;
                this.getCooldownManager().set(info.id(), duration, false);
            }
        }
    }

    @Override
    @Nullable
    public SpellCast.Progress getSpellCastProgress() {
        if (this.spellCastProcess != null) {
            class_746 player = this.player();
            return this.spellCastProcess.progress(player.method_37908().method_8510());
        }
        return null;
    }

    @Override
    public void cancelSpellCast() {
        this.cancelSpellCast(true);
    }

    public void cancelSpellCast(boolean syncProcess) {
        SpellCast.Process process = this.spellCastProcess;
        if (process != null && SpellHelper.isChanneled(process.spell())) {
            class_746 player = this.player();
            SpellCast.Progress progress = process.progress(player.method_37908().method_8510());
            ClientPlayNetworking.send((class_2960)Packets.SpellRequest.ID, (class_2540)new Packets.SpellRequest(SpellCast.Action.RELEASE, process.id(), progress.ratio(), new int[0]).write());
        }
        this.setSpellCastProcess(null, syncProcess);
        this.targets = List.of();
    }

    private void updateSpellCast() {
        SpellCast.Process process = this.spellCastProcess;
        if (process != null) {
            class_746 player = this.player();
            if (!this.player().method_5805() || player.method_6047().method_7909() != process.item() || this.getCooldownManager().isCoolingDown(process.id()) || EntityActionsAllowed.isImpaired((class_1309)player, EntityActionsAllowed.Player.CAST_SPELL, true)) {
                this.cancelSpellCast();
                return;
            }
            this.targets = this.findTargets(process.spell());
            Spell spell = process.spell();
            int spellCastTicks = process.spellCastTicksSoFar(player.method_37908().method_8510());
            if (SpellHelper.isChanneled(spell)) {
                boolean isDue;
                int offset = Math.round((float)spell.cast.channel_ticks * 0.5f);
                int currentTick = spellCastTicks + offset;
                boolean bl = isDue = currentTick >= spell.cast.channel_ticks && currentTick % spell.cast.channel_ticks == 0;
                if (isDue) {
                    this.releaseSpellCast(process, SpellCast.Action.CHANNEL);
                }
            } else {
                boolean isFinished;
                boolean bl = isFinished = spellCastTicks >= process.length();
                if (isFinished) {
                    this.releaseSpellCast(process, SpellCast.Action.RELEASE);
                }
            }
        } else {
            this.targets = List.of();
        }
    }

    private void releaseSpellCast(SpellCast.Process process, SpellCast.Action action) {
        class_2960 spellId = process.id();
        Spell spell = process.spell();
        class_746 player = this.player();
        SpellCast.Progress progress = process.progress(player.method_37908().method_8510());
        Spell.Release.Target release = spell.release.target;
        int[] targetIDs = new int[]{};
        switch (release.type) {
            case PROJECTILE: 
            case CURSOR: 
            case METEOR: {
                class_1297 firstTarget = this.firstTarget();
                if (firstTarget == null) break;
                targetIDs = new int[]{firstTarget.method_5628()};
                break;
            }
            case AREA: 
            case BEAM: {
                targetIDs = new int[this.targets.size()];
                int i = 0;
                for (class_1297 target : this.targets) {
                    targetIDs[i] = target.method_5628();
                    ++i;
                }
                break;
            }
        }
        ClientPlayNetworking.send((class_2960)Packets.SpellRequest.ID, (class_2540)new Packets.SpellRequest(action, spellId, progress.ratio(), targetIDs).write());
        switch (action) {
            case CHANNEL: {
                if (!(progress.ratio() >= 1.0f)) break;
                this.cancelSpellCast();
                break;
            }
            case RELEASE: {
                this.cancelSpellCast();
            }
        }
    }

    @Override
    public List<class_1297> getCurrentTargets() {
        if (this.targets == null) {
            return List.of();
        }
        return this.targets;
    }

    @Override
    public class_1297 getCurrentFirstTarget() {
        return this.firstTarget();
    }

    private int findSlot(class_1657 player, class_1799 stack) {
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 itemStack = player.method_31548().method_5438(i);
            if (stack != itemStack) continue;
            return i;
        }
        return -1;
    }

    private List<class_1297> findTargets(Spell currentSpell) {
        Spell.Release.Target.Cursor cursor;
        class_746 caster = this.player();
        List<class_1297> previousTargets = this.targets;
        List<Object> targets = List.of();
        if (currentSpell == null || currentSpell.impact == null) {
            return targets;
        }
        boolean fallbackToPreviousTargets = false;
        TargetHelper.TargetingMode targetingMode = SpellHelper.selectionTargetingMode(currentSpell);
        Spell.Release.Target.Type targetType = currentSpell.release.target.type;
        Predicate<class_1297> selectionPredicate = target -> {
            boolean intentAllows = false;
            for (Spell.Impact impact : currentSpell.impact) {
                TargetHelper.Intent intent = SpellHelper.intent(impact.action);
                boolean newValue = impact.action.apply_to_caster ? target == caster : TargetHelper.actionAllowed(targetingMode, intent, (class_1309)caster, target);
                intentAllows = intentAllows || newValue;
            }
            return !SpellEngineClient.config.filterInvalidTargets || intentAllows;
        };
        switch (targetType) {
            case AREA: {
                targets = TargetHelper.targetsFromArea((class_1297)caster, currentSpell.range, currentSpell.release.target.area, selectionPredicate);
                Spell.Release.Target.Area area = currentSpell.release.target.area;
                if (area == null || !area.include_caster) break;
                targets.add((class_1297)caster);
                break;
            }
            case BEAM: {
                targets = TargetHelper.targetsFromRaycast((class_1297)caster, currentSpell.range, selectionPredicate);
                break;
            }
            case PROJECTILE: 
            case CURSOR: 
            case METEOR: {
                fallbackToPreviousTargets = targetType != Spell.Release.Target.Type.PROJECTILE;
                class_1297 target2 = TargetHelper.targetFromRaycast((class_1297)caster, currentSpell.range, selectionPredicate);
                if (target2 != null) {
                    targets = List.of(target2);
                    break;
                }
                targets = List.of();
                break;
            }
        }
        if (fallbackToPreviousTargets && SpellEngineClient.config.stickyTarget && targets.isEmpty()) {
            targets = previousTargets.stream().filter(entity -> TargetHelper.isInLineOfSight((class_1297)caster, entity)).toList();
        }
        if ((cursor = currentSpell.release.target.cursor) != null && cursor.use_caster_as_fallback && targets.isEmpty()) {
            targets = List.of(caster);
        }
        return targets;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick_TAIL_SpellEngine(CallbackInfo ci) {
        this.updateSpellCast();
        class_746 player = this.player();
        if (this.isBeaming()) {
            this.field_3944.method_2883((class_2596)new class_2828.class_2830(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455(), player.method_24828()));
        }
    }
}

