/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.model;

import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.model.GeoModel;
import net.minecraft.class_2960;

public abstract class DefaultedGeoModel<T extends GeoAnimatable>
extends GeoModel<T> {
    private class_2960 modelPath;
    private class_2960 texturePath;
    private class_2960 animationsPath;

    protected DefaultedGeoModel(class_2960 assetSubpath) {
        this.modelPath = this.buildFormattedModelPath(assetSubpath);
        this.texturePath = this.buildFormattedTexturePath(assetSubpath);
        this.animationsPath = this.buildFormattedAnimationPath(assetSubpath);
    }

    public DefaultedGeoModel<T> withAltModel(class_2960 altPath) {
        this.modelPath = this.buildFormattedModelPath(altPath);
        return this;
    }

    public DefaultedGeoModel<T> withAltAnimations(class_2960 altPath) {
        this.animationsPath = this.buildFormattedAnimationPath(altPath);
        return this;
    }

    public DefaultedGeoModel<T> withAltTexture(class_2960 altPath) {
        this.texturePath = this.buildFormattedTexturePath(altPath);
        return this;
    }

    public class_2960 buildFormattedModelPath(class_2960 basePath) {
        return new class_2960(basePath.method_12836(), "geo/" + this.subtype() + "/" + basePath.method_12832() + ".geo.json");
    }

    public class_2960 buildFormattedAnimationPath(class_2960 basePath) {
        return new class_2960(basePath.method_12836(), "animations/" + this.subtype() + "/" + basePath.method_12832() + ".animation.json");
    }

    public class_2960 buildFormattedTexturePath(class_2960 basePath) {
        return new class_2960(basePath.method_12836(), "textures/" + this.subtype() + "/" + basePath.method_12832() + ".png");
    }

    protected abstract String subtype();

    @Override
    public class_2960 getModelResource(T animatable) {
        return this.modelPath;
    }

    @Override
    public class_2960 getTextureResource(T animatable) {
        return this.texturePath;
    }

    public class_2960 getTexture(T animatable) {
        return this.texturePath;
    }

    @Override
    public class_2960 getAnimationResource(T animatable) {
        return this.animationsPath;
    }
}

