/*
 * Decompiled with CFR 0.152.
 */
package konsola5.hephaestusplus.datagen;

import java.util.function.Consumer;
import konsola5.hephaestusplus.HephaestusPlus;
import konsola5.hephaestusplus.datagen.BaseRecipeProvider;
import konsola5.hephaestusplus.ids.MoarMaterialIds;
import konsola5.hephaestusplus.ids.MoarModifierIds;
import konsola5.hephaestusplus.registry.HephPlusFluidRegistry;
import konsola5.hephaestusplus.registry.HephPlusItemRegistry;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.recipe.v1.ingredient.DefaultCustomIngredients;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.DefaultResourceConditions;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import nourl.mythicmetals.item.MythicItems;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.adding.SwappableModifierRecipeBuilder;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.tools.TinkerModifiers;
import wraith.fabricaeexnihilo.modules.ModTags;

public class HephPlusModifierRecipeProvider
extends BaseRecipeProvider {
    public HephPlusModifierRecipeProvider(FabricDataOutput output) {
        super(output);
    }

    @Override
    public void method_10419(@NotNull Consumer<class_2444> consumer) {
        this.addModifierRecipes(consumer);
    }

    @Override
    public String method_10321() {
        return "HephaestusPlus Modifier Recipes";
    }

    private void addModifierRecipes(Consumer<class_2444> consumer) {
        String modifiersFolder = "tools/modifiers/";
        String upgradeFolder = "tools/modifiers/upgrade/";
        String abilityFolder = "tools/modifiers/ability/";
        String slotlessFolder = "tools/modifiers/slotless/";
        String upgradeSalvage = "tools/modifiers/salvage/upgrade/";
        String abilitySalvage = "tools/modifiers/salvage/ability/";
        String defenseFolder = "tools/modifiers/defense/";
        String defenseSalvage = "tools/modifiers/salvage/defense/";
        String compatFolder = "tools/modifiers/compat/";
        String compatSalvage = "tools/modifiers/salvage/compat/";
        String worktableFolder = "tools/modifiers/worktable/";
        Consumer whenFENLoaded = this.withCondition(consumer, new ConditionJsonProvider[]{DefaultResourceConditions.allModsLoaded((String[])new String[]{"fabricaeexnihilo"})});
        Consumer whenMythicMetalsLoaded = this.withCondition(consumer, new ConditionJsonProvider[]{DefaultResourceConditions.allModsLoaded((String[])new String[]{"mythicmetals"})});
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)MoarModifierIds.smashing).setTools(HephPlusModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.HARVEST_PRIMARY))).addInput(ModTags.HAMMERS).setMaxLevel(1)).setSlots(SlotType.ABILITY, 1)).save(whenFENLoaded, this.prefix((class_2960)MoarModifierIds.smashing, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)MoarModifierIds.crooking).setTools(HephPlusModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.HARVEST_PRIMARY))).addInput(ModTags.CROOKS).setMaxLevel(1)).setSlots(SlotType.ABILITY, 1)).save(whenFENLoaded, this.prefix((class_2960)MoarModifierIds.crooking, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)MoarModifierIds.legendary_banglum).setTools(HephPlusModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.HARVEST_PRIMARY))).addInput((class_1935)MythicItems.Mats.BANGLUM_CHUNK).setMaxLevel(1)).setSlots(SlotType.ABILITY, 1)).save(whenMythicMetalsLoaded, this.prefix((class_2960)MoarModifierIds.legendary_banglum, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)MoarModifierIds.carmot_shield).setTools(HephPlusModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.ARMOR))).addInput((class_1935)MythicItems.Templates.CARMOT_SMITHING_TEMPLATE).setMaxLevel(1)).setSlots(SlotType.ABILITY, 1)).save(whenMythicMetalsLoaded, this.prefix((class_2960)MoarModifierIds.carmot_shield, abilityFolder));
        ItemCastingRecipeBuilder.tableRecipe(HephPlusItemRegistry.carmotReinforcement).setFluidAndTime(HephPlusFluidRegistry.moltenCarmot, true, 3000L).setCast((class_1935)TinkerCommons.obsidianPane, true).save(whenMythicMetalsLoaded, this.prefix(HephPlusItemRegistry.carmotReinforcement.getRegistryName(), modifiersFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)MoarModifierIds.carmot_boost).setTools(HephPlusModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.ARMOR))).addInput(HephPlusItemRegistry.carmotReinforcement, 20).setRequirements(ModifierMatch.entry((ModifierId)MoarModifierIds.carmot_shield))).setRequirementsError(HephPlusModifierRecipeProvider.makeRequirementsError("carmot_shield_required"))).setMaxLevel(5)).setSlots(SlotType.DEFENSE, 1)).save(whenMythicMetalsLoaded, this.prefix((class_2960)MoarModifierIds.carmot_boost, defenseFolder));
        this.buildEmbellishment((MaterialVariantId)MoarMaterialIds.adamantite, "adamantite_ingots", consumer);
        this.buildEmbellishment((MaterialVariantId)MoarMaterialIds.aquarium, "aquarium_ingots", consumer);
        this.buildEmbellishment((MaterialVariantId)MoarMaterialIds.banglum, "banglum_ingots", consumer);
        this.buildEmbellishment((MaterialVariantId)MoarMaterialIds.carmot, "carmot_ingots", consumer);
        this.buildEmbellishment((MaterialVariantId)MoarMaterialIds.celestium, "celestium_ingots", consumer);
        this.buildEmbellishment((MaterialVariantId)MoarMaterialIds.durasteel, "durasteel_ingots", consumer);
        this.buildEmbellishment((MaterialVariantId)MoarMaterialIds.hallowed, "hallowed_ingots", consumer);
        this.buildEmbellishment((MaterialVariantId)MoarMaterialIds.kyber, "kyber_ingots", consumer);
        this.buildEmbellishment((MaterialVariantId)MoarMaterialIds.metallurgium, "metallurgium_ingots", consumer);
        this.buildEmbellishment((MaterialVariantId)MoarMaterialIds.mythril, "mythril_ingots", consumer);
        this.buildEmbellishment((MaterialVariantId)MoarMaterialIds.orichalcum, "orichalcum_ingots", consumer);
        this.buildEmbellishment((MaterialVariantId)MoarMaterialIds.palladium, "palladium_ingots", consumer);
        this.buildEmbellishment((MaterialVariantId)MoarMaterialIds.prometheum, "prometheum_ingots", consumer);
        this.buildEmbellishment((MaterialVariantId)MoarMaterialIds.quadrillum, "quadrillum_ingots", consumer);
        this.buildEmbellishment((MaterialVariantId)MoarMaterialIds.runite, "runite_ingots", consumer);
        this.buildEmbellishment((MaterialVariantId)MoarMaterialIds.star_platinum, "star_platinum_ingots", consumer);
        this.buildEmbellishment((MaterialVariantId)MoarMaterialIds.manasteel, "manasteel_ingots", consumer);
        this.buildEmbellishment((MaterialVariantId)MoarMaterialIds.elementium, "elementium_ingots", consumer);
        this.buildEmbellishment((MaterialVariantId)MoarMaterialIds.terrasteel, "terrasteel_ingots", consumer);
    }

    @SafeVarargs
    private static class_1856 ingredientFromTags(class_6862<class_1792> ... tags) {
        class_1856[] tagIngredients = new class_1856[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            tagIngredients[i] = class_1856.method_8106(tags[i]);
        }
        return DefaultCustomIngredients.any((class_1856[])tagIngredients);
    }

    private static String makeRequirementsError(String recipe) {
        return HephaestusPlus.makeTranslationKey("recipe", "modifier." + recipe);
    }

    private void buildEmbellishment(MaterialVariantId material, String tag, Consumer<class_2444> consumer) {
        class_1856 ingot = class_1856.method_8106((class_6862)this.getItemTag("c", tag));
        consumer = this.withCondition(consumer, new ConditionJsonProvider[]{this.tagCondition(tag)});
        ((ModifierRecipeBuilder)SwappableModifierRecipeBuilder.modifier((LazyModifier)TinkerModifiers.embellishment, (String)material.toString()).setTools(TinkerTags.Items.EMBELLISHMENT_METAL)).addInput(ingot).addInput(ingot).addInput(ingot).save(consumer, this.wrap((class_2960)TinkerModifiers.embellishment.getId(), "tools/modifiers/slotless/", "_" + material.getLocation('_').method_12832()));
    }
}

