/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.pt;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class ConfigManager {
    private static final File CONFIG_FILE = new File("./config/projectile_tweaks.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final int CURRENT_VERSION = 2;

    public static ProjectileTweaksConfig loadConfig() {
        ProjectileTweaksConfig projectileTweaksConfig;
        if (!CONFIG_FILE.exists()) {
            System.out.println("[ProjectileTweaks] Config file not found. Creating default config...");
            ProjectileTweaksConfig defaultConfig = ProjectileTweaksConfig.getDefault();
            ConfigManager.saveConfig(defaultConfig);
            return defaultConfig;
        }
        FileReader reader = new FileReader(CONFIG_FILE);
        try {
            ProjectileTweaksConfig loadedConfig = (ProjectileTweaksConfig)GSON.fromJson((Reader)reader, ProjectileTweaksConfig.class);
            if (loadedConfig.version < 2) {
                System.out.println("[ProjectileTweaks] Updating config to version 2...");
                loadedConfig = ConfigManager.migrateConfig(loadedConfig);
                ConfigManager.saveConfig(loadedConfig);
            }
            projectileTweaksConfig = loadedConfig;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                System.err.println("[ProjectileTweaks] Failed to load config. Using defaults.");
                e.printStackTrace();
                return ProjectileTweaksConfig.getDefault();
            }
        }
        reader.close();
        return projectileTweaksConfig;
    }

    private static ProjectileTweaksConfig migrateConfig(ProjectileTweaksConfig oldConfig) {
        ProjectileTweaksConfig defaultConfig = ProjectileTweaksConfig.getDefault();
        defaultConfig.entities.forEach((key, value) -> oldConfig.entities.putIfAbsent((String)key, (Double)value));
        defaultConfig.difficulty_multipliers.forEach((key, value) -> oldConfig.difficulty_multipliers.putIfAbsent((String)key, (Double)value));
        oldConfig.version = 2;
        return oldConfig;
    }

    public static void saveConfig(ProjectileTweaksConfig config) {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)config, (Appendable)writer);
            System.out.println("[ProjectileTweaks] Config saved successfully.");
        }
        catch (Exception e) {
            System.err.println("[ProjectileTweaks] Failed to save config.");
            e.printStackTrace();
        }
    }

    public static class ProjectileTweaksConfig {
        public int version = 2;
        public Map<String, Double> entities = new HashMap<String, Double>();
        public Map<String, Double> difficulty_multipliers = new HashMap<String, Double>();

        public static ProjectileTweaksConfig getDefault() {
            ProjectileTweaksConfig config = new ProjectileTweaksConfig();
            config.entities.put("minecraft:zombie", 0.2);
            config.entities.put("minecraft:skeleton", 0.5);
            config.entities.put("minecraft:creeper", 0.75);
            config.difficulty_multipliers.put("peaceful", -0.05);
            config.difficulty_multipliers.put("easy", -0.25);
            config.difficulty_multipliers.put("normal", 0.0);
            config.difficulty_multipliers.put("hard", 0.25);
            config.difficulty_multipliers.put("hardcore", 0.4);
            return config;
        }
    }
}

