/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.epicknightsnmages.item.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.EnumMap;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.azure.azurelib.animatable.GeoItem;
import mod.azure.azurelib.animatable.client.RenderProvider;
import mod.azure.azurelib.constant.DataTickets;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.renderer.GeoArmorRenderer;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1531;
import net.minecraft.class_156;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_572;
import net.spell_engine.api.item.ConfigurableAttributes;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.SpellSchools;
import net.veroxuniverse.epicknightsnmages.client.armor.WizardArmorRenderer;
import net.veroxuniverse.epicknightsnmages.item.armor.KNMArmor;
import net.veroxuniverse.epicknightsnmages.registry.ItemsRegistry;

public class WizardArmor
extends KNMArmor
implements ConfigurableAttributes {
    private Multimap<class_1320, class_1322> attributes;
    private static final EnumMap<class_1738.class_8051, UUID> MODIFIERS = (EnumMap)class_156.method_654(new EnumMap(class_1738.class_8051.class), uuidMap -> {
        uuidMap.put(class_1738.class_8051.field_41937, UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"));
        uuidMap.put(class_1738.class_8051.field_41936, UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"));
        uuidMap.put(class_1738.class_8051.field_41935, UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"));
        uuidMap.put(class_1738.class_8051.field_41934, UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150"));
    });
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);

    public WizardArmor(class_1741 material, class_1738.class_8051 type, class_1792.class_1793 settings) {
        super(material, type, settings);
    }

    public void setAttributes(Multimap<class_1320, class_1322> attributes) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(attributes);
        UUID uuid = MODIFIERS.get(this.field_41933);
        builder.put((Object)SpellSchools.ARCANE.attribute, (Object)new class_1322(uuid, "armorArcaneModifier", 2.0, class_1322.class_1323.field_6328));
        builder.put((Object)SpellSchools.FIRE.attribute, (Object)new class_1322(uuid, "armorFireModifier", 2.0, class_1322.class_1323.field_6328));
        builder.put((Object)SpellSchools.FROST.attribute, (Object)new class_1322(uuid, "armorFrostModifier", 2.0, class_1322.class_1323.field_6328));
        builder.put((Object)SpellPowerMechanics.HASTE.attribute, (Object)new class_1322(uuid, "armorHasteModifier", 0.02, class_1322.class_1323.field_6331));
        this.attributes = builder.build();
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        if (this.attributes == null) {
            return super.method_7844(slot);
        }
        return slot == this.field_41933.method_48399() ? this.attributes : super.method_7844(slot);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 20, state -> {
            state.setAnimation(RawAnimation.begin().then("animation.elite_mage.idle", Animation.LoopType.LOOP));
            class_1297 entity = (class_1297)state.getData(DataTickets.ENTITY);
            if (entity instanceof class_1531) {
                return PlayState.CONTINUE;
            }
            ObjectOpenHashSet wornArmor = new ObjectOpenHashSet();
            for (class_1799 stack : entity.method_5661()) {
                if (stack.method_7960()) {
                    return PlayState.STOP;
                }
                wornArmor.add(stack.method_7909());
            }
            boolean isFullSet = wornArmor.containsAll((Collection<?>)ObjectArrayList.of((Object[])new WizardArmor[]{ItemsRegistry.ELITE_MAGE_HELMET, ItemsRegistry.ELITE_MAGE_CHESTPLATE, ItemsRegistry.ELITE_MAGE_LEGGINGS, ItemsRegistry.ELITE_MAGE_BOOTS}));
            return isFullSet ? PlayState.CONTINUE : PlayState.STOP;
        })});
    }

    @Override
    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private GeoArmorRenderer<?> renderer;

            public class_572<class_1309> getHumanoidArmorModel(class_1309 livingEntity, class_1799 itemStack, class_1304 equipmentSlot, class_572<class_1309> original) {
                if (this.renderer == null) {
                    this.renderer = new WizardArmorRenderer();
                }
                this.renderer.prepForRender((class_1297)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void method_7888(class_1799 itemStack, class_1937 level, class_1297 entity, int i, boolean bl) {
        super.method_7888(itemStack, level, entity, i, bl);
    }

    @Override
    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }
}

