/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import virtuoel.pehkui.util.ModLoaderUtils;
import virtuoel.pehkui.util.ReflectionUtils;

public class IdentityCompatibility {
    private static final boolean IDENTITY_LOADED = ModLoaderUtils.isModLoaded("identity");
    public static final IdentityCompatibility INSTANCE = new IdentityCompatibility();
    private final Optional<Class<?>> componentsClass;
    private final Optional<Class<?>> componentTypeClass;
    private final Optional<Class<?>> identityComponentClass;
    private final Optional<Class<?>> playerIdentityClass;
    private final Optional<Object> currentIdentity;
    private final Optional<Method> getComponent;
    private final Optional<Method> getIdentity;
    private boolean enabled = IDENTITY_LOADED;

    private IdentityCompatibility() {
        if (this.enabled) {
            this.componentsClass = ReflectionUtils.getClass("draylar.identity.registry.Components");
            this.componentTypeClass = ReflectionUtils.getClass("nerdhub.cardinal.components.api.ComponentType");
            this.identityComponentClass = ReflectionUtils.getClass("draylar.identity.cca.IdentityComponent");
            this.playerIdentityClass = ReflectionUtils.getClass("draylar.identity.api.PlayerIdentity");
            this.currentIdentity = ReflectionUtils.getField(this.componentsClass, "CURRENT_IDENTITY").map(f -> {
                try {
                    return f.get(null);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    return Optional.empty();
                }
            });
            this.getComponent = ReflectionUtils.getMethod(this.componentTypeClass, "get", Object.class);
            this.getIdentity = ReflectionUtils.getMethod(this.identityComponentClass.isPresent() ? this.identityComponentClass : this.playerIdentityClass, "getIdentity", new Class[0]);
        } else {
            this.componentsClass = Optional.empty();
            this.componentTypeClass = Optional.empty();
            this.identityComponentClass = Optional.empty();
            this.playerIdentityClass = Optional.empty();
            this.currentIdentity = Optional.empty();
            this.getComponent = Optional.empty();
            this.getIdentity = Optional.empty();
        }
    }

    public class_1309 getIdentity(class_1657 entity) {
        if (this.enabled) {
            return (this.identityComponentClass.isPresent() ? this.currentIdentity.flatMap(t -> this.getComponent.flatMap(c -> this.getIdentity.map(m -> {
                try {
                    return (class_1309)m.invoke(c.invoke(t, entity), new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    return null;
                }
            }))) : this.getIdentity.map(m -> {
                try {
                    return (class_1309)m.invoke(null, entity);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    return null;
                }
            })).orElse(null);
        }
        return null;
    }
}

