/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.mixin;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.lyof.phantasm.Phantasm;
import net.lyof.phantasm.world.ModWorldGeneration;
import net.lyof.phantasm.world.biome.EndDataCompat;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_6544.class_6547.class}, priority=1004)
public abstract class MultiNoiseUtilEntriesMixin<T> {
    @Unique
    private final List<Pair<class_6544.class_4762, T>> endEntries = new ArrayList<Pair<class_6544.class_4762, T>>();

    @Shadow
    public abstract List<Pair<class_6544.class_4762, T>> method_38128();

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/biome/source/util/MultiNoiseUtil$SearchTree;create(Ljava/util/List;)Lnet/minecraft/world/biome/source/util/MultiNoiseUtil$SearchTree;")})
    public void addEndBiomes(List<Pair<class_6544.class_4762, T>> entries, CallbackInfo ci) {
        class_6544.class_4762 highlands = null;
        for (Pair<class_6544.class_4762, T> e : entries) {
            class_6880 r;
            Object object = e.getSecond();
            if (!(object instanceof class_6880) || !(r = (class_6880)object).method_40225(class_1972.field_9442)) continue;
            highlands = (class_6544.class_4762)e.getFirst();
        }
        if (highlands != null && ModWorldGeneration.LOOKUP != null) {
            int customCount = EndDataCompat.getEnabledBiomes().size();
            int j = 0;
            for (class_5321 class_53212 : EndDataCompat.getEnabledBiomes()) {
                Phantasm.log("Adding " + class_53212.method_29177() + " to the End biome source at slice " + (j / 2 + 1) + " out of " + customCount);
                this.endEntries.add(new Pair((Object)MultiNoiseUtilEntriesMixin.splitHypercube(highlands, customCount, j), (Object)ModWorldGeneration.LOOKUP.method_46747(class_53212)));
                j += 2;
            }
            this.endEntries.addAll(entries.stream().filter(p -> {
                class_5321 k;
                Object patt2870$temp;
                class_6880 r;
                Object patt2750$temp = p.getSecond();
                return patt2750$temp instanceof class_6880 && !(r = (class_6880)patt2750$temp).method_40225(class_1972.field_9442) && (!((patt2870$temp = r.method_40230().get()) instanceof class_5321) || !EndDataCompat.contains((class_5321<class_1959>)(k = (class_5321)patt2870$temp)));
            }).toList());
            for (int i = 1; i <= customCount; i += 2) {
                this.endEntries.add(new Pair((Object)MultiNoiseUtilEntriesMixin.splitHypercube(highlands, customCount, i), (Object)ModWorldGeneration.LOOKUP.method_46747(class_1972.field_9442)));
            }
        }
    }

    private static class_6544.class_4762 splitHypercube(class_6544.class_4762 base, int biomes, int i) {
        biomes = biomes * 2 - 1;
        if (EndDataCompat.getCompatibilityMode().equals("endercon")) {
            return class_6544.method_38118((class_6544.class_6546)MultiNoiseUtilEntriesMixin.splitRange(base.comp_105(), biomes, i), (class_6544.class_6546)base.comp_106(), (class_6544.class_6546)base.comp_107(), (class_6544.class_6546)base.comp_108(), (class_6544.class_6546)base.comp_109(), (class_6544.class_6546)base.comp_110(), (float)((float)base.comp_111() / 10000.0f));
        }
        if (EndDataCompat.getCompatibilityMode().equals("nullscape")) {
            return class_6544.method_38118((class_6544.class_6546)base.comp_105(), (class_6544.class_6546)base.comp_106(), (class_6544.class_6546)base.comp_107(), (class_6544.class_6546)base.comp_108(), (class_6544.class_6546)base.comp_109(), (class_6544.class_6546)MultiNoiseUtilEntriesMixin.splitRange(base.comp_110(), biomes, i), (float)((float)base.comp_111() / 10000.0f));
        }
        return class_6544.method_38118((class_6544.class_6546)base.comp_105(), (class_6544.class_6546)base.comp_106(), (class_6544.class_6546)MultiNoiseUtilEntriesMixin.splitRange(base.comp_107(), biomes, i), (class_6544.class_6546)base.comp_108(), (class_6544.class_6546)base.comp_109(), (class_6544.class_6546)base.comp_110(), (float)((float)base.comp_111() / 10000.0f));
    }

    private static class_6544.class_6546 splitRange(class_6544.class_6546 point, int biomes, int i) {
        long min = MultiNoiseUtilEntriesMixin.getRange(point) / (long)biomes * (long)i + point.comp_103();
        long max = MultiNoiseUtilEntriesMixin.getRange(point) / (long)biomes * (long)(i + 1) + point.comp_103();
        return class_6544.class_6546.method_38121((float)((float)min / 10000.0f), (float)((float)max / 10000.0f));
    }

    private static long getRange(class_6544.class_6546 point) {
        return point.comp_104() - point.comp_103();
    }

    @ModifyArg(method={"<init>"}, index=0, at=@At(value="INVOKE", target="Lnet/minecraft/world/biome/source/util/MultiNoiseUtil$SearchTree;create(Ljava/util/List;)Lnet/minecraft/world/biome/source/util/MultiNoiseUtil$SearchTree;"))
    public List<Pair<class_6544.class_4762, T>> modifyTree(List<Pair<class_6544.class_4762, T>> entries) {
        return this.method_38128();
    }

    @Inject(method={"getEntries"}, at={@At(value="HEAD")}, cancellable=true)
    public void redirectEntries(CallbackInfoReturnable<List<Pair<class_6544.class_4762, T>>> cir) {
        if (!this.endEntries.isEmpty()) {
            cir.setReturnValue(this.endEntries);
        }
    }
}

