/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.attributeslib.client;

import dev.shadowsoffire.attributeslib.api.AttributeHelper;
import dev.shadowsoffire.attributeslib.client.ModifierSource;
import dev.shadowsoffire.attributeslib.util.Comparators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1799;

public abstract class ModifierSourceType<T> {
    private static final List<ModifierSourceType<?>> SOURCE_TYPES = new ArrayList();
    public static final ModifierSourceType<class_1799> EQUIPMENT = ModifierSourceType.register(new ModifierSourceType<class_1799>(){

        @Override
        public void extract(class_1309 entity, BiConsumer<class_1322, ModifierSource<?>> map) {
            for (class_1304 slot : class_1304.values()) {
                class_1799 item = entity.method_6118(slot);
                item.method_7926(slot).values().forEach(modif -> map.accept((class_1322)modif, new ModifierSource.ItemModifierSource(item)));
            }
        }

        @Override
        public int getPriority() {
            return 0;
        }
    });
    public static final ModifierSourceType<class_1293> MOB_EFFECT = ModifierSourceType.register(new ModifierSourceType<class_1293>(){

        @Override
        public void extract(class_1309 entity, BiConsumer<class_1322, ModifierSource<?>> map) {
            for (class_1293 effectInst : entity.method_6026()) {
                effectInst.method_5579().method_5565().values().forEach(modif -> map.accept((class_1322)modif, new ModifierSource.EffectModifierSource(effectInst)));
            }
        }

        @Override
        public int getPriority() {
            return 100;
        }
    });

    public static Collection<ModifierSourceType<?>> getTypes() {
        return Collections.unmodifiableCollection(SOURCE_TYPES);
    }

    public static <T extends ModifierSourceType<?>> T register(T type) {
        SOURCE_TYPES.add(type);
        return type;
    }

    public static Comparator<class_1322> compareBySource(Map<UUID, ModifierSource<?>> sources) {
        Comparator comp = Comparators.chained(Comparator.comparingInt(a -> ((ModifierSource)sources.get(a.method_6189())).getType().getPriority()), Comparator.comparing(a -> (ModifierSource)sources.get(a.method_6189())), AttributeHelper.modifierComparator());
        return (a1, a2) -> {
            ModifierSource src1 = (ModifierSource)sources.get(a1.method_6189());
            ModifierSource src2 = (ModifierSource)sources.get(a2.method_6189());
            if (src1 != null && src2 != null) {
                return comp.compare(a1, a2);
            }
            return src1 != null ? -1 : (src2 != null ? 1 : 0);
        };
    }

    public abstract void extract(class_1309 var1, BiConsumer<class_1322, ModifierSource<?>> var2);

    public abstract int getPriority();
}

