/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.wildlife.entity.ai;

import com.yahoo.chirpycricket.wildlife.entity.LargeAquaticWildlifeEntity;
import com.yahoo.chirpycricket.wildlife.entity.WildlifeEntity;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.EasingType;
import software.bernie.geckolib.core.object.PlayState;

public class WildlifeAnimationManager {
    private WildlifeEntity smallEntity;
    protected AnimationController<WildlifeEntity> animationController;
    protected AnimationController<WildlifeEntity> blinkAnimationController;

    public WildlifeAnimationManager(WildlifeEntity entity) {
        this.smallEntity = entity;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animationData) {
        this.animationController = new AnimationController((GeoAnimatable)this.smallEntity, "moveController", 0, this::moveAnimationPredicate);
        this.blinkAnimationController = new AnimationController((GeoAnimatable)this.smallEntity, "blinkController", 0, this::blinkAnimationPredicate);
        animationData.add(new AnimationController[]{this.animationController, this.blinkAnimationController});
    }

    protected <P extends GeoEntity> PlayState moveAnimationPredicate(AnimationState<P> event) {
        this.animationController.setOverrideEasingType(EasingType.LINEAR);
        this.animationController.transitionLength(this.smallEntity.animationReset);
        if (this.smallEntity instanceof LargeAquaticWildlifeEntity && !this.smallEntity.method_5869()) {
            event.getController().setAnimation(this.smallEntity.getFlopAnimation());
        } else if (event.isMoving() || this.smallEntity.method_18798().field_1351 > 0.0) {
            event.getController().setAnimation(this.smallEntity.getWalkAnimation());
        } else if (this.smallEntity.songPlaying) {
            event.getController().setAnimation(this.smallEntity.getDanceAnimation());
        } else {
            event.getController().setAnimation(this.smallEntity.getIdleAnimation());
        }
        return PlayState.CONTINUE;
    }

    protected <P extends GeoEntity> PlayState blinkAnimationPredicate(AnimationState<P> event) {
        this.blinkAnimationController.transitionLength(0);
        this.blinkAnimationController.setAnimation(this.smallEntity.getBlinkAnimation());
        return PlayState.CONTINUE;
    }
}

