/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.wildlife.client.model;

import com.yahoo.chirpycricket.wildlife.entity.WildlifeEntity;
import net.minecraft.class_2960;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class AnimatedLivingEntityModel<T extends WildlifeEntity>
extends DefaultedEntityGeoModel<T> {
    public final String geoFile;
    public final String aniFile;
    public final String texFile;
    protected float size = 1.0f;
    protected float headSize = 1.0f;
    protected float scaleAdjustment = 1.0f;

    public AnimatedLivingEntityModel(String geometryFile, String animationFile, String textureFile) {
        super(new class_2960("wildlife", geometryFile), true);
        this.geoFile = geometryFile;
        this.aniFile = animationFile;
        this.texFile = textureFile;
    }

    public void setSuperLivingAnimations(T entity, Integer uniqueID, AnimationState<T> customPredicate) {
        super.setCustomAnimations(entity, (long)uniqueID.intValue(), customPredicate);
    }

    public class_2960 getModelResource(T entity) {
        return new class_2960("wildlife", this.geoFile);
    }

    public class_2960 getAnimationResource(T animatable) {
        return new class_2960("wildlife", this.aniFile);
    }

    public class_2960 getTextureResource(T entity) {
        T ge;
        if (entity instanceof WildlifeEntity && ((WildlifeEntity)((Object)(ge = entity))).getTextureFile().length() > "textures/model/entity/".length()) {
            return new class_2960("wildlife", ((WildlifeEntity)((Object)ge)).getTextureFile());
        }
        return new class_2960("wildlife", this.texFile);
    }

    public void setCustomAnimations(T entity, long uniqueID, AnimationState<T> customPredicate) {
        super.setCustomAnimations(entity, uniqueID, customPredicate);
        T WildlifeEntity2 = entity;
        this.setHeadRotation(customPredicate);
        if (((WildlifeEntity)((Object)entity)).varyScale) {
            this.applyScale(entity);
        }
    }

    public void setHeadRotation(AnimationState<T> customPredicate) {
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        EntityModelData extraData = (EntityModelData)customPredicate.getData(DataTickets.ENTITY_MODEL_DATA);
        if (head != null) {
            head.setRotY(extraData.netHeadYaw() * ((float)Math.PI / 180));
            head.setRotX(extraData.headPitch() * ((float)Math.PI / 180));
        }
    }

    public void applyScale(T entity) {
        if (entity.method_6109()) {
            this.size = ((WildlifeEntity)((Object)entity)).childScale;
            this.headSize = ((WildlifeEntity)((Object)entity)).childHeadScale;
        } else {
            this.size = ((WildlifeEntity)((Object)entity)).getScale();
            if (this.size == 0.0f) {
                this.size = 1.0f;
            }
            this.headSize = 1.0f;
        }
        float actualScale = this.scaleAdjustment * this.size;
        float actualHeadScale = this.headSize;
        CoreGeoBone scale = this.getAnimationProcessor().getBone("scale");
        if (scale != null) {
            CoreGeoBone head;
            scale.setScaleX(actualScale);
            scale.setScaleY(actualScale);
            scale.setScaleZ(actualScale);
            if (entity.method_6109() && (head = this.getAnimationProcessor().getBone("head")) != null) {
                head.setScaleX(actualHeadScale);
                head.setScaleY(actualHeadScale);
                head.setScaleZ(actualHeadScale);
            }
        }
    }
}

