/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.sound.registrar;

import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.sound.registrar.impl.ChainableNoteSoundRegistrar;
import com.cstav.genshinstrument.sound.registrar.impl.ChainedNoteSoundRegistrar;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class NoteSoundRegistrar
extends ChainableNoteSoundRegistrar<NoteSound, NoteSoundRegistrar> {
    public static final String STEREO_SUFFIX = "_stereo";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final HashMap<class_2960, NoteSound[]> SOUNDS_REGISTRY = new HashMap();

    public static NoteSound[] getSounds(class_2960 baseSoundName) {
        return SOUNDS_REGISTRY.get(baseSoundName);
    }

    public NoteSoundRegistrar(class_2960 baseSoundLocation) {
        super(baseSoundLocation);
    }

    @Override
    public NoteSoundRegistrar getThis() {
        return this;
    }

    public NoteSoundRegistrar alreadyRegistered() {
        this.paramsMap.put("ALREADY_REGISTERED", true);
        return this.getThis();
    }

    public NoteSoundRegistrar stereo() {
        this.paramsMap.put("HAS_STEREO", true);
        return this.getThis();
    }

    public NoteSound[] register(NoteSound[] noteSounds) {
        SOUNDS_REGISTRY.put(this.baseSoundLocation, noteSounds);
        LOGGER.info("Successfully registered " + noteSounds.length + " note sounds of " + this.baseSoundLocation);
        return noteSounds;
    }

    public NoteSound[] registerGrid(int rows, int columns) {
        NoteSound[] sounds = new NoteSound[rows * columns];
        for (int i = 0; i < sounds.length; ++i) {
            sounds[i] = this.createNote(i);
        }
        return this.register(sounds);
    }

    public NoteSound[] registerGrid() {
        return this.registerGrid(7, 3);
    }

    protected NoteSound createNote(class_2960 soundLocation, int index, Map<String, Object> paramMap) {
        NoteSound sound = new NoteSound(index, this.baseSoundLocation);
        this.setSoundField(soundEvent -> {
            sound.mono = soundEvent;
            return sound.mono;
        }, soundLocation);
        if (NoteSoundRegistrar.getBool(paramMap, "HAS_STEREO")) {
            this.setSoundField(soundEvent -> {
                sound.stereo = soundEvent;
                return sound.stereo;
            }, soundLocation.method_48331(STEREO_SUFFIX));
        }
        return sound;
    }

    protected NoteSound createNote(class_2960 soundLocation, int index) {
        return this.createNote(soundLocation, index, this.paramsMap);
    }

    protected void setSoundField(Function<class_3414, class_3414> fieldConsumer, class_2960 soundLocation) {
        if (NoteSoundRegistrar.getBool(this.paramsMap, "ALREADY_REGISTERED")) {
            fieldConsumer.apply((class_3414)class_7923.field_41172.method_10223(soundLocation));
        } else {
            class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)soundLocation, (Object)fieldConsumer.apply(class_3414.method_47908((class_2960)soundLocation)));
        }
    }

    public Chained chain(class_2960 soundLocation) {
        return new Chained(soundLocation);
    }

    @Override
    protected IntFunction<NoteSound[]> noteArrayGenerator() {
        return NoteSound[]::new;
    }

    public NoteSound registerNote() {
        return this.createNote(this.baseSoundLocation, 0);
    }

    public NoteSound createNote(int noteIndex) {
        return this.createNote(this.baseSoundLocation.method_48331("_note_" + noteIndex), noteIndex);
    }

    public final class Chained
    extends ChainedNoteSoundRegistrar<NoteSound, NoteSoundRegistrar> {
        private final class_2960 soundLocation;

        public Chained(class_2960 soundLocation) {
            super(NoteSoundRegistrar.this.getThis());
            this.soundLocation = soundLocation;
        }

        @Override
        protected NoteSound createNote() {
            return NoteSoundRegistrar.this.createNote(this.soundLocation, NoteSoundRegistrar.this.stackedSounds.size(), NoteSoundRegistrar.this.paramsMap);
        }

        public ChainedNoteSoundRegistrar<NoteSound, NoteSoundRegistrar> alreadyRegistered() {
            NoteSoundRegistrar.this.paramsMap.put("ALREADY_REGISTERED", true);
            return this.getThis();
        }

        public ChainedNoteSoundRegistrar<NoteSound, NoteSoundRegistrar> stereo() {
            NoteSoundRegistrar.this.paramsMap.put("HAS_STEREO", true);
            return this.getThis();
        }
    }
}

